/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.panel.Utility;

public final class FreeColActionUI
extends OptionUI<FreeColAction>
implements ActionListener {
    private OptionGroupUI optionGroupUI = null;
    private KeyStroke keyStroke;
    private final JButton recordButton;
    private final JButton removeButton;
    private final BlinkingLabel bl;
    private final JPanel panel = new JPanel();

    public FreeColActionUI(FreeColAction option, boolean editable) {
        super(option, editable);
        this.keyStroke = option.getAccelerator();
        this.panel.add(this.getJLabel());
        this.bl = new BlinkingLabel();
        this.panel.add(this.bl);
        this.recordButton = new JButton(FreeColActionUI.getRecordImage());
        this.recordButton.addActionListener(this);
        this.panel.add(this.recordButton);
        this.removeButton = new JButton(FreeColActionUI.getRemoveImage());
        this.removeButton.addActionListener(this);
        this.panel.add(this.removeButton);
        this.initialize();
    }

    public static ImageIcon getRecordImage() {
        int imageSize = (int)(9.0f * FontLibrary.getFontScaling());
        int strokeSize = (int)(1.0f * FontLibrary.getFontScaling());
        int circleSize = imageSize - strokeSize * 2;
        BufferedImage bi = new BufferedImage(imageSize, imageSize, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.RED);
        g.fillOval(strokeSize, strokeSize, circleSize, circleSize);
        g.setColor(Color.BLACK);
        g.drawOval(strokeSize, strokeSize, circleSize, circleSize);
        g.dispose();
        return new ImageIcon(bi);
    }

    public static ImageIcon getRemoveImage() {
        int imageSize = (int)(9.0f * FontLibrary.getFontScaling());
        int strokeSize = (int)(2.0f * FontLibrary.getFontScaling());
        BufferedImage bi = new BufferedImage(imageSize, imageSize, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(strokeSize + 1));
        g.drawLine(strokeSize, strokeSize, imageSize - strokeSize, imageSize - strokeSize);
        g.drawLine(imageSize - strokeSize, strokeSize, strokeSize, imageSize - strokeSize);
        g.setColor(Color.RED);
        g.setStroke(new BasicStroke(strokeSize));
        g.drawLine(strokeSize, strokeSize, imageSize - strokeSize, imageSize - strokeSize);
        g.drawLine(imageSize - strokeSize, strokeSize, strokeSize, imageSize - strokeSize);
        return new ImageIcon(bi);
    }

    public static String getHumanKeyStrokeText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return " ";
        }
        Object s = InputEvent.getModifiersExText(keyStroke.getModifiers());
        if (!((String)s).isEmpty()) {
            s = (String)s + "+";
        }
        return (String)s + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public void removeKeyStroke(KeyStroke k) {
        if (k != null && this.keyStroke != null && k.getKeyCode() == this.keyStroke.getKeyCode() && k.getModifiers() == this.keyStroke.getModifiers()) {
            this.keyStroke = null;
            this.bl.setText(" ");
        }
    }

    public void setOptionGroupUI(OptionGroupUI ui) {
        this.optionGroupUI = ui;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.recordButton) {
            this.bl.startBlinking();
            this.bl.requestFocus();
        } else if (ae.getSource() == this.removeButton) {
            this.bl.stopBlinking();
            this.bl.setText(" ");
            this.keyStroke = null;
        }
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        ((FreeColAction)this.getOption()).setAccelerator(this.keyStroke);
    }

    @Override
    public void reset() {
        this.keyStroke = ((FreeColAction)this.getOption()).getAccelerator();
        this.bl.setText(FreeColActionUI.getHumanKeyStrokeText(this.keyStroke));
    }

    class BlinkingLabel
    extends JLabel
    implements ActionListener,
    KeyListener,
    MouseListener {
        private final Timer blinkingTimer;
        private boolean blinkOn;

        BlinkingLabel() {
            super(FreeColActionUI.getHumanKeyStrokeText(FreeColActionUI.this.keyStroke), 0);
            this.blinkingTimer = new Timer(500, this);
            this.blinkOn = false;
            this.setOpaque(false);
            this.setBorder(Utility.getTrivialLineBorder());
            this.addKeyListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.startBlinking();
                this.requestFocus();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension((int)(80.0f * FontLibrary.getFontScaling()), super.getMinimumSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void startBlinking() {
            this.blinkingTimer.start();
        }

        public void stopBlinking() {
            this.blinkingTimer.stop();
            this.setOpaque(false);
            this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyStroke ks = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiersEx());
            if (FreeColActionUI.this.optionGroupUI != null) {
                FreeColActionUI.this.optionGroupUI.removeKeyStroke(ks);
            }
            FreeColActionUI.this.keyStroke = ks;
            this.stopBlinking();
            this.setText(FreeColActionUI.getHumanKeyStrokeText(FreeColActionUI.this.keyStroke));
            FreeColActionUI.this.recordButton.requestFocus();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.hasFocus()) {
                this.stopBlinking();
            }
            if (this.blinkOn) {
                this.setOpaque(false);
                this.blinkOn = false;
                this.repaint();
            } else {
                this.setOpaque(true);
                this.setBackground(Color.RED);
                this.blinkOn = true;
                this.repaint();
            }
        }
    }
}

