/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;

public abstract class BaseHttpProtocolDecoder
extends BaseProtocolDecoder {
    public BaseHttpProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public void sendResponse(Channel channel, HttpResponseStatus status) {
        this.sendResponse(channel, status, null);
    }

    public void sendResponse(Channel channel, HttpResponseStatus status, ByteBuf buf) {
        if (channel != null) {
            if (buf == null) {
                buf = Unpooled.buffer((int)0);
            }
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buf);
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buf.readableBytes());
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }
}

