/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.AtomicUpdateDocumentMerger;
import org.apache.solr.update.processor.Signature;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;

public class SignatureUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private List<String> sigFields;
    private String signatureField;
    private Term signatureTerm;
    private boolean enabled = true;
    private String signatureClass;
    private boolean overwriteDupes;
    private SolrParams params;

    @Override
    public void init(NamedList<?> args) {
        if (args != null) {
            boolean enabled;
            SolrParams params = args.toSolrParams();
            this.enabled = enabled = params.getBool("enabled", true);
            this.overwriteDupes = params.getBool("overwriteDupes", true);
            this.signatureField = params.get("signatureField", "signatureField");
            this.signatureClass = params.get("signatureClass", "org.apache.solr.update.processor.Lookup3Signature");
            this.params = params;
            Object fields = args.get("fields");
            List<String> list = this.sigFields = fields == null ? null : StrUtils.splitSmart((String)((String)fields), (String)",", (boolean)true);
            if (this.sigFields != null) {
                Collections.sort(this.sigFields);
            }
        }
    }

    @Override
    public void inform(SolrCore core) {
        IndexSchema schema = core.getLatestSchema();
        SchemaField field = schema.getFieldOrNull(this.getSignatureField());
        if (null == field) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't use signatureField which does not exist in schema: " + this.getSignatureField());
        }
        if (this.getOverwriteDupes() && !field.indexed()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't set overwriteDupes when signatureField is not indexed: " + this.getSignatureField());
        }
        if (this.getOverwriteDupes() && null != core.getCoreDescriptor().getCloudDescriptor() && !field.equals(schema.getUniqueKeyField())) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't use overwriteDupes safely in SolrCloud when signatureField is not the uniqueKeyField: " + schema.getUniqueKeyField().getName());
        }
    }

    public List<String> getSigFields() {
        return this.sigFields;
    }

    public String getSignatureField() {
        return this.signatureField;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getSignatureClass() {
        return this.signatureClass;
    }

    public boolean getOverwriteDupes() {
        return this.overwriteDupes;
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new SignatureUpdateProcessor(req, rsp, this, next);
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    class SignatureUpdateProcessor
    extends UpdateRequestProcessor {
        private final SolrQueryRequest req;

        public SignatureUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, SignatureUpdateProcessorFactory factory, UpdateRequestProcessor next) {
            super(next);
            this.req = req;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (SignatureUpdateProcessorFactory.this.enabled) {
                SolrInputDocument doc = cmd.getSolrInputDocument();
                List<String> currDocSigFields = null;
                boolean isPartialUpdate = AtomicUpdateDocumentMerger.isAtomicUpdate(cmd);
                if (SignatureUpdateProcessorFactory.this.sigFields == null || SignatureUpdateProcessorFactory.this.sigFields.size() == 0) {
                    if (isPartialUpdate) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't use SignatureUpdateProcessor with partial updates on signature fields");
                    }
                    Collection docFields = doc.getFieldNames();
                    currDocSigFields = new ArrayList<String>(docFields.size());
                    currDocSigFields.addAll(docFields);
                    Collections.sort(currDocSigFields);
                } else {
                    currDocSigFields = SignatureUpdateProcessorFactory.this.sigFields;
                }
                Signature sig = this.req.getCore().getResourceLoader().newInstance(SignatureUpdateProcessorFactory.this.signatureClass, Signature.class);
                sig.init(SignatureUpdateProcessorFactory.this.params);
                for (String field : currDocSigFields) {
                    SolrInputField f = doc.getField(field);
                    if (f == null) continue;
                    if (isPartialUpdate) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't use SignatureUpdateProcessor with partial update request containing signature field: " + field);
                    }
                    sig.add(field);
                    Object o = f.getValue();
                    if (o instanceof Collection) {
                        for (Object oo : (Collection)o) {
                            sig.add(String.valueOf(oo));
                        }
                        continue;
                    }
                    sig.add(String.valueOf(o));
                }
                byte[] signature = sig.getSignature();
                char[] arr = new char[signature.length << 1];
                for (int i = 0; i < signature.length; ++i) {
                    byte b = signature[i];
                    int idx = i << 1;
                    arr[idx] = StrUtils.HEX_DIGITS[b >> 4 & 0xF];
                    arr[idx + 1] = StrUtils.HEX_DIGITS[b & 0xF];
                }
                String sigString = new String(arr);
                doc.addField(SignatureUpdateProcessorFactory.this.signatureField, (Object)sigString);
                if (SignatureUpdateProcessorFactory.this.overwriteDupes) {
                    cmd.updateTerm = new Term(SignatureUpdateProcessorFactory.this.signatureField, sigString);
                }
            }
            if (this.next != null) {
                this.next.processAdd(cmd);
            }
        }
    }
}

