/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.api.endpoint.ForceLeaderApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceLeader
extends AdminAPIBase
implements ForceLeaderApi {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public ForceLeader(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse forceShardLeader(String collectionName, String shardName) {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        ForceLeader.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        this.doForceLeaderElection(collectionName, shardName);
        return response;
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest request, SolrQueryResponse response) {
        ForceLeader api = new ForceLeader(coreContainer, request, response);
        SolrParams params = request.getParams();
        params.required().check(new String[]{"collection", "shard"});
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(response, api.forceShardLeader(params.get("collection"), params.get("shard")));
    }

    private void doForceLeaderElection(String extCollectionName, String shardName) {
        ZkController zkController = this.coreContainer.getZkController();
        ClusterState clusterState = zkController.getClusterState();
        String collectionName = zkController.zkStateReader.getAliases().resolveSimpleAlias(extCollectionName);
        log.info("Force leader invoked, state: {}", (Object)clusterState);
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice slice = collection.getSlice(shardName);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + shardName + " exists for collection " + collectionName);
        }
        try (ZkShardTerms zkShardTerms = new ZkShardTerms(collectionName, slice.getName(), zkController.getZkClient());){
            Replica leader = slice.getLeader();
            if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard already has an active leader. Force leader is not applicable. State: " + slice);
            }
            Set liveNodes = clusterState.getLiveNodes();
            List liveReplicas = slice.getReplicas().stream().filter(rep -> liveNodes.contains(rep.getNodeName())).collect(Collectors.toList());
            boolean shouldIncreaseReplicaTerms = liveReplicas.stream().noneMatch(rep -> zkShardTerms.registered(rep.getName()) && zkShardTerms.canBecomeLeader(rep.getName()));
            if (shouldIncreaseReplicaTerms) {
                liveReplicas.stream().filter(rep -> zkShardTerms.registered(rep.getName())).forEach(rep -> zkShardTerms.setTermEqualsToLeader(rep.getName()));
            }
            boolean success = false;
            for (int i = 0; i < 9; ++i) {
                Thread.sleep(5000L);
                clusterState = this.coreContainer.getZkController().getClusterState();
                collection = clusterState.getCollection(collectionName);
                slice = collection.getSlice(shardName);
                if (slice.getLeader() != null && slice.getLeader().getState() == Replica.State.ACTIVE) {
                    success = true;
                    break;
                }
                log.warn("Force leader attempt {}. Waiting 5 secs for an active leader. State of the slice: {}", (Object)(i + 1), (Object)slice);
            }
            if (success) {
                log.info("Successfully issued FORCELEADER command for collection: {}, shard: {}", (Object)collectionName, (Object)shardName);
            } else {
                log.info("Couldn't successfully force leader, collection: {}, shard: {}. Cluster state: {}", new Object[]{collectionName, shardName, clusterState});
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing FORCELEADER operation for collection: " + collectionName + " shard: " + shardName, (Throwable)e);
        }
    }
}

