/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.Objects;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;

public class OverseerSolrResponseSerializer {
    public static byte[] serialize(OverseerSolrResponse responseObject) {
        Objects.requireNonNull(responseObject);
        try {
            return Utils.toJavabin(responseObject.getResponse()).readAllBytes();
        }
        catch (IOException | RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception serializing response to Javabin", (Throwable)e);
        }
    }

    public static OverseerSolrResponse deserialize(byte[] responseBytes) {
        Objects.requireNonNull(responseBytes);
        try {
            NamedList response = (NamedList)Utils.fromJavabin((byte[])responseBytes);
            return new OverseerSolrResponse((NamedList<Object>)response);
        }
        catch (IOException | RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception deserializing response from Javabin", (Throwable)e);
        }
    }
}

