/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.JsonMapResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class ApiTool
extends ToolBase {
    public ApiTool() {
        this(CLIO.getOutStream());
    }

    public ApiTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "api";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("solr-url").argName("URL").hasArg().required(false).desc("Send a GET request to a Solr API endpoint.").build(), Option.builder((String)"get").longOpt("get").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --solr-url instead").get()).argName("URL").hasArg().required(false).desc("Send a GET request to a Solr API endpoint.").build());
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        String getUrl;
        String response = null;
        String string = getUrl = cli.hasOption("solr-url") ? cli.getOptionValue("solr-url") : cli.getOptionValue("get");
        if (getUrl != null) {
            response = this.callGet(getUrl);
        }
        if (response != null) {
            this.echo(response);
        }
    }

    protected String callGet(String url) throws Exception {
        URI uri = new URI(url.replace("+", "%20"));
        String solrUrl = ApiTool.getSolrUrlFromUri(uri);
        String path = uri.getPath();
        try (SolrClient solrClient = SolrCLI.getSolrClient(solrUrl);){
            GenericSolrRequest req = new GenericSolrRequest(SolrRequest.METHOD.GET, path.substring(path.indexOf("/", path.indexOf("/") + 1)), (SolrParams)ApiTool.getSolrParamsFromUri(uri));
            req.setResponseParser((ResponseParser)new JsonMapResponseParser());
            NamedList response = solrClient.request((SolrRequest)req);
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(response.asMap(10));
            String string = arr.toString();
            return string;
        }
    }

    public static String getSolrUrlFromUri(URI uri) {
        return uri.resolve("/" + uri.getPath().split("/")[1]).toString();
    }

    public static ModifiableSolrParams getSolrParamsFromUri(URI uri) {
        String[] params;
        ModifiableSolrParams paramsMap = new ModifiableSolrParams();
        for (String param : params = uri.getQuery() == null ? new String[]{} : uri.getQuery().split("&")) {
            String[] paramSplit = param.split("=");
            paramsMap.add(paramSplit[0], new String[]{paramSplit[1]});
        }
        return paramsMap;
    }
}

