/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.AbstractReadWriteDecorator;
import org.apache.kafka.streams.processor.internals.GlobalStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class GlobalProcessorContextImpl
extends AbstractProcessorContext<Object, Object> {
    private final GlobalStateManager stateManager;
    private final Time time;

    public GlobalProcessorContextImpl(StreamsConfig config, GlobalStateManager stateMgr, StreamsMetricsImpl metrics, ThreadCache cache, Time time) {
        super(new TaskId(-1, -1), config, metrics, cache);
        this.stateManager = stateMgr;
        this.time = time;
    }

    @Override
    protected StateManager stateManager() {
        return this.stateManager;
    }

    @Override
    public <S extends StateStore> S getStateStore(String name) {
        StateStore store = this.stateManager.getGlobalStore(name);
        return (S)AbstractReadWriteDecorator.getReadWriteStore(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(Record<K, V> record) {
        ProcessorNode<?, ?, ?, ?> previousNode = this.currentNode();
        try {
            for (ProcessorNode<?, ?, ?, ?> child : this.currentNode().children()) {
                this.setCurrentNode(child);
                child.process(record);
            }
        }
        finally {
            this.setCurrentNode(previousNode);
        }
    }

    @Override
    public <K, V> void forward(Record<K, V> record, String childName) {
        throw new UnsupportedOperationException("this should not happen: forward() not supported in global processor context.");
    }

    public <KIn, VIn> void forward(KIn key, VIn value) {
        this.forward(new Record<KIn, VIn>(key, value, this.timestamp(), this.headers()));
    }

    @Override
    public <K, V> void forward(K key, V value, To to) {
        if (!this.currentNode().children().isEmpty()) {
            throw new IllegalStateException("This method should only be called on 'GlobalStateStore.flush' that should not have any children.");
        }
    }

    @Override
    public <K, V> void forward(FixedKeyRecord<K, V> record) {
        this.forward(new Record<K, V>(record.key(), record.value(), record.timestamp(), record.headers()));
    }

    @Override
    public <K, V> void forward(FixedKeyRecord<K, V> record, String childName) {
        this.forward((KIn)new Record<K, V>(record.key(), record.value(), record.timestamp(), record.headers()), (VIn)childName);
    }

    @Override
    public void commit() {
    }

    @Override
    public long currentSystemTimeMs() {
        return this.time.milliseconds();
    }

    @Override
    public long currentStreamTimeMs() {
        throw new UnsupportedOperationException("There is no concept of stream-time for a global processor.");
    }

    @Override
    public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) {
        throw new UnsupportedOperationException("this should not happen: schedule() not supported in global processor context.");
    }

    @Override
    public void logChange(String storeName, Bytes key, byte[] value, long timestamp, Position position) {
        throw new UnsupportedOperationException("this should not happen: logChange() not supported in global processor context.");
    }

    @Override
    public void transitionToActive(StreamTask streamTask, RecordCollector recordCollector, ThreadCache newCache) {
        throw new UnsupportedOperationException("this should not happen: transitionToActive() not supported in global processor context.");
    }

    @Override
    public void transitionToStandby(ThreadCache newCache) {
        throw new UnsupportedOperationException("this should not happen: transitionToStandby() not supported in global processor context.");
    }

    @Override
    public void registerCacheFlushListener(String namespace, ThreadCache.DirtyEntryFlushListener listener) {
        this.cache.addDirtyEntryFlushListener(namespace, listener);
    }
}

