/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.xdr.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.XdrDataType;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.type.XdrSimple;

public class XdrBytes
extends XdrSimple<byte[]> {
    private int padding;

    public XdrBytes() {
        this((byte[])null);
    }

    public XdrBytes(byte[] value) {
        super(XdrDataType.BYTES, value);
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes = this.getBytes();
        byte[] header = new byte[4];
        System.arraycopy(bytes, 0, header, 0, 4);
        int byteArrayLen = ByteBuffer.wrap(header).getInt();
        int paddingBytes = (4 - byteArrayLen % 4) % 4;
        this.validatePaddingBytes(paddingBytes);
        this.setPadding(paddingBytes);
        if (bytes.length != byteArrayLen + 4 + paddingBytes) {
            int totalLength = byteArrayLen + 4 + paddingBytes;
            byte[] resetBytes = ByteBuffer.allocate(totalLength).put(this.getBytes(), 0, totalLength).array();
            this.setBytes(resetBytes);
        }
        byte[] content = new byte[byteArrayLen];
        if (bytes.length > 1) {
            System.arraycopy(bytes, 4, content, 0, byteArrayLen);
        }
        this.setValue(content);
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        if (this.getValue() != null) {
            this.padding = (4 - ((byte[])this.getValue()).length % 4) % 4;
            return ((byte[])this.getValue()).length + this.padding + 4;
        }
        return 0;
    }

    @Override
    protected void toBytes() throws IOException {
        if (this.getValue() != null) {
            byte[] bytes = new byte[this.encodingBodyLength()];
            int length = ((byte[])this.getValue()).length;
            bytes[0] = (byte)(length >> 24);
            bytes[1] = (byte)(length >> 16);
            bytes[2] = (byte)(length >> 8);
            bytes[3] = (byte)length;
            System.arraycopy(this.getValue(), 0, bytes, 4, length);
            this.setBytes(bytes);
        }
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getPadding() {
        return this.padding;
    }

    private void validatePaddingBytes(int paddingBytes) throws IOException {
        if (paddingBytes < 0 || paddingBytes > 3) {
            throw new IOException("Bad padding number: " + paddingBytes + ", should be in [0, 3]");
        }
    }
}

