/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client;

import org.apache.hadoop.shaded.org.apache.kerby.KOptions;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbOption;

public class KrbSetting {
    private final KOptions commonOptions;
    private final KrbConfig krbConfig;

    public KrbSetting(KOptions commonOptions, KrbConfig config) {
        this.commonOptions = commonOptions;
        this.krbConfig = config;
    }

    public KrbSetting(KrbConfig config) {
        this.commonOptions = new KOptions();
        this.krbConfig = config;
    }

    public KrbConfig getKrbConfig() {
        return this.krbConfig;
    }

    public String getKdcRealm() {
        String kdcRealm = this.commonOptions.getStringOption(KrbOption.KDC_REALM);
        if (kdcRealm == null || kdcRealm.isEmpty()) {
            kdcRealm = this.krbConfig.getKdcRealm();
        }
        return kdcRealm;
    }

    public String getKdcHost() {
        String kdcHost = this.commonOptions.getStringOption(KrbOption.KDC_HOST);
        if (kdcHost == null) {
            return this.krbConfig.getKdcHost();
        }
        return kdcHost;
    }

    public int checkGetKdcTcpPort() throws KrbException {
        if (this.allowTcp()) {
            int kdcPort = this.getKdcTcpPort();
            if (kdcPort < 1) {
                throw new KrbException("KDC tcp port isn't set or configured");
            }
            return kdcPort;
        }
        return -1;
    }

    public int checkGetKdcUdpPort() throws KrbException {
        if (this.allowUdp()) {
            int kdcPort = this.getKdcUdpPort();
            if (kdcPort < 1) {
                throw new KrbException("KDC udp port isn't set or configured");
            }
            return kdcPort;
        }
        return -1;
    }

    public int getKdcTcpPort() {
        int tcpPort = this.commonOptions.getIntegerOption(KrbOption.KDC_TCP_PORT);
        if (tcpPort > 0) {
            return tcpPort;
        }
        return this.krbConfig.getKdcTcpPort();
    }

    public boolean allowUdp() {
        return this.commonOptions.getBooleanOption(KrbOption.ALLOW_UDP, this.krbConfig.allowUdp());
    }

    public boolean allowTcp() {
        return this.commonOptions.getBooleanOption(KrbOption.ALLOW_TCP, this.krbConfig.allowTcp());
    }

    public int getKdcUdpPort() {
        int udpPort = this.commonOptions.getIntegerOption(KrbOption.KDC_UDP_PORT);
        if (udpPort > 0) {
            return udpPort;
        }
        return this.krbConfig.getKdcUdpPort();
    }

    public int getTimeout() {
        int timeout = this.commonOptions.getIntegerOption(KrbOption.CONN_TIMEOUT);
        if (timeout > 0) {
            return timeout;
        }
        return 1000;
    }
}

