/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.DrawLines;
import de.escape.quincunx.dxf.DrawSet;
import de.escape.quincunx.dxf.DxfColorModel;
import de.escape.quincunx.dxf.LineStyle;
import de.escape.quincunx.dxf.SegmentWalker;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.awt.Graphics;

public class DrawLinesWithWidth
extends DrawLines {
    protected Width[] width;

    public DrawLinesWithWidth() {
    }

    public DrawLinesWithWidth(int nr) {
        super(nr);
        if (nr > 0) {
            this.width = new Width[nr];
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insertLayer, DxfColorModel colors, short insertColor) {
        if (!this.isVisible(insertLayer)) {
            return;
        }
        if ((this.flags & 2) == 0) {
            this.representation = this.calculateRepresentation(null);
        }
        this.representation.draw(g, mat, insertLayer, colors, insertColor);
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colors, short insColor, int nr, int maxNr) {
        if (nr == 0) {
            super.draw(g, mat, insLayer, colors, insColor);
        }
    }

    public void addPoint(Point3D pt) {
        this.addPoint(pt.x, pt.y, pt.z, 0.0f, 0.0f);
    }

    public void addPoint(Point3D pt, float startWidth, float endWidth) {
        this.addPoint(pt.x, pt.y, pt.z, startWidth, endWidth);
    }

    public void addPoint(float x, float y, float z) {
        this.addPoint(x, y, z, 0.0f, 0.0f);
    }

    public void addPoint(float x, float y, float z, float startWidth, float endWidth) {
        if (this.width == null) {
            this.width = new Width[2];
        } else if (this.nrPoints == this.width.length) {
            Width[] nWidth = new Width[2 * this.width.length];
            System.arraycopy(this.width, 0, nWidth, 0, this.width.length);
            this.width = nWidth;
        }
        this.width[this.nrPoints] = new Width(startWidth, endWidth);
        super.addPoint(x, y, z);
    }

    public int calcBB(Point3D min, Point3D max, Matrix4D mat, DxfLAYER insertLayer, boolean onlyVisible) {
        if (onlyVisible && !this.isVisible(insertLayer)) {
            return 0;
        }
        int i = 0;
        while (i < this.nrPoints) {
            Point3D p;
            Point3D point3D = p = mat == null ? this.line[i] : mat.mult(this.line[i]);
            if (p.x < min.x) {
                min.x = p.x;
            }
            if (p.y < min.y) {
                min.y = p.y;
            }
            if (p.z < min.z) {
                min.z = p.z;
            }
            if (p.x > max.x) {
                max.x = p.x;
            }
            if (p.y > max.y) {
                max.y = p.y;
            }
            if (p.z > max.z) {
                max.z = p.z;
            }
            ++i;
        }
        return this.nrPoints > 1 ? this.nrPoints - (this.isClosed ? 0 : 1) : this.nrPoints;
    }

    public DrawAble extrude(float dist, Vector3D up) {
        return super.extrude(dist, up);
    }

    protected DrawAble calculateRepresentation(LineStyle lstyle) {
        SegmentWalker walker;
        if (lstyle == null || (walker = lstyle.lineSegments(this.calculateLength(), this.isClosed)) == null) {
            Point3D cross2;
            Point3D cross1;
            int start;
            float length;
            Vector3D perp;
            int last;
            if (this.nrPoints == 1) {
                return new DrawLines();
            }
            Point3D[] outer1 = new Point3D[2 * this.nrPoints];
            Point3D[] outer2 = new Point3D[2 * this.nrPoints];
            Point3D[] points1 = new Point3D[4];
            Point3D[] points2 = new Point3D[4];
            int pointCount = 0;
            if (this.isClosed) {
                last = this.nrPoints - 1;
                perp = this.line[0].minus(this.line[last]);
                length = perp.length();
                perp.scale(0.5f / length);
                points1[0] = new Point3D(this.line[last].x - perp.y * this.width[last].start, this.line[last].y + perp.x * this.width[last].start, this.line[last].z);
                points2[0] = new Point3D(this.line[last].x + perp.y * this.width[last].start, this.line[last].y - perp.x * this.width[last].start, this.line[last].z);
                points1[1] = new Point3D(this.line[0].x - perp.y * this.width[last].end, this.line[0].y + perp.x * this.width[last].end, this.line[0].z);
                points2[1] = new Point3D(this.line[0].x + perp.y * this.width[last].end, this.line[0].y - perp.x * this.width[last].end, this.line[0].z);
                last = 0;
                start = 1;
            } else {
                perp = this.line[1].minus(this.line[0]);
                length = perp.length();
                perp.scale(0.5f / length);
                points1[0] = new Point3D(this.line[0].x - perp.y * this.width[0].start, this.line[0].y + perp.x * this.width[0].start, this.line[0].z);
                points2[0] = new Point3D(this.line[0].x + perp.y * this.width[0].start, this.line[0].y - perp.x * this.width[0].start, this.line[0].z);
                points1[1] = new Point3D(this.line[1].x - perp.y * this.width[0].end, this.line[1].y + perp.x * this.width[0].end, this.line[1].z);
                points2[1] = new Point3D(this.line[1].x + perp.y * this.width[0].end, this.line[1].y - perp.x * this.width[0].end, this.line[1].z);
                outer1[pointCount] = points1[0];
                outer2[pointCount] = points2[0];
                ++pointCount;
                last = 1;
                start = 2;
            }
            int p = start;
            while (p < this.nrPoints) {
                perp = this.line[p].minus(this.line[last]);
                length = perp.length();
                perp.scale(0.5f / length);
                points1[2] = new Point3D(this.line[last].x - perp.y * this.width[last].start, this.line[last].y + perp.x * this.width[last].start, this.line[last].z);
                points2[2] = new Point3D(this.line[last].x + perp.y * this.width[last].start, this.line[last].y - perp.x * this.width[last].start, this.line[last].z);
                points1[3] = new Point3D(this.line[p].x - perp.y * this.width[last].end, this.line[p].y + perp.x * this.width[last].end, this.line[p].z);
                points2[3] = new Point3D(this.line[p].x + perp.y * this.width[last].end, this.line[p].y - perp.x * this.width[last].end, this.line[p].z);
                cross1 = DrawLinesWithWidth.calcIntersection2D(points1);
                cross2 = DrawLinesWithWidth.calcIntersection2D(points2);
                if (cross1 == null || cross2 == null) {
                    outer1[pointCount] = points1[1];
                    outer2[pointCount] = points2[1];
                    outer1[++pointCount] = points1[2];
                    outer2[pointCount] = points2[2];
                    ++pointCount;
                } else {
                    outer1[pointCount] = cross1;
                    outer2[pointCount] = cross2;
                    ++pointCount;
                }
                points1[0] = points1[2];
                points1[1] = points1[3];
                points2[0] = points2[2];
                points2[1] = points2[3];
                last = p++;
            }
            if (this.isClosed) {
                p = 0;
                perp = this.line[p].minus(this.line[last]);
                length = perp.length();
                if (length > 0.0f) {
                    perp.scale(0.5f / length);
                    points1[2] = new Point3D(this.line[last].x - perp.y * this.width[last].start, this.line[last].y + perp.x * this.width[last].start, this.line[last].z);
                    points2[2] = new Point3D(this.line[last].x + perp.y * this.width[last].start, this.line[last].y - perp.x * this.width[last].start, this.line[last].z);
                    points1[3] = new Point3D(this.line[p].x - perp.y * this.width[last].end, this.line[p].y + perp.x * this.width[last].end, this.line[p].z);
                    points2[3] = new Point3D(this.line[p].x + perp.y * this.width[last].end, this.line[p].y - perp.x * this.width[last].end, this.line[p].z);
                    cross1 = DrawLinesWithWidth.calcIntersection2D(points1);
                    cross2 = DrawLinesWithWidth.calcIntersection2D(points2);
                    if (cross1 == null || cross2 == null) {
                        outer1[pointCount] = points1[1];
                        outer2[pointCount] = points2[1];
                        outer1[++pointCount] = points1[2];
                        outer2[pointCount] = points2[2];
                        ++pointCount;
                    } else {
                        outer1[pointCount] = cross1;
                        outer2[pointCount] = cross2;
                        ++pointCount;
                    }
                } else {
                    outer1[pointCount] = points1[1];
                    outer2[pointCount] = points2[1];
                    ++pointCount;
                }
            } else {
                outer1[pointCount] = points1[1];
                outer2[pointCount] = points2[1];
                ++pointCount;
            }
            DrawSet set = new DrawSet(2 * pointCount + 2);
            set.setLayer(this.layer);
            set.setColor(this.color);
            DrawLines line1 = new DrawLines(pointCount);
            line1.setLayer(this.layer);
            line1.setColor(this.color);
            DrawLines line2 = new DrawLines(pointCount);
            line2.setLayer(this.layer);
            line2.setColor(this.color);
            set.addDrawable(line1);
            set.addDrawable(line2);
            p = 0;
            while (p < pointCount) {
                line1.addPoint(outer1[p]);
                line2.addPoint(outer2[p]);
                DrawLines connect = new DrawLines(2);
                connect.setLayer(this.layer);
                connect.setColor(this.color);
                set.addDrawable(connect);
                connect.addPoint(outer1[p]);
                connect.addPoint(outer2[p]);
                ++p;
            }
            if (this.isClosed) {
                line1.close();
                line2.close();
            }
            return set;
        }
        return super.calculateRepresentation(lstyle);
    }

    private static Point3D calcIntersection2D(Point3D[] p) {
        if (p[1].x == p[2].x && p[1].y == p[2].y) {
            return new Point3D(p[1].x, p[1].y, (p[1].z + p[2].z) / 2.0f);
        }
        Vector3D v = p[1].minus(p[0]);
        Vector3D w = p[3].minus(p[2]);
        Vector3D d = p[2].minus(p[0]);
        float det = v.x * w.y - v.y * w.x;
        if (det == 0.0f) {
            return null;
        }
        float lambda = (d.x * w.y - d.y * w.x) / det;
        return new Point3D(p[0].x + lambda * v.x, p[0].y + lambda * v.y, (p[1].z + p[2].z) / 2.0f);
    }

    static class Width {
        float start;
        float end;

        Width(float s, float e) {
            this.start = s;
            this.end = e;
        }

        public String toString() {
            return "<start=" + this.start + "|end=" + this.end + ">";
        }
    }
}

