/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.LoadableInt;
import com.gitlab.pdftk_java.LoadableString;

class PdfBookmark {
    static final String PREFIX = "Bookmark";
    static final String BEGIN_MARK = "BookmarkBegin";
    static final String TITLE_LABEL = "BookmarkTitle:";
    static final String LEVEL_LABEL = "BookmarkLevel:";
    static final String PAGE_NUMBER_LABEL = "BookmarkPageNumber:";
    String m_title = null;
    int m_level = -1;
    int m_page_num = -1;

    PdfBookmark() {
    }

    boolean valid() {
        return 0 < this.m_level && 0 <= this.m_page_num && this.m_title != null;
    }

    public String toString() {
        return BEGIN_MARK + System.lineSeparator() + TITLE_LABEL + " " + this.m_title + System.lineSeparator() + LEVEL_LABEL + " " + this.m_level + System.lineSeparator() + PAGE_NUMBER_LABEL + " " + this.m_page_num + System.lineSeparator();
    }

    boolean loadTitle(String buff) {
        LoadableString loader = new LoadableString(this.m_title);
        boolean success = loader.LoadString(buff, TITLE_LABEL);
        this.m_title = loader.ss;
        return success;
    }

    boolean loadLevel(String buff) {
        LoadableInt loader = new LoadableInt(this.m_level);
        boolean success = loader.LoadInt(buff, LEVEL_LABEL);
        this.m_level = loader.ii;
        return success;
    }

    boolean loadPageNum(String buff) {
        LoadableInt loader = new LoadableInt(this.m_page_num);
        boolean success = loader.LoadInt(buff, PAGE_NUMBER_LABEL);
        this.m_page_num = loader.ii;
        return success;
    }
}

