/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.searchrelevance.dao.EvaluationResultDao;
import org.opensearch.searchrelevance.dao.ExperimentVariantDao;
import org.opensearch.searchrelevance.executors.ExperimentTaskContext;
import org.opensearch.searchrelevance.executors.PointwiseTaskParameters;
import org.opensearch.searchrelevance.executors.SearchResponseProcessor;
import org.opensearch.searchrelevance.executors.VariantTaskParameters;
import org.opensearch.searchrelevance.experiment.QuerySourceUtil;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ExperimentVariant;
import org.opensearch.searchrelevance.model.builder.SearchRequestBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class ExperimentTaskManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ExperimentTaskManager.class);
    public static final int TASK_RETRY_DELAY_MILLISECONDS = 1000;
    public static final int ALLOCATED_PROCESSORS = OpenSearchExecutors.allocatedProcessors((Settings)Settings.EMPTY);
    private static final int DEFAULT_MIN_CONCURRENT_THREADS = 24;
    private static final int PROCESSOR_NUMBER_DIVISOR = 2;
    protected static final String THREAD_POOL_EXECUTOR_NAME = "generic";
    private final int maxConcurrentTasks;
    private final ConcurrentHashMap<String, ExperimentTaskContext> experimentTaskContexts = new ConcurrentHashMap();
    private final Semaphore concurrencyControl;
    private final LongAdder activeTasks = new LongAdder();
    private final Client client;
    private final EvaluationResultDao evaluationResultDao;
    private final ExperimentVariantDao experimentVariantDao;
    private final ThreadPool threadPool;
    private final SearchResponseProcessor searchResponseProcessor;

    @Inject
    public ExperimentTaskManager(Client client, EvaluationResultDao evaluationResultDao, ExperimentVariantDao experimentVariantDao, ThreadPool threadPool) {
        this.client = client;
        this.evaluationResultDao = evaluationResultDao;
        this.experimentVariantDao = experimentVariantDao;
        this.threadPool = threadPool;
        this.searchResponseProcessor = new SearchResponseProcessor(evaluationResultDao, experimentVariantDao);
        this.maxConcurrentTasks = Math.max(2, Math.min(24, ALLOCATED_PROCESSORS / 2));
        this.concurrencyControl = new Semaphore(this.maxConcurrentTasks, true);
        log.info("ExperimentTaskManager initialized with max {} concurrent tasks (processors: {})", (Object)this.maxConcurrentTasks, (Object)ALLOCATED_PROCESSORS);
    }

    public CompletableFuture<Map<String, Object>> scheduleTasksAsync(ExperimentType experimentType, String experimentId, String searchConfigId, String index, String query, String queryText, int size, List<ExperimentVariant> experimentVariants, List<String> judgmentIds, Map<String, String> docIdToScores, Map<String, Object> configToExperimentVariants, AtomicBoolean hasFailure) {
        CompletableFuture<Map<String, Object>> resultFuture = new CompletableFuture<Map<String, Object>>();
        ExperimentTaskContext taskContext = new ExperimentTaskContext(experimentId, searchConfigId, queryText, experimentVariants.size(), new ConcurrentHashMap<String, Object>(configToExperimentVariants), resultFuture, hasFailure, this.experimentVariantDao, experimentType);
        this.experimentTaskContexts.putIfAbsent(experimentId, taskContext);
        taskContext.getConfigToExperimentVariants().computeIfAbsent(searchConfigId, k -> new ConcurrentHashMap());
        log.info("Scheduling {} {} experiment tasks for experiment {} with non-blocking concurrency", (Object)experimentVariants.size(), (Object)experimentType, (Object)experimentId);
        List<CompletableFuture> variantFutures = experimentVariants.stream().map(variant -> {
            VariantTaskParameters params = this.createTaskParameters(experimentType, experimentId, searchConfigId, index, query, queryText, size, (ExperimentVariant)variant, judgmentIds, docIdToScores, taskContext);
            return this.scheduleVariantTaskAsync(params);
        }).toList();
        CompletableFuture.allOf(variantFutures.toArray(new CompletableFuture[0])).whenComplete((v, ex) -> {
            this.experimentTaskContexts.remove(experimentId);
            this.activeTasks.decrement();
        });
        return resultFuture;
    }

    private VariantTaskParameters createTaskParameters(ExperimentType experimentType, String experimentId, String searchConfigId, String index, String query, String queryText, int size, ExperimentVariant variant, List<String> judgmentIds, Map<String, String> docIdToScores, ExperimentTaskContext taskContext) {
        if (experimentType == ExperimentType.POINTWISE_EVALUATION) {
            return ((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)((PointwiseTaskParameters.PointwiseTaskParametersBuilder)PointwiseTaskParameters.builder().experimentId(experimentId)).searchConfigId(searchConfigId)).index(index)).query(query)).queryText(queryText)).size(size)).experimentVariant(variant)).judgmentIds(judgmentIds)).docIdToScores(docIdToScores)).taskContext(taskContext)).searchPipeline(this.getSearchPipelineFromVariant(variant))).build();
        }
        return ((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)((VariantTaskParameters.VariantTaskParametersBuilder)VariantTaskParameters.builder().experimentId(experimentId)).searchConfigId(searchConfigId)).index(index)).query(query)).queryText(queryText)).size(size)).experimentVariant(variant)).judgmentIds(judgmentIds)).docIdToScores(docIdToScores)).taskContext(taskContext)).build();
    }

    private String getSearchPipelineFromVariant(ExperimentVariant variant) {
        return (String)variant.getParameters().get("searchPipeline");
    }

    private CompletableFuture<Void> scheduleVariantTaskAsync(VariantTaskParameters params) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (params.getTaskContext().getHasFailure().get()) {
            future.complete(null);
            return future;
        }
        if (this.concurrencyControl.tryAcquire()) {
            this.activeTasks.increment();
            this.submitTaskToThreadPool(params, future);
        } else {
            CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS, this.threadPool.executor(THREAD_POOL_EXECUTOR_NAME)).execute(() -> this.scheduleVariantTaskAsync(params).whenComplete((v, ex) -> {
                if (ex != null) {
                    future.completeExceptionally((Throwable)ex);
                } else {
                    future.complete((Void)v);
                }
            }));
        }
        return future;
    }

    private void submitTaskToThreadPool(VariantTaskParameters params, CompletableFuture<Void> future) {
        try {
            this.threadPool.executor("_plugin_search_relevance_executor").execute((Runnable)((Object)new OptimizedVariantTaskRunnable(params, future)));
        }
        catch (RejectedExecutionException e) {
            this.concurrencyControl.release();
            this.activeTasks.decrement();
            log.warn("Thread pool queue full, retrying for variant: {}", (Object)params.getExperimentVariant().getId());
            CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS, this.threadPool.executor(THREAD_POOL_EXECUTOR_NAME)).execute(() -> this.scheduleVariantTaskAsync(params));
        }
    }

    private void executeVariantTaskAsync(final VariantTaskParameters params, CompletableFuture<Void> future) {
        if (params.getTaskContext().getHasFailure().get()) {
            this.concurrencyControl.release();
            this.activeTasks.decrement();
            future.complete(null);
            return;
        }
        final String evaluationId = UUID.randomUUID().toString();
        SearchRequest searchRequest = this.buildSearchRequest(params, evaluationId);
        final CompletableFuture searchFuture = new CompletableFuture();
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
            final /* synthetic */ ExperimentTaskManager this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse response) {
                try {
                    this.this$0.searchResponseProcessor.processSearchResponse(response, params.getExperimentVariant(), params.getExperimentId(), params.getSearchConfigId(), params.getQueryText(), params.getSize(), params.getJudgmentIds(), params.getDocIdToScores(), evaluationId, params.getTaskContext());
                    searchFuture.complete(null);
                }
                catch (Exception e) {
                    searchFuture.completeExceptionally(e);
                }
                finally {
                    this.this$0.concurrencyControl.release();
                    this.this$0.activeTasks.decrement();
                }
            }

            public void onFailure(Exception e) {
                try {
                    this.this$0.handleSearchFailure(e, params.getExperimentVariant(), params.getExperimentId(), evaluationId, params.getTaskContext());
                    searchFuture.complete(null);
                }
                catch (Exception ex) {
                    searchFuture.completeExceptionally(ex);
                }
                finally {
                    this.this$0.concurrencyControl.release();
                    this.this$0.activeTasks.decrement();
                }
            }
        });
        searchFuture.whenComplete((v, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(null);
            }
        });
    }

    private SearchRequest buildSearchRequest(VariantTaskParameters params, String evaluationId) {
        if (params instanceof PointwiseTaskParameters) {
            PointwiseTaskParameters pointwiseParams = (PointwiseTaskParameters)params;
            return SearchRequestBuilder.buildSearchRequest(pointwiseParams.getIndex(), pointwiseParams.getQuery(), pointwiseParams.getQueryText(), pointwiseParams.getSearchPipeline(), pointwiseParams.getSize());
        }
        Map<String, Object> temporarySearchPipeline = QuerySourceUtil.createDefinitionOfTemporarySearchPipeline(params.getExperimentVariant());
        return SearchRequestBuilder.buildRequestForHybridSearch(params.getIndex(), params.getQuery(), temporarySearchPipeline, params.getQueryText(), params.getSize());
    }

    private void handleSearchFailure(Exception e, ExperimentVariant experimentVariant, String experimentId, String evaluationId, ExperimentTaskContext taskContext) {
        if (this.isCriticalSystemFailure(e)) {
            if (taskContext.getHasFailure().compareAndSet(false, true)) {
                log.error("Critical system failure for variant {}: {}", (Object)experimentVariant.getId(), (Object)e.getMessage());
                taskContext.getResultFuture().completeExceptionally(e);
            }
        } else {
            this.searchResponseProcessor.handleSearchFailure(e, experimentVariant, experimentId, evaluationId, taskContext);
        }
    }

    private boolean isCriticalSystemFailure(Throwable throwable) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            if (current instanceof OutOfMemoryError || current instanceof StackOverflowError) {
                return true;
            }
            if (!(current instanceof CircuitBreakingException) && !(current instanceof ClusterBlockException)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected Map<String, Object> getConcurrencyMetrics() {
        return Map.of("active_experiments", this.experimentTaskContexts.size(), "active_tasks", this.activeTasks.sum(), "max_concurrent_tasks", this.maxConcurrentTasks, "available_permits", this.concurrencyControl.availablePermits(), "queued_threads", this.concurrencyControl.getQueueLength(), "thread_pool", "_plugin_search_relevance_executor");
    }

    private void handleTaskFailure(ExperimentVariant experimentVariant, Exception e, ExperimentTaskContext taskContext) {
        if (this.isCriticalSystemFailure(e)) {
            if (taskContext.getHasFailure().compareAndSet(false, true)) {
                log.error("Critical system failure for variant {}: {}", (Object)experimentVariant.getId(), (Object)e.getMessage());
                taskContext.getResultFuture().completeExceptionally(e);
            }
        } else {
            log.error("Variant failure for {}: {}", (Object)experimentVariant.getId(), (Object)e.getMessage());
            taskContext.completeVariantFailure();
        }
    }

    private class OptimizedVariantTaskRunnable
    extends AbstractRunnable {
        private final VariantTaskParameters params;
        private final CompletableFuture<Void> future;

        OptimizedVariantTaskRunnable(VariantTaskParameters params, CompletableFuture<Void> future) {
            this.params = params;
            this.future = future;
        }

        public void onFailure(Exception e) {
            ExperimentTaskManager.this.concurrencyControl.release();
            ExperimentTaskManager.this.activeTasks.decrement();
            if (e.getCause() instanceof RejectedExecutionException) {
                log.warn("Thread pool queue full, retrying task for variant: {}", (Object)this.params.getExperimentVariant().getId());
                ExperimentTaskManager.this.scheduleVariantTaskAsync(this.params).whenComplete((v, ex) -> {
                    if (ex != null) {
                        this.future.completeExceptionally((Throwable)ex);
                    } else {
                        this.future.complete((Void)v);
                    }
                });
            } else {
                ExperimentTaskManager.this.handleTaskFailure(this.params.getExperimentVariant(), e, this.params.getTaskContext());
                this.future.completeExceptionally(e);
            }
        }

        protected void doRun() {
            ExperimentTaskManager.this.executeVariantTaskAsync(this.params, this.future);
        }
    }
}

