/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util.clusterMetricsMonitorHelpers;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.cache.query.QueryCacheStats;
import org.opensearch.index.engine.CommitStats;
import org.opensearch.index.engine.SegmentsStats;
import org.opensearch.index.fielddata.FieldDataStats;
import org.opensearch.index.flush.FlushStats;
import org.opensearch.index.get.GetStats;
import org.opensearch.index.merge.MergeStats;
import org.opensearch.index.refresh.RefreshStats;
import org.opensearch.index.search.stats.SearchStats;
import org.opensearch.index.seqno.SeqNoStats;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.index.shard.IndexingStats;
import org.opensearch.index.store.StoreStats;
import org.opensearch.search.suggest.completion.CompletionStats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0002\"#B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002JM\u0010\u0010\u001a\u0004\u0018\u00010\u0011\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00132\b\u0010\u0014\u001a\u0004\u0018\u0001H\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00110\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatShardsResponseWrapper;", "Lorg/opensearch/core/action/ActionResponse;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "stateResp", "Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;", "indicesResp", "Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;", "(Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;)V", "shardInfoList", "", "Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatShardsResponseWrapper$ShardInfo;", "getShardInfoList", "()Ljava/util/List;", "setShardInfoList", "(Ljava/util/List;)V", "compileShardInfo", "getOrNull", "", "S", "T", "stats", "accessor", "Ljava/util/function/Function;", "func", "(Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/function/Function;)Ljava/lang/Object;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "ShardInfo", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nCatShardsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatShardsHelpers.kt\norg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatShardsResponseWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,496:1\n1855#2,2:497\n*S KotlinDebug\n*F\n+ 1 CatShardsHelpers.kt\norg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatShardsResponseWrapper\n*L\n96#1:497,2\n*E\n"})
public final class CatShardsResponseWrapper
extends ActionResponse
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<ShardInfo> shardInfoList;
    @NotNull
    public static final String WRAPPER_FIELD = "shards";

    public CatShardsResponseWrapper(@NotNull ClusterStateResponse stateResp, @NotNull IndicesStatsResponse indicesResp) {
        Intrinsics.checkNotNullParameter((Object)stateResp, (String)"stateResp");
        Intrinsics.checkNotNullParameter((Object)indicesResp, (String)"indicesResp");
        this.shardInfoList = CollectionsKt.emptyList();
        this.shardInfoList = this.compileShardInfo(stateResp, indicesResp);
    }

    @NotNull
    public final List<ShardInfo> getShardInfoList() {
        return this.shardInfoList;
    }

    public final void setShardInfoList(@NotNull List<ShardInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.shardInfoList = list;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeList(this.shardInfoList);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        builder.startArray(WRAPPER_FIELD);
        Iterable $this$forEach$iv = this.shardInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShardInfo it = (ShardInfo)element$iv;
            boolean bl = false;
            it.toXContent(builder, params);
        }
        builder.endArray();
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    private final <S, T> Object getOrNull(S stats, Function<S, T> accessor, Function<T, Object> func) {
        T t;
        if (stats != null && (t = accessor.apply(stats)) != null) {
            return func.apply(t);
        }
        return null;
    }

    private final List<ShardInfo> compileShardInfo(ClusterStateResponse stateResp, IndicesStatsResponse indicesResp) {
        List list = new ArrayList();
        for (ShardRouting shard : stateResp.getState().getRoutingTable().allShards()) {
            Object object;
            ShardStats shardStats = (ShardStats)indicesResp.asMap().get(shard);
            CommonStats commonStats = null;
            CommitStats commitStats = null;
            if (shardStats != null) {
                commonStats = shardStats.getStats();
                commitStats = shardStats.getCommitStats();
            }
            Object object2 = this.getOrNull(commonStats, CommonStats::getDocs, DocsStats::getCount);
            Object object3 = this.getOrNull(commonStats, CommonStats::getStore, StoreStats::getSize);
            Object object4 = this.getOrNull(commonStats, CommonStats::getCompletion, CompletionStats::getSize);
            Object object5 = this.getOrNull(commonStats, CommonStats::getFieldData, FieldDataStats::getMemorySize);
            Object object6 = this.getOrNull(commonStats, CommonStats::getFieldData, FieldDataStats::getEvictions);
            Object object7 = this.getOrNull(commonStats, CommonStats::getFlush, FlushStats::getTotal);
            Object object8 = this.getOrNull(commonStats, CommonStats::getFlush, FlushStats::getTotalTime);
            Object object9 = this.getOrNull(commonStats, CommonStats::getGet, GetStats::current);
            Object object10 = this.getOrNull(commonStats, CommonStats::getGet, GetStats::getTime);
            Object object11 = this.getOrNull(commonStats, CommonStats::getGet, GetStats::getCount);
            Object object12 = this.getOrNull(commonStats, CommonStats::getGet, GetStats::getExistsTime);
            Object object13 = this.getOrNull(commonStats, CommonStats::getGet, GetStats::getExistsCount);
            Object object14 = this.getOrNull(commonStats, CommonStats::getGet, GetStats::getMissingTime);
            Object object15 = this.getOrNull(commonStats, CommonStats::getGet, GetStats::getMissingCount);
            Object object16 = this.getOrNull(commonStats, CommonStats::getIndexing, CatShardsResponseWrapper::compileShardInfo$lambda$1);
            Object object17 = this.getOrNull(commonStats, CommonStats::getIndexing, CatShardsResponseWrapper::compileShardInfo$lambda$2);
            Object object18 = this.getOrNull(commonStats, CommonStats::getIndexing, CatShardsResponseWrapper::compileShardInfo$lambda$3);
            Object object19 = this.getOrNull(commonStats, CommonStats::getIndexing, CatShardsResponseWrapper::compileShardInfo$lambda$4);
            Object object20 = this.getOrNull(commonStats, CommonStats::getIndexing, CatShardsResponseWrapper::compileShardInfo$lambda$5);
            Object object21 = this.getOrNull(commonStats, CommonStats::getIndexing, CatShardsResponseWrapper::compileShardInfo$lambda$6);
            Object object22 = this.getOrNull(commonStats, CommonStats::getIndexing, CatShardsResponseWrapper::compileShardInfo$lambda$7);
            Object object23 = this.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getCurrent);
            Object object24 = this.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getCurrentNumDocs);
            Object object25 = this.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getCurrentSize);
            Object object26 = this.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotal);
            Object object27 = this.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotalNumDocs);
            Object object28 = this.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotalSize);
            Object object29 = this.getOrNull(commonStats, CommonStats::getMerge, MergeStats::getTotalTime);
            Object object30 = this.getOrNull(commonStats, CommonStats::getQueryCache, QueryCacheStats::getMemorySize);
            Object object31 = this.getOrNull(commonStats, CommonStats::getQueryCache, QueryCacheStats::getEvictions);
            Object object32 = this.getOrNull(commonStats, CommonStats::getRefresh, RefreshStats::getTotal);
            Object object33 = this.getOrNull(commonStats, CommonStats::getRefresh, RefreshStats::getTotalTime);
            Object object34 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$8);
            Object object35 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$9);
            Object object36 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$10);
            Object object37 = this.getOrNull(commonStats, CommonStats::getSearch, SearchStats::getOpenContexts);
            Object object38 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$11);
            Object object39 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$12);
            Object object40 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$13);
            Object object41 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$14);
            Object object42 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$15);
            Object object43 = this.getOrNull(commonStats, CommonStats::getSearch, CatShardsResponseWrapper::compileShardInfo$lambda$16);
            Object object44 = this.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getCount);
            Object object45 = this.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getZeroMemory);
            Object object46 = this.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getIndexWriterMemory);
            Object object47 = this.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getVersionMapMemory);
            Object object48 = this.getOrNull(commonStats, CommonStats::getSegments, SegmentsStats::getBitsetMemory);
            Object object49 = this.getOrNull(shardStats, ShardStats::getSeqNoStats, SeqNoStats::getGlobalCheckpoint);
            Object object50 = this.getOrNull(shardStats, ShardStats::getSeqNoStats, SeqNoStats::getLocalCheckpoint);
            Object object51 = this.getOrNull(shardStats, ShardStats::getSeqNoStats, SeqNoStats::getMaxSeqNo);
            ShardInfo shardInfo = new ShardInfo(shard.getIndexName(), String.valueOf(shard.getId()), shard.primary() ? "p" : "r", shard.state().name(), object2 != null ? object2.toString() : null, object3 != null ? object3.toString() : null, null, null, object4 != null ? object4.toString() : null, object5 != null ? object5.toString() : null, object6 != null ? object6.toString() : null, object7 != null ? object7.toString() : null, object8 != null ? object8.toString() : null, object9 != null ? object9.toString() : null, object10 != null ? object10.toString() : null, object11 != null ? object11.toString() : null, object12 != null ? object12.toString() : null, object13 != null ? object13.toString() : null, object14 != null ? object14.toString() : null, object15 != null ? object15.toString() : null, object16 != null ? object16.toString() : null, object17 != null ? object17.toString() : null, object18 != null ? object18.toString() : null, object19 != null ? object19.toString() : null, object20 != null ? object20.toString() : null, object21 != null ? object21.toString() : null, object22 != null ? object22.toString() : null, object23 != null ? object23.toString() : null, object24 != null ? object24.toString() : null, object25 != null ? object25.toString() : null, object26 != null ? object26.toString() : null, object27 != null ? object27.toString() : null, object28 != null ? object28.toString() : null, object29 != null ? object29.toString() : null, object30 != null ? object30.toString() : null, object31 != null ? object31.toString() : null, null, object32 != null ? object32.toString() : null, object33 != null ? object33.toString() : null, object34 != null ? object34.toString() : null, object35 != null ? object35.toString() : null, object36 != null ? object36.toString() : null, object37 != null ? object37.toString() : null, object38 != null ? object38.toString() : null, object39 != null ? object39.toString() : null, object40 != null ? object40.toString() : null, object41 != null ? object41.toString() : null, object42 != null ? object42.toString() : null, object43 != null ? object43.toString() : null, object44 != null ? object44.toString() : null, object45 != null ? object45.toString() : null, object46 != null ? object46.toString() : null, object47 != null ? object47.toString() : null, object48 != null ? object48.toString() : null, object49 != null ? object49.toString() : null, object50 != null ? object50.toString() : null, object51 != null ? object51.toString() : null, (object = commitStats) != null && (object = object.getUserData()) != null ? (String)object.get("sync_id") : null, null, null, null, null);
            if (shard.assignedToNode()) {
                String id = shard.currentNodeId();
                StringBuilder node = new StringBuilder();
                node.append(stateResp.getState().nodes().get(id).getName());
                if (shard.relocating()) {
                    String reloNodeId = shard.relocatingNodeId();
                    String reloName = stateResp.getState().nodes().get(reloNodeId).getName();
                    node.append(" -> ");
                    node.append(reloNodeId);
                    node.append(" ");
                    node.append(reloName);
                }
                shardInfo = ShardInfo.copy$default(shardInfo, null, null, null, null, null, null, id, node.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -193, 0x3FFFFFFF, null);
            }
            if (shard.unassignedInfo() != null) {
                Instant unassignedTime = Instant.ofEpochMilli(shard.unassignedInfo().getUnassignedTimeInMillis());
                ShardInfo shardInfo2 = shardInfo;
                String string = shard.unassignedInfo().getReason().name();
                String string2 = UnassignedInfo.DATE_TIME_FORMATTER.format((TemporalAccessor)unassignedTime);
                String string3 = TimeValue.timeValueMillis((long)(System.currentTimeMillis() - shard.unassignedInfo().getUnassignedTimeInMillis())).getStringRep();
                String string4 = shard.unassignedInfo().getDetails();
                shardInfo = ShardInfo.copy$default(shardInfo2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, string2, string4, string3, string, -1, 0x3FFFFFF, null);
            }
            if (shard.recoverySource() != null) {
                String string = shard.recoverySource().getType().toString();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string5 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                shardInfo = ShardInfo.copy$default(shardInfo, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, string5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, 0x3FFFFFEF, null);
            }
            list.add(shardInfo);
        }
        return list;
    }

    private static final Object compileShardInfo$lambda$1(IndexingStats it) {
        return it.getTotal().getDeleteCurrent();
    }

    private static final Object compileShardInfo$lambda$2(IndexingStats it) {
        return it.getTotal().getDeleteTime();
    }

    private static final Object compileShardInfo$lambda$3(IndexingStats it) {
        return it.getTotal().getDeleteCount();
    }

    private static final Object compileShardInfo$lambda$4(IndexingStats it) {
        return it.getTotal().getIndexCurrent();
    }

    private static final Object compileShardInfo$lambda$5(IndexingStats it) {
        return it.getTotal().getIndexTime();
    }

    private static final Object compileShardInfo$lambda$6(IndexingStats it) {
        return it.getTotal().getIndexCount();
    }

    private static final Object compileShardInfo$lambda$7(IndexingStats it) {
        return it.getTotal().getIndexFailedCount();
    }

    private static final Object compileShardInfo$lambda$8(SearchStats it) {
        return it.getTotal().getFetchCurrent();
    }

    private static final Object compileShardInfo$lambda$9(SearchStats it) {
        return it.getTotal().getFetchTime();
    }

    private static final Object compileShardInfo$lambda$10(SearchStats it) {
        return it.getTotal().getFetchCount();
    }

    private static final Object compileShardInfo$lambda$11(SearchStats it) {
        return it.getTotal().getQueryCurrent();
    }

    private static final Object compileShardInfo$lambda$12(SearchStats it) {
        return it.getTotal().getQueryTime();
    }

    private static final Object compileShardInfo$lambda$13(SearchStats it) {
        return it.getTotal().getQueryCount();
    }

    private static final Object compileShardInfo$lambda$14(SearchStats it) {
        return it.getTotal().getScrollCurrent();
    }

    private static final Object compileShardInfo$lambda$15(SearchStats it) {
        return it.getTotal().getScrollTime();
    }

    private static final Object compileShardInfo$lambda$16(SearchStats it) {
        return it.getTotal().getScrollCount();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatShardsResponseWrapper$Companion;", "", "()V", "WRAPPER_FIELD", "", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0003\b\u00bd\u0001\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00d1\u00012\u00020\u00012\u00020\u0002:\u0002\u00d1\u0001B\u00f1\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010 \u001a\u0004\u0018\u00010\u0004\u0012\b\u0010!\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\"\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010#\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010$\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010%\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010&\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010'\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010(\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010)\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010*\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010+\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010,\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010-\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010.\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010/\u001a\u0004\u0018\u00010\u0004\u0012\b\u00100\u001a\u0004\u0018\u00010\u0004\u0012\b\u00101\u001a\u0004\u0018\u00010\u0004\u0012\b\u00102\u001a\u0004\u0018\u00010\u0004\u0012\b\u00103\u001a\u0004\u0018\u00010\u0004\u0012\b\u00104\u001a\u0004\u0018\u00010\u0004\u0012\b\u00105\u001a\u0004\u0018\u00010\u0004\u0012\b\u00106\u001a\u0004\u0018\u00010\u0004\u0012\b\u00107\u001a\u0004\u0018\u00010\u0004\u0012\b\u00108\u001a\u0004\u0018\u00010\u0004\u0012\b\u00109\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010:\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010;\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010<\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010=\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010>\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010?\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010@\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010A\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010BJ\f\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u008f\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0093\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0095\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0098\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009c\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009d\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009e\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u009f\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a0\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a4\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a5\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a6\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a7\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a8\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00a9\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00aa\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ac\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ae\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00af\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b0\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b1\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b3\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b4\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b5\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b7\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b8\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00b9\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00ba\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bb\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bc\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bd\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00be\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\f\u0010\u00bf\u0001\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u00f2\u0005\u0010\u00c0\u0001\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0017\u0010\u00c1\u0001\u001a\u00030\u00c2\u00012\n\u0010\u00c3\u0001\u001a\u0005\u0018\u00010\u00c4\u0001H\u00d6\u0003J\u000b\u0010\u00c5\u0001\u001a\u00030\u00c6\u0001H\u00d6\u0001J\n\u0010\u00c7\u0001\u001a\u00020\u0004H\u00d6\u0001J\u001e\u0010\u00c8\u0001\u001a\u00030\u00c9\u00012\b\u0010\u00ca\u0001\u001a\u00030\u00c9\u00012\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u0001H\u0016J\u0014\u0010\u00cd\u0001\u001a\u00030\u00ce\u00012\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u0001H\u0016R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010DR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010DR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010DR\u0013\u00109\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010DR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010DR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010DR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010DR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010DR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010DR\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010DR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010DR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010DR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010DR\u0013\u0010:\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010DR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010DR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010DR\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010DR\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010DR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010DR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010DR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010DR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010DR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010DR\u0013\u0010;\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010DR\u0013\u0010<\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010DR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010DR\u0013\u0010 \u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010DR\u0013\u0010!\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010DR\u0013\u0010\"\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010DR\u0013\u0010#\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010DR\u0013\u0010$\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010DR\u0013\u0010%\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010DR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010DR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010DR\u0013\u0010'\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010DR\u0013\u0010&\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010DR\u0013\u0010(\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010DR\u0013\u0010*\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010DR\u0013\u0010)\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010DR\u0013\u0010+\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010DR\u0013\u0010,\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010DR\u0013\u0010-\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010DR\u0013\u0010.\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010DR\u0013\u0010/\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010DR\u0013\u00100\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010DR\u0013\u00101\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010DR\u0013\u00102\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010DR\u0013\u00103\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010DR\u0013\u00104\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010DR\u0013\u00105\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010DR\u0013\u00107\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010DR\u0013\u00106\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010DR\u0013\u00108\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010DR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bz\u0010DR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010DR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010DR\u0013\u0010=\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010DR\u0013\u0010>\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b~\u0010DR\u0013\u0010?\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010DR\u0014\u0010@\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0080\u0001\u0010DR\u0014\u0010A\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010D\u00a8\u0006\u00d2\u0001"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatShardsResponseWrapper$ShardInfo;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "index", "", "shard", "primaryOrReplica", "state", "docs", "store", "id", "node", "completionSize", "fieldDataMemory", "fieldDataEvictions", "flushTotal", "flushTotalTime", "getCurrent", "getTime", "getTotal", "getExistsTime", "getExistsTotal", "getMissingTime", "getMissingTotal", "indexingDeleteCurrent", "indexingDeleteTime", "indexingDeleteTotal", "indexingIndexCurrent", "indexingIndexTime", "indexingIndexTotal", "indexingIndexFailed", "mergesCurrent", "mergesCurrentDocs", "mergesCurrentSize", "mergesTotal", "mergesTotalDocs", "mergesTotalSize", "mergesTotalTime", "queryCacheMemory", "queryCacheEvictions", "recoverySourceType", "refreshTotal", "refreshTime", "searchFetchCurrent", "searchFetchTime", "searchFetchTotal", "searchOpenContexts", "searchQueryCurrent", "searchQueryTime", "searchQueryTotal", "searchScrollCurrent", "searchScrollTime", "searchScrollTotal", "segmentsCount", "segmentsMemory", "segmentsIndexWriterMemory", "segmentsVersionMapMemory", "fixedBitsetMemory", "globalCheckpoint", "localCheckpoint", "maxSeqNo", "syncId", "unassignedAt", "unassignedDetails", "unassignedFor", "unassignedReason", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCompletionSize", "()Ljava/lang/String;", "getDocs", "getFieldDataEvictions", "getFieldDataMemory", "getFixedBitsetMemory", "getFlushTotal", "getFlushTotalTime", "getGetCurrent", "getGetExistsTime", "getGetExistsTotal", "getGetMissingTime", "getGetMissingTotal", "getGetTime", "getGetTotal", "getGlobalCheckpoint", "getId", "getIndex", "getIndexingDeleteCurrent", "getIndexingDeleteTime", "getIndexingDeleteTotal", "getIndexingIndexCurrent", "getIndexingIndexFailed", "getIndexingIndexTime", "getIndexingIndexTotal", "getLocalCheckpoint", "getMaxSeqNo", "getMergesCurrent", "getMergesCurrentDocs", "getMergesCurrentSize", "getMergesTotal", "getMergesTotalDocs", "getMergesTotalSize", "getMergesTotalTime", "getNode", "getPrimaryOrReplica", "getQueryCacheEvictions", "getQueryCacheMemory", "getRecoverySourceType", "getRefreshTime", "getRefreshTotal", "getSearchFetchCurrent", "getSearchFetchTime", "getSearchFetchTotal", "getSearchOpenContexts", "getSearchQueryCurrent", "getSearchQueryTime", "getSearchQueryTotal", "getSearchScrollCurrent", "getSearchScrollTime", "getSearchScrollTotal", "getSegmentsCount", "getSegmentsIndexWriterMemory", "getSegmentsMemory", "getSegmentsVersionMapMemory", "getShard", "getState", "getStore", "getSyncId", "getUnassignedAt", "getUnassignedDetails", "getUnassignedFor", "getUnassignedReason", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component28", "component29", "component3", "component30", "component31", "component32", "component33", "component34", "component35", "component36", "component37", "component38", "component39", "component4", "component40", "component41", "component42", "component43", "component44", "component45", "component46", "component47", "component48", "component49", "component5", "component50", "component51", "component52", "component53", "component54", "component55", "component56", "component57", "component58", "component59", "component6", "component60", "component61", "component62", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
    public static final class ShardInfo
    implements ToXContentObject,
    Writeable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String index;
        @Nullable
        private final String shard;
        @Nullable
        private final String primaryOrReplica;
        @Nullable
        private final String state;
        @Nullable
        private final String docs;
        @Nullable
        private final String store;
        @Nullable
        private final String id;
        @Nullable
        private final String node;
        @Nullable
        private final String completionSize;
        @Nullable
        private final String fieldDataMemory;
        @Nullable
        private final String fieldDataEvictions;
        @Nullable
        private final String flushTotal;
        @Nullable
        private final String flushTotalTime;
        @Nullable
        private final String getCurrent;
        @Nullable
        private final String getTime;
        @Nullable
        private final String getTotal;
        @Nullable
        private final String getExistsTime;
        @Nullable
        private final String getExistsTotal;
        @Nullable
        private final String getMissingTime;
        @Nullable
        private final String getMissingTotal;
        @Nullable
        private final String indexingDeleteCurrent;
        @Nullable
        private final String indexingDeleteTime;
        @Nullable
        private final String indexingDeleteTotal;
        @Nullable
        private final String indexingIndexCurrent;
        @Nullable
        private final String indexingIndexTime;
        @Nullable
        private final String indexingIndexTotal;
        @Nullable
        private final String indexingIndexFailed;
        @Nullable
        private final String mergesCurrent;
        @Nullable
        private final String mergesCurrentDocs;
        @Nullable
        private final String mergesCurrentSize;
        @Nullable
        private final String mergesTotal;
        @Nullable
        private final String mergesTotalDocs;
        @Nullable
        private final String mergesTotalSize;
        @Nullable
        private final String mergesTotalTime;
        @Nullable
        private final String queryCacheMemory;
        @Nullable
        private final String queryCacheEvictions;
        @Nullable
        private final String recoverySourceType;
        @Nullable
        private final String refreshTotal;
        @Nullable
        private final String refreshTime;
        @Nullable
        private final String searchFetchCurrent;
        @Nullable
        private final String searchFetchTime;
        @Nullable
        private final String searchFetchTotal;
        @Nullable
        private final String searchOpenContexts;
        @Nullable
        private final String searchQueryCurrent;
        @Nullable
        private final String searchQueryTime;
        @Nullable
        private final String searchQueryTotal;
        @Nullable
        private final String searchScrollCurrent;
        @Nullable
        private final String searchScrollTime;
        @Nullable
        private final String searchScrollTotal;
        @Nullable
        private final String segmentsCount;
        @Nullable
        private final String segmentsMemory;
        @Nullable
        private final String segmentsIndexWriterMemory;
        @Nullable
        private final String segmentsVersionMapMemory;
        @Nullable
        private final String fixedBitsetMemory;
        @Nullable
        private final String globalCheckpoint;
        @Nullable
        private final String localCheckpoint;
        @Nullable
        private final String maxSeqNo;
        @Nullable
        private final String syncId;
        @Nullable
        private final String unassignedAt;
        @Nullable
        private final String unassignedDetails;
        @Nullable
        private final String unassignedFor;
        @Nullable
        private final String unassignedReason;
        @NotNull
        public static final String INDEX_FIELD = "index";
        @NotNull
        public static final String SHARD_FIELD = "shard";
        @NotNull
        public static final String PRIMARY_OR_REPLICA_FIELD = "primaryOrReplica";
        @NotNull
        public static final String STATE_FIELD = "state";
        @NotNull
        public static final String DOCS_FIELD = "docs";
        @NotNull
        public static final String STORE_FIELD = "store";
        @NotNull
        public static final String ID_FIELD = "id";
        @NotNull
        public static final String NODE_FIELD = "node";
        @NotNull
        public static final String COMPLETION_SIZE_FIELD = "completionSize";
        @NotNull
        public static final String FIELD_DATA_MEMORY_FIELD = "fielddataMemory";
        @NotNull
        public static final String FIELD_DATA_EVICTIONS_FIELD = "fielddataEvictions";
        @NotNull
        public static final String FLUSH_TOTAL_FIELD = "flushTotal";
        @NotNull
        public static final String FLUSH_TOTAL_TIME_FIELD = "flushTotalTime";
        @NotNull
        public static final String GET_CURRENT_FIELD = "getCurrent";
        @NotNull
        public static final String GET_TIME_FIELD = "getTime";
        @NotNull
        public static final String GET_TOTAL_FIELD = "getTotal";
        @NotNull
        public static final String GET_EXISTS_TIME_FIELD = "getExistsTime";
        @NotNull
        public static final String GET_EXISTS_TOTAL_FIELD = "getExistsTotal";
        @NotNull
        public static final String GET_MISSING_TIME_FIELD = "getMissingTime";
        @NotNull
        public static final String GET_MISSING_TOTAL_FIELD = "getMissingTotal";
        @NotNull
        public static final String INDEXING_DELETE_CURRENT_FIELD = "indexingDeleteCurrent";
        @NotNull
        public static final String INDEXING_DELETE_TIME_FIELD = "indexingDeleteTime";
        @NotNull
        public static final String INDEXING_DELETE_TOTAL_FIELD = "indexingDeleteTotal";
        @NotNull
        public static final String INDEXING_INDEX_CURRENT_FIELD = "indexingIndexCurrent";
        @NotNull
        public static final String INDEXING_INDEX_TIME_FIELD = "indexingIndexTime";
        @NotNull
        public static final String INDEXING_INDEX_TOTAL_FIELD = "indexingIndexTotal";
        @NotNull
        public static final String INDEXING_INDEX_FAILED_FIELD = "indexingIndexFailed";
        @NotNull
        public static final String MERGES_CURRENT_FIELD = "mergesCurrent";
        @NotNull
        public static final String MERGES_CURRENT_DOCS_FIELD = "mergesCurrentDocs";
        @NotNull
        public static final String MERGES_CURRENT_SIZE_FIELD = "mergesCurrentSize";
        @NotNull
        public static final String MERGES_TOTAL_FIELD = "mergesTotal";
        @NotNull
        public static final String MERGES_TOTAL_DOCS_FIELD = "mergesTotalDocs";
        @NotNull
        public static final String MERGES_TOTAL_SIZE_FIELD = "mergesTotalSize";
        @NotNull
        public static final String MERGES_TOTAL_TIME_FIELD = "mergesTotalTime";
        @NotNull
        public static final String QUERY_CACHE_MEMORY_FIELD = "queryCacheMemory";
        @NotNull
        public static final String QUERY_CACHE_EVICTIONS_FIELD = "queryCacheEvictions";
        @NotNull
        public static final String RECOVERY_SOURCE_TYPE_FIELD = "recoverysource.type";
        @NotNull
        public static final String REFRESH_TOTAL_FIELD = "refreshTotal";
        @NotNull
        public static final String REFRESH_TIME_FIELD = "refreshTime";
        @NotNull
        public static final String SEARCH_FETCH_CURRENT_FIELD = "searchFetchCurrent";
        @NotNull
        public static final String SEARCH_FETCH_TIME_FIELD = "searchFetchTime";
        @NotNull
        public static final String SEARCH_FETCH_TOTAL_FIELD = "searchFetchTotal";
        @NotNull
        public static final String SEARCH_OPEN_CONTEXTS_FIELD = "searchOpenContexts";
        @NotNull
        public static final String SEARCH_QUERY_CURRENT_FIELD = "searchQueryCurrent";
        @NotNull
        public static final String SEARCH_QUERY_TIME_FIELD = "searchQueryTime";
        @NotNull
        public static final String SEARCH_QUERY_TOTAL_FIELD = "searchQueryTotal";
        @NotNull
        public static final String SEARCH_SCROLL_CURRENT_FIELD = "searchScrollCurrent";
        @NotNull
        public static final String SEARCH_SCROLL_TIME_FIELD = "searchScrollTime";
        @NotNull
        public static final String SEARCH_SCROLL_TOTAL_FIELD = "searchScrollTotal";
        @NotNull
        public static final String SEGMENTS_COUNT_FIELD = "segmentsCount";
        @NotNull
        public static final String SEGMENTS_MEMORY_FIELD = "segmentsMemory";
        @NotNull
        public static final String SEGMENTS_INDEX_WRITER_MEMORY_FIELD = "segmentsIndexWriterMemory";
        @NotNull
        public static final String SEGMENTS_VERSION_MAP_MEMORY_FIELD = "segmentsVersionMapMemory";
        @NotNull
        public static final String FIXED_BITSET_MEMORY_FIELD = "fixedBitsetMemory";
        @NotNull
        public static final String GLOBAL_CHECKPOINT_FIELD = "globalCheckpoint";
        @NotNull
        public static final String LOCAL_CHECKPOINT_FIELD = "localCheckpoint";
        @NotNull
        public static final String MAX_SEQ_NO_FIELD = "maxSeqNo";
        @NotNull
        public static final String SYNC_ID_FIELD = "sync_id";
        @NotNull
        public static final String UNASSIGNED_AT_FIELD = "unassigned.at";
        @NotNull
        public static final String UNASSIGNED_DETAILS_FIELD = "unassigned.details";
        @NotNull
        public static final String UNASSIGNED_FOR_FIELD = "unassigned.for";
        @NotNull
        public static final String UNASSIGNED_REASON_FIELD = "unassigned.reason";

        public ShardInfo(@Nullable String index, @Nullable String shard, @Nullable String primaryOrReplica, @Nullable String state, @Nullable String docs, @Nullable String store, @Nullable String id, @Nullable String node, @Nullable String completionSize, @Nullable String fieldDataMemory, @Nullable String fieldDataEvictions, @Nullable String flushTotal, @Nullable String flushTotalTime, @Nullable String getCurrent, @Nullable String getTime, @Nullable String getTotal, @Nullable String getExistsTime, @Nullable String getExistsTotal, @Nullable String getMissingTime, @Nullable String getMissingTotal, @Nullable String indexingDeleteCurrent, @Nullable String indexingDeleteTime, @Nullable String indexingDeleteTotal, @Nullable String indexingIndexCurrent, @Nullable String indexingIndexTime, @Nullable String indexingIndexTotal, @Nullable String indexingIndexFailed, @Nullable String mergesCurrent, @Nullable String mergesCurrentDocs, @Nullable String mergesCurrentSize, @Nullable String mergesTotal, @Nullable String mergesTotalDocs, @Nullable String mergesTotalSize, @Nullable String mergesTotalTime, @Nullable String queryCacheMemory, @Nullable String queryCacheEvictions, @Nullable String recoverySourceType, @Nullable String refreshTotal, @Nullable String refreshTime, @Nullable String searchFetchCurrent, @Nullable String searchFetchTime, @Nullable String searchFetchTotal, @Nullable String searchOpenContexts, @Nullable String searchQueryCurrent, @Nullable String searchQueryTime, @Nullable String searchQueryTotal, @Nullable String searchScrollCurrent, @Nullable String searchScrollTime, @Nullable String searchScrollTotal, @Nullable String segmentsCount, @Nullable String segmentsMemory, @Nullable String segmentsIndexWriterMemory, @Nullable String segmentsVersionMapMemory, @Nullable String fixedBitsetMemory, @Nullable String globalCheckpoint, @Nullable String localCheckpoint, @Nullable String maxSeqNo, @Nullable String syncId, @Nullable String unassignedAt, @Nullable String unassignedDetails, @Nullable String unassignedFor, @Nullable String unassignedReason) {
            this.index = index;
            this.shard = shard;
            this.primaryOrReplica = primaryOrReplica;
            this.state = state;
            this.docs = docs;
            this.store = store;
            this.id = id;
            this.node = node;
            this.completionSize = completionSize;
            this.fieldDataMemory = fieldDataMemory;
            this.fieldDataEvictions = fieldDataEvictions;
            this.flushTotal = flushTotal;
            this.flushTotalTime = flushTotalTime;
            this.getCurrent = getCurrent;
            this.getTime = getTime;
            this.getTotal = getTotal;
            this.getExistsTime = getExistsTime;
            this.getExistsTotal = getExistsTotal;
            this.getMissingTime = getMissingTime;
            this.getMissingTotal = getMissingTotal;
            this.indexingDeleteCurrent = indexingDeleteCurrent;
            this.indexingDeleteTime = indexingDeleteTime;
            this.indexingDeleteTotal = indexingDeleteTotal;
            this.indexingIndexCurrent = indexingIndexCurrent;
            this.indexingIndexTime = indexingIndexTime;
            this.indexingIndexTotal = indexingIndexTotal;
            this.indexingIndexFailed = indexingIndexFailed;
            this.mergesCurrent = mergesCurrent;
            this.mergesCurrentDocs = mergesCurrentDocs;
            this.mergesCurrentSize = mergesCurrentSize;
            this.mergesTotal = mergesTotal;
            this.mergesTotalDocs = mergesTotalDocs;
            this.mergesTotalSize = mergesTotalSize;
            this.mergesTotalTime = mergesTotalTime;
            this.queryCacheMemory = queryCacheMemory;
            this.queryCacheEvictions = queryCacheEvictions;
            this.recoverySourceType = recoverySourceType;
            this.refreshTotal = refreshTotal;
            this.refreshTime = refreshTime;
            this.searchFetchCurrent = searchFetchCurrent;
            this.searchFetchTime = searchFetchTime;
            this.searchFetchTotal = searchFetchTotal;
            this.searchOpenContexts = searchOpenContexts;
            this.searchQueryCurrent = searchQueryCurrent;
            this.searchQueryTime = searchQueryTime;
            this.searchQueryTotal = searchQueryTotal;
            this.searchScrollCurrent = searchScrollCurrent;
            this.searchScrollTime = searchScrollTime;
            this.searchScrollTotal = searchScrollTotal;
            this.segmentsCount = segmentsCount;
            this.segmentsMemory = segmentsMemory;
            this.segmentsIndexWriterMemory = segmentsIndexWriterMemory;
            this.segmentsVersionMapMemory = segmentsVersionMapMemory;
            this.fixedBitsetMemory = fixedBitsetMemory;
            this.globalCheckpoint = globalCheckpoint;
            this.localCheckpoint = localCheckpoint;
            this.maxSeqNo = maxSeqNo;
            this.syncId = syncId;
            this.unassignedAt = unassignedAt;
            this.unassignedDetails = unassignedDetails;
            this.unassignedFor = unassignedFor;
            this.unassignedReason = unassignedReason;
        }

        @Nullable
        public final String getIndex() {
            return this.index;
        }

        @Nullable
        public final String getShard() {
            return this.shard;
        }

        @Nullable
        public final String getPrimaryOrReplica() {
            return this.primaryOrReplica;
        }

        @Nullable
        public final String getState() {
            return this.state;
        }

        @Nullable
        public final String getDocs() {
            return this.docs;
        }

        @Nullable
        public final String getStore() {
            return this.store;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getNode() {
            return this.node;
        }

        @Nullable
        public final String getCompletionSize() {
            return this.completionSize;
        }

        @Nullable
        public final String getFieldDataMemory() {
            return this.fieldDataMemory;
        }

        @Nullable
        public final String getFieldDataEvictions() {
            return this.fieldDataEvictions;
        }

        @Nullable
        public final String getFlushTotal() {
            return this.flushTotal;
        }

        @Nullable
        public final String getFlushTotalTime() {
            return this.flushTotalTime;
        }

        @Nullable
        public final String getGetCurrent() {
            return this.getCurrent;
        }

        @Nullable
        public final String getGetTime() {
            return this.getTime;
        }

        @Nullable
        public final String getGetTotal() {
            return this.getTotal;
        }

        @Nullable
        public final String getGetExistsTime() {
            return this.getExistsTime;
        }

        @Nullable
        public final String getGetExistsTotal() {
            return this.getExistsTotal;
        }

        @Nullable
        public final String getGetMissingTime() {
            return this.getMissingTime;
        }

        @Nullable
        public final String getGetMissingTotal() {
            return this.getMissingTotal;
        }

        @Nullable
        public final String getIndexingDeleteCurrent() {
            return this.indexingDeleteCurrent;
        }

        @Nullable
        public final String getIndexingDeleteTime() {
            return this.indexingDeleteTime;
        }

        @Nullable
        public final String getIndexingDeleteTotal() {
            return this.indexingDeleteTotal;
        }

        @Nullable
        public final String getIndexingIndexCurrent() {
            return this.indexingIndexCurrent;
        }

        @Nullable
        public final String getIndexingIndexTime() {
            return this.indexingIndexTime;
        }

        @Nullable
        public final String getIndexingIndexTotal() {
            return this.indexingIndexTotal;
        }

        @Nullable
        public final String getIndexingIndexFailed() {
            return this.indexingIndexFailed;
        }

        @Nullable
        public final String getMergesCurrent() {
            return this.mergesCurrent;
        }

        @Nullable
        public final String getMergesCurrentDocs() {
            return this.mergesCurrentDocs;
        }

        @Nullable
        public final String getMergesCurrentSize() {
            return this.mergesCurrentSize;
        }

        @Nullable
        public final String getMergesTotal() {
            return this.mergesTotal;
        }

        @Nullable
        public final String getMergesTotalDocs() {
            return this.mergesTotalDocs;
        }

        @Nullable
        public final String getMergesTotalSize() {
            return this.mergesTotalSize;
        }

        @Nullable
        public final String getMergesTotalTime() {
            return this.mergesTotalTime;
        }

        @Nullable
        public final String getQueryCacheMemory() {
            return this.queryCacheMemory;
        }

        @Nullable
        public final String getQueryCacheEvictions() {
            return this.queryCacheEvictions;
        }

        @Nullable
        public final String getRecoverySourceType() {
            return this.recoverySourceType;
        }

        @Nullable
        public final String getRefreshTotal() {
            return this.refreshTotal;
        }

        @Nullable
        public final String getRefreshTime() {
            return this.refreshTime;
        }

        @Nullable
        public final String getSearchFetchCurrent() {
            return this.searchFetchCurrent;
        }

        @Nullable
        public final String getSearchFetchTime() {
            return this.searchFetchTime;
        }

        @Nullable
        public final String getSearchFetchTotal() {
            return this.searchFetchTotal;
        }

        @Nullable
        public final String getSearchOpenContexts() {
            return this.searchOpenContexts;
        }

        @Nullable
        public final String getSearchQueryCurrent() {
            return this.searchQueryCurrent;
        }

        @Nullable
        public final String getSearchQueryTime() {
            return this.searchQueryTime;
        }

        @Nullable
        public final String getSearchQueryTotal() {
            return this.searchQueryTotal;
        }

        @Nullable
        public final String getSearchScrollCurrent() {
            return this.searchScrollCurrent;
        }

        @Nullable
        public final String getSearchScrollTime() {
            return this.searchScrollTime;
        }

        @Nullable
        public final String getSearchScrollTotal() {
            return this.searchScrollTotal;
        }

        @Nullable
        public final String getSegmentsCount() {
            return this.segmentsCount;
        }

        @Nullable
        public final String getSegmentsMemory() {
            return this.segmentsMemory;
        }

        @Nullable
        public final String getSegmentsIndexWriterMemory() {
            return this.segmentsIndexWriterMemory;
        }

        @Nullable
        public final String getSegmentsVersionMapMemory() {
            return this.segmentsVersionMapMemory;
        }

        @Nullable
        public final String getFixedBitsetMemory() {
            return this.fixedBitsetMemory;
        }

        @Nullable
        public final String getGlobalCheckpoint() {
            return this.globalCheckpoint;
        }

        @Nullable
        public final String getLocalCheckpoint() {
            return this.localCheckpoint;
        }

        @Nullable
        public final String getMaxSeqNo() {
            return this.maxSeqNo;
        }

        @Nullable
        public final String getSyncId() {
            return this.syncId;
        }

        @Nullable
        public final String getUnassignedAt() {
            return this.unassignedAt;
        }

        @Nullable
        public final String getUnassignedDetails() {
            return this.unassignedDetails;
        }

        @Nullable
        public final String getUnassignedFor() {
            return this.unassignedFor;
        }

        @Nullable
        public final String getUnassignedReason() {
            return this.unassignedReason;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            builder.startObject().field(INDEX_FIELD, this.index).field(SHARD_FIELD, this.shard).field(PRIMARY_OR_REPLICA_FIELD, this.primaryOrReplica).field(STATE_FIELD, this.state).field(DOCS_FIELD, this.docs).field(STORE_FIELD, this.store).field(ID_FIELD, this.id).field(NODE_FIELD, this.node).field(COMPLETION_SIZE_FIELD, this.completionSize).field(FIELD_DATA_MEMORY_FIELD, this.fieldDataMemory).field(FIELD_DATA_EVICTIONS_FIELD, this.fieldDataEvictions).field(FLUSH_TOTAL_FIELD, this.flushTotal).field(FLUSH_TOTAL_TIME_FIELD, this.flushTotalTime).field(GET_CURRENT_FIELD, this.getCurrent).field(GET_TIME_FIELD, this.getTime).field(GET_TOTAL_FIELD, this.getTotal).field(GET_EXISTS_TIME_FIELD, this.getExistsTime).field(GET_EXISTS_TOTAL_FIELD, this.getExistsTotal).field(GET_MISSING_TIME_FIELD, this.getMissingTime).field(GET_MISSING_TOTAL_FIELD, this.getMissingTotal).field(INDEXING_DELETE_CURRENT_FIELD, this.indexingDeleteCurrent).field(INDEXING_DELETE_TIME_FIELD, this.indexingDeleteTime).field(INDEXING_DELETE_TOTAL_FIELD, this.indexingDeleteTotal).field(INDEXING_INDEX_CURRENT_FIELD, this.indexingIndexCurrent).field(INDEXING_INDEX_TIME_FIELD, this.indexingIndexTime).field(INDEXING_INDEX_TOTAL_FIELD, this.indexingIndexTotal).field(INDEXING_INDEX_FAILED_FIELD, this.indexingIndexFailed).field(MERGES_CURRENT_FIELD, this.mergesCurrent).field(MERGES_CURRENT_DOCS_FIELD, this.mergesCurrentDocs).field(MERGES_CURRENT_SIZE_FIELD, this.mergesCurrentSize).field(MERGES_TOTAL_FIELD, this.mergesTotal).field(MERGES_TOTAL_DOCS_FIELD, this.mergesTotalDocs).field(MERGES_TOTAL_SIZE_FIELD, this.mergesTotalSize).field(MERGES_TOTAL_TIME_FIELD, this.mergesTotalTime).field(QUERY_CACHE_MEMORY_FIELD, this.queryCacheMemory).field(QUERY_CACHE_EVICTIONS_FIELD, this.queryCacheEvictions).field(RECOVERY_SOURCE_TYPE_FIELD, this.recoverySourceType).field(REFRESH_TOTAL_FIELD, this.refreshTotal).field(REFRESH_TIME_FIELD, this.refreshTime).field(SEARCH_FETCH_CURRENT_FIELD, this.searchFetchCurrent).field(SEARCH_FETCH_TIME_FIELD, this.searchFetchTime).field(SEARCH_FETCH_TOTAL_FIELD, this.searchFetchTotal).field(SEARCH_OPEN_CONTEXTS_FIELD, this.searchOpenContexts).field(SEARCH_QUERY_CURRENT_FIELD, this.searchQueryCurrent).field(SEARCH_QUERY_TIME_FIELD, this.searchQueryTime).field(SEARCH_QUERY_TOTAL_FIELD, this.searchQueryTotal).field(SEARCH_SCROLL_CURRENT_FIELD, this.searchScrollCurrent).field(SEARCH_SCROLL_TIME_FIELD, this.searchScrollTime).field(SEARCH_SCROLL_TOTAL_FIELD, this.searchScrollTotal).field(SEGMENTS_COUNT_FIELD, this.segmentsCount).field(SEGMENTS_MEMORY_FIELD, this.segmentsMemory).field(SEGMENTS_INDEX_WRITER_MEMORY_FIELD, this.segmentsIndexWriterMemory).field(SEGMENTS_VERSION_MAP_MEMORY_FIELD, this.segmentsVersionMapMemory).field(FIXED_BITSET_MEMORY_FIELD, this.fixedBitsetMemory).field(GLOBAL_CHECKPOINT_FIELD, this.globalCheckpoint).field(LOCAL_CHECKPOINT_FIELD, this.localCheckpoint).field(MAX_SEQ_NO_FIELD, this.maxSeqNo).field(SYNC_ID_FIELD, this.syncId).field(UNASSIGNED_AT_FIELD, this.unassignedAt).field(UNASSIGNED_DETAILS_FIELD, this.unassignedDetails).field(UNASSIGNED_FOR_FIELD, this.unassignedFor).field(UNASSIGNED_REASON_FIELD, this.unassignedReason);
            XContentBuilder xContentBuilder = builder.endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
            return xContentBuilder;
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.index);
            out.writeString(this.shard);
            out.writeString(this.primaryOrReplica);
            out.writeString(this.state);
            out.writeString(this.docs);
            out.writeString(this.store);
            out.writeString(this.id);
            out.writeString(this.node);
            out.writeString(this.completionSize);
            out.writeString(this.fieldDataMemory);
            out.writeString(this.fieldDataEvictions);
            out.writeString(this.flushTotal);
            out.writeString(this.flushTotalTime);
            out.writeString(this.getCurrent);
            out.writeString(this.getTime);
            out.writeString(this.getTotal);
            out.writeString(this.getExistsTime);
            out.writeString(this.getExistsTotal);
            out.writeString(this.getMissingTime);
            out.writeString(this.getMissingTotal);
            out.writeString(this.indexingDeleteCurrent);
            out.writeString(this.indexingDeleteTime);
            out.writeString(this.indexingDeleteTotal);
            out.writeString(this.indexingIndexCurrent);
            out.writeString(this.indexingIndexTime);
            out.writeString(this.indexingIndexTotal);
            out.writeString(this.indexingIndexFailed);
            out.writeString(this.mergesCurrent);
            out.writeString(this.mergesCurrentDocs);
            out.writeString(this.mergesCurrentSize);
            out.writeString(this.mergesTotal);
            out.writeString(this.mergesTotalDocs);
            out.writeString(this.mergesTotalSize);
            out.writeString(this.mergesTotalTime);
            out.writeString(this.queryCacheMemory);
            out.writeString(this.queryCacheEvictions);
            out.writeString(this.recoverySourceType);
            out.writeString(this.refreshTotal);
            out.writeString(this.refreshTime);
            out.writeString(this.searchFetchCurrent);
            out.writeString(this.searchFetchTime);
            out.writeString(this.searchFetchTotal);
            out.writeString(this.searchOpenContexts);
            out.writeString(this.searchQueryCurrent);
            out.writeString(this.searchQueryTime);
            out.writeString(this.searchQueryTotal);
            out.writeString(this.searchScrollCurrent);
            out.writeString(this.searchScrollTime);
            out.writeString(this.searchScrollTotal);
            out.writeString(this.segmentsCount);
            out.writeString(this.segmentsMemory);
            out.writeString(this.segmentsIndexWriterMemory);
            out.writeString(this.segmentsVersionMapMemory);
            out.writeString(this.fixedBitsetMemory);
            out.writeString(this.globalCheckpoint);
            out.writeString(this.localCheckpoint);
            out.writeString(this.maxSeqNo);
            out.writeString(this.syncId);
            out.writeString(this.unassignedAt);
            out.writeString(this.unassignedDetails);
            out.writeString(this.unassignedFor);
            out.writeString(this.unassignedReason);
        }

        @Nullable
        public final String component1() {
            return this.index;
        }

        @Nullable
        public final String component2() {
            return this.shard;
        }

        @Nullable
        public final String component3() {
            return this.primaryOrReplica;
        }

        @Nullable
        public final String component4() {
            return this.state;
        }

        @Nullable
        public final String component5() {
            return this.docs;
        }

        @Nullable
        public final String component6() {
            return this.store;
        }

        @Nullable
        public final String component7() {
            return this.id;
        }

        @Nullable
        public final String component8() {
            return this.node;
        }

        @Nullable
        public final String component9() {
            return this.completionSize;
        }

        @Nullable
        public final String component10() {
            return this.fieldDataMemory;
        }

        @Nullable
        public final String component11() {
            return this.fieldDataEvictions;
        }

        @Nullable
        public final String component12() {
            return this.flushTotal;
        }

        @Nullable
        public final String component13() {
            return this.flushTotalTime;
        }

        @Nullable
        public final String component14() {
            return this.getCurrent;
        }

        @Nullable
        public final String component15() {
            return this.getTime;
        }

        @Nullable
        public final String component16() {
            return this.getTotal;
        }

        @Nullable
        public final String component17() {
            return this.getExistsTime;
        }

        @Nullable
        public final String component18() {
            return this.getExistsTotal;
        }

        @Nullable
        public final String component19() {
            return this.getMissingTime;
        }

        @Nullable
        public final String component20() {
            return this.getMissingTotal;
        }

        @Nullable
        public final String component21() {
            return this.indexingDeleteCurrent;
        }

        @Nullable
        public final String component22() {
            return this.indexingDeleteTime;
        }

        @Nullable
        public final String component23() {
            return this.indexingDeleteTotal;
        }

        @Nullable
        public final String component24() {
            return this.indexingIndexCurrent;
        }

        @Nullable
        public final String component25() {
            return this.indexingIndexTime;
        }

        @Nullable
        public final String component26() {
            return this.indexingIndexTotal;
        }

        @Nullable
        public final String component27() {
            return this.indexingIndexFailed;
        }

        @Nullable
        public final String component28() {
            return this.mergesCurrent;
        }

        @Nullable
        public final String component29() {
            return this.mergesCurrentDocs;
        }

        @Nullable
        public final String component30() {
            return this.mergesCurrentSize;
        }

        @Nullable
        public final String component31() {
            return this.mergesTotal;
        }

        @Nullable
        public final String component32() {
            return this.mergesTotalDocs;
        }

        @Nullable
        public final String component33() {
            return this.mergesTotalSize;
        }

        @Nullable
        public final String component34() {
            return this.mergesTotalTime;
        }

        @Nullable
        public final String component35() {
            return this.queryCacheMemory;
        }

        @Nullable
        public final String component36() {
            return this.queryCacheEvictions;
        }

        @Nullable
        public final String component37() {
            return this.recoverySourceType;
        }

        @Nullable
        public final String component38() {
            return this.refreshTotal;
        }

        @Nullable
        public final String component39() {
            return this.refreshTime;
        }

        @Nullable
        public final String component40() {
            return this.searchFetchCurrent;
        }

        @Nullable
        public final String component41() {
            return this.searchFetchTime;
        }

        @Nullable
        public final String component42() {
            return this.searchFetchTotal;
        }

        @Nullable
        public final String component43() {
            return this.searchOpenContexts;
        }

        @Nullable
        public final String component44() {
            return this.searchQueryCurrent;
        }

        @Nullable
        public final String component45() {
            return this.searchQueryTime;
        }

        @Nullable
        public final String component46() {
            return this.searchQueryTotal;
        }

        @Nullable
        public final String component47() {
            return this.searchScrollCurrent;
        }

        @Nullable
        public final String component48() {
            return this.searchScrollTime;
        }

        @Nullable
        public final String component49() {
            return this.searchScrollTotal;
        }

        @Nullable
        public final String component50() {
            return this.segmentsCount;
        }

        @Nullable
        public final String component51() {
            return this.segmentsMemory;
        }

        @Nullable
        public final String component52() {
            return this.segmentsIndexWriterMemory;
        }

        @Nullable
        public final String component53() {
            return this.segmentsVersionMapMemory;
        }

        @Nullable
        public final String component54() {
            return this.fixedBitsetMemory;
        }

        @Nullable
        public final String component55() {
            return this.globalCheckpoint;
        }

        @Nullable
        public final String component56() {
            return this.localCheckpoint;
        }

        @Nullable
        public final String component57() {
            return this.maxSeqNo;
        }

        @Nullable
        public final String component58() {
            return this.syncId;
        }

        @Nullable
        public final String component59() {
            return this.unassignedAt;
        }

        @Nullable
        public final String component60() {
            return this.unassignedDetails;
        }

        @Nullable
        public final String component61() {
            return this.unassignedFor;
        }

        @Nullable
        public final String component62() {
            return this.unassignedReason;
        }

        @NotNull
        public final ShardInfo copy(@Nullable String index, @Nullable String shard, @Nullable String primaryOrReplica, @Nullable String state, @Nullable String docs, @Nullable String store, @Nullable String id, @Nullable String node, @Nullable String completionSize, @Nullable String fieldDataMemory, @Nullable String fieldDataEvictions, @Nullable String flushTotal, @Nullable String flushTotalTime, @Nullable String getCurrent, @Nullable String getTime, @Nullable String getTotal, @Nullable String getExistsTime, @Nullable String getExistsTotal, @Nullable String getMissingTime, @Nullable String getMissingTotal, @Nullable String indexingDeleteCurrent, @Nullable String indexingDeleteTime, @Nullable String indexingDeleteTotal, @Nullable String indexingIndexCurrent, @Nullable String indexingIndexTime, @Nullable String indexingIndexTotal, @Nullable String indexingIndexFailed, @Nullable String mergesCurrent, @Nullable String mergesCurrentDocs, @Nullable String mergesCurrentSize, @Nullable String mergesTotal, @Nullable String mergesTotalDocs, @Nullable String mergesTotalSize, @Nullable String mergesTotalTime, @Nullable String queryCacheMemory, @Nullable String queryCacheEvictions, @Nullable String recoverySourceType, @Nullable String refreshTotal, @Nullable String refreshTime, @Nullable String searchFetchCurrent, @Nullable String searchFetchTime, @Nullable String searchFetchTotal, @Nullable String searchOpenContexts, @Nullable String searchQueryCurrent, @Nullable String searchQueryTime, @Nullable String searchQueryTotal, @Nullable String searchScrollCurrent, @Nullable String searchScrollTime, @Nullable String searchScrollTotal, @Nullable String segmentsCount, @Nullable String segmentsMemory, @Nullable String segmentsIndexWriterMemory, @Nullable String segmentsVersionMapMemory, @Nullable String fixedBitsetMemory, @Nullable String globalCheckpoint, @Nullable String localCheckpoint, @Nullable String maxSeqNo, @Nullable String syncId, @Nullable String unassignedAt, @Nullable String unassignedDetails, @Nullable String unassignedFor, @Nullable String unassignedReason) {
            return new ShardInfo(index, shard, primaryOrReplica, state, docs, store, id, node, completionSize, fieldDataMemory, fieldDataEvictions, flushTotal, flushTotalTime, getCurrent, getTime, getTotal, getExistsTime, getExistsTotal, getMissingTime, getMissingTotal, indexingDeleteCurrent, indexingDeleteTime, indexingDeleteTotal, indexingIndexCurrent, indexingIndexTime, indexingIndexTotal, indexingIndexFailed, mergesCurrent, mergesCurrentDocs, mergesCurrentSize, mergesTotal, mergesTotalDocs, mergesTotalSize, mergesTotalTime, queryCacheMemory, queryCacheEvictions, recoverySourceType, refreshTotal, refreshTime, searchFetchCurrent, searchFetchTime, searchFetchTotal, searchOpenContexts, searchQueryCurrent, searchQueryTime, searchQueryTotal, searchScrollCurrent, searchScrollTime, searchScrollTotal, segmentsCount, segmentsMemory, segmentsIndexWriterMemory, segmentsVersionMapMemory, fixedBitsetMemory, globalCheckpoint, localCheckpoint, maxSeqNo, syncId, unassignedAt, unassignedDetails, unassignedFor, unassignedReason);
        }

        public static /* synthetic */ ShardInfo copy$default(ShardInfo shardInfo, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21, String string22, String string23, String string24, String string25, String string26, String string27, String string28, String string29, String string30, String string31, String string32, String string33, String string34, String string35, String string36, String string37, String string38, String string39, String string40, String string41, String string42, String string43, String string44, String string45, String string46, String string47, String string48, String string49, String string50, String string51, String string52, String string53, String string54, String string55, String string56, String string57, String string58, String string59, String string60, String string61, String string62, int n, int n2, Object object) {
            if ((n & 1) != 0) {
                string = shardInfo.index;
            }
            if ((n & 2) != 0) {
                string2 = shardInfo.shard;
            }
            if ((n & 4) != 0) {
                string3 = shardInfo.primaryOrReplica;
            }
            if ((n & 8) != 0) {
                string4 = shardInfo.state;
            }
            if ((n & 0x10) != 0) {
                string5 = shardInfo.docs;
            }
            if ((n & 0x20) != 0) {
                string6 = shardInfo.store;
            }
            if ((n & 0x40) != 0) {
                string7 = shardInfo.id;
            }
            if ((n & 0x80) != 0) {
                string8 = shardInfo.node;
            }
            if ((n & 0x100) != 0) {
                string9 = shardInfo.completionSize;
            }
            if ((n & 0x200) != 0) {
                string10 = shardInfo.fieldDataMemory;
            }
            if ((n & 0x400) != 0) {
                string11 = shardInfo.fieldDataEvictions;
            }
            if ((n & 0x800) != 0) {
                string12 = shardInfo.flushTotal;
            }
            if ((n & 0x1000) != 0) {
                string13 = shardInfo.flushTotalTime;
            }
            if ((n & 0x2000) != 0) {
                string14 = shardInfo.getCurrent;
            }
            if ((n & 0x4000) != 0) {
                string15 = shardInfo.getTime;
            }
            if ((n & 0x8000) != 0) {
                string16 = shardInfo.getTotal;
            }
            if ((n & 0x10000) != 0) {
                string17 = shardInfo.getExistsTime;
            }
            if ((n & 0x20000) != 0) {
                string18 = shardInfo.getExistsTotal;
            }
            if ((n & 0x40000) != 0) {
                string19 = shardInfo.getMissingTime;
            }
            if ((n & 0x80000) != 0) {
                string20 = shardInfo.getMissingTotal;
            }
            if ((n & 0x100000) != 0) {
                string21 = shardInfo.indexingDeleteCurrent;
            }
            if ((n & 0x200000) != 0) {
                string22 = shardInfo.indexingDeleteTime;
            }
            if ((n & 0x400000) != 0) {
                string23 = shardInfo.indexingDeleteTotal;
            }
            if ((n & 0x800000) != 0) {
                string24 = shardInfo.indexingIndexCurrent;
            }
            if ((n & 0x1000000) != 0) {
                string25 = shardInfo.indexingIndexTime;
            }
            if ((n & 0x2000000) != 0) {
                string26 = shardInfo.indexingIndexTotal;
            }
            if ((n & 0x4000000) != 0) {
                string27 = shardInfo.indexingIndexFailed;
            }
            if ((n & 0x8000000) != 0) {
                string28 = shardInfo.mergesCurrent;
            }
            if ((n & 0x10000000) != 0) {
                string29 = shardInfo.mergesCurrentDocs;
            }
            if ((n & 0x20000000) != 0) {
                string30 = shardInfo.mergesCurrentSize;
            }
            if ((n & 0x40000000) != 0) {
                string31 = shardInfo.mergesTotal;
            }
            if ((n & Integer.MIN_VALUE) != 0) {
                string32 = shardInfo.mergesTotalDocs;
            }
            if ((n2 & 1) != 0) {
                string33 = shardInfo.mergesTotalSize;
            }
            if ((n2 & 2) != 0) {
                string34 = shardInfo.mergesTotalTime;
            }
            if ((n2 & 4) != 0) {
                string35 = shardInfo.queryCacheMemory;
            }
            if ((n2 & 8) != 0) {
                string36 = shardInfo.queryCacheEvictions;
            }
            if ((n2 & 0x10) != 0) {
                string37 = shardInfo.recoverySourceType;
            }
            if ((n2 & 0x20) != 0) {
                string38 = shardInfo.refreshTotal;
            }
            if ((n2 & 0x40) != 0) {
                string39 = shardInfo.refreshTime;
            }
            if ((n2 & 0x80) != 0) {
                string40 = shardInfo.searchFetchCurrent;
            }
            if ((n2 & 0x100) != 0) {
                string41 = shardInfo.searchFetchTime;
            }
            if ((n2 & 0x200) != 0) {
                string42 = shardInfo.searchFetchTotal;
            }
            if ((n2 & 0x400) != 0) {
                string43 = shardInfo.searchOpenContexts;
            }
            if ((n2 & 0x800) != 0) {
                string44 = shardInfo.searchQueryCurrent;
            }
            if ((n2 & 0x1000) != 0) {
                string45 = shardInfo.searchQueryTime;
            }
            if ((n2 & 0x2000) != 0) {
                string46 = shardInfo.searchQueryTotal;
            }
            if ((n2 & 0x4000) != 0) {
                string47 = shardInfo.searchScrollCurrent;
            }
            if ((n2 & 0x8000) != 0) {
                string48 = shardInfo.searchScrollTime;
            }
            if ((n2 & 0x10000) != 0) {
                string49 = shardInfo.searchScrollTotal;
            }
            if ((n2 & 0x20000) != 0) {
                string50 = shardInfo.segmentsCount;
            }
            if ((n2 & 0x40000) != 0) {
                string51 = shardInfo.segmentsMemory;
            }
            if ((n2 & 0x80000) != 0) {
                string52 = shardInfo.segmentsIndexWriterMemory;
            }
            if ((n2 & 0x100000) != 0) {
                string53 = shardInfo.segmentsVersionMapMemory;
            }
            if ((n2 & 0x200000) != 0) {
                string54 = shardInfo.fixedBitsetMemory;
            }
            if ((n2 & 0x400000) != 0) {
                string55 = shardInfo.globalCheckpoint;
            }
            if ((n2 & 0x800000) != 0) {
                string56 = shardInfo.localCheckpoint;
            }
            if ((n2 & 0x1000000) != 0) {
                string57 = shardInfo.maxSeqNo;
            }
            if ((n2 & 0x2000000) != 0) {
                string58 = shardInfo.syncId;
            }
            if ((n2 & 0x4000000) != 0) {
                string59 = shardInfo.unassignedAt;
            }
            if ((n2 & 0x8000000) != 0) {
                string60 = shardInfo.unassignedDetails;
            }
            if ((n2 & 0x10000000) != 0) {
                string61 = shardInfo.unassignedFor;
            }
            if ((n2 & 0x20000000) != 0) {
                string62 = shardInfo.unassignedReason;
            }
            return shardInfo.copy(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, string22, string23, string24, string25, string26, string27, string28, string29, string30, string31, string32, string33, string34, string35, string36, string37, string38, string39, string40, string41, string42, string43, string44, string45, string46, string47, string48, string49, string50, string51, string52, string53, string54, string55, string56, string57, string58, string59, string60, string61, string62);
        }

        @NotNull
        public String toString() {
            return "ShardInfo(index=" + this.index + ", shard=" + this.shard + ", primaryOrReplica=" + this.primaryOrReplica + ", state=" + this.state + ", docs=" + this.docs + ", store=" + this.store + ", id=" + this.id + ", node=" + this.node + ", completionSize=" + this.completionSize + ", fieldDataMemory=" + this.fieldDataMemory + ", fieldDataEvictions=" + this.fieldDataEvictions + ", flushTotal=" + this.flushTotal + ", flushTotalTime=" + this.flushTotalTime + ", getCurrent=" + this.getCurrent + ", getTime=" + this.getTime + ", getTotal=" + this.getTotal + ", getExistsTime=" + this.getExistsTime + ", getExistsTotal=" + this.getExistsTotal + ", getMissingTime=" + this.getMissingTime + ", getMissingTotal=" + this.getMissingTotal + ", indexingDeleteCurrent=" + this.indexingDeleteCurrent + ", indexingDeleteTime=" + this.indexingDeleteTime + ", indexingDeleteTotal=" + this.indexingDeleteTotal + ", indexingIndexCurrent=" + this.indexingIndexCurrent + ", indexingIndexTime=" + this.indexingIndexTime + ", indexingIndexTotal=" + this.indexingIndexTotal + ", indexingIndexFailed=" + this.indexingIndexFailed + ", mergesCurrent=" + this.mergesCurrent + ", mergesCurrentDocs=" + this.mergesCurrentDocs + ", mergesCurrentSize=" + this.mergesCurrentSize + ", mergesTotal=" + this.mergesTotal + ", mergesTotalDocs=" + this.mergesTotalDocs + ", mergesTotalSize=" + this.mergesTotalSize + ", mergesTotalTime=" + this.mergesTotalTime + ", queryCacheMemory=" + this.queryCacheMemory + ", queryCacheEvictions=" + this.queryCacheEvictions + ", recoverySourceType=" + this.recoverySourceType + ", refreshTotal=" + this.refreshTotal + ", refreshTime=" + this.refreshTime + ", searchFetchCurrent=" + this.searchFetchCurrent + ", searchFetchTime=" + this.searchFetchTime + ", searchFetchTotal=" + this.searchFetchTotal + ", searchOpenContexts=" + this.searchOpenContexts + ", searchQueryCurrent=" + this.searchQueryCurrent + ", searchQueryTime=" + this.searchQueryTime + ", searchQueryTotal=" + this.searchQueryTotal + ", searchScrollCurrent=" + this.searchScrollCurrent + ", searchScrollTime=" + this.searchScrollTime + ", searchScrollTotal=" + this.searchScrollTotal + ", segmentsCount=" + this.segmentsCount + ", segmentsMemory=" + this.segmentsMemory + ", segmentsIndexWriterMemory=" + this.segmentsIndexWriterMemory + ", segmentsVersionMapMemory=" + this.segmentsVersionMapMemory + ", fixedBitsetMemory=" + this.fixedBitsetMemory + ", globalCheckpoint=" + this.globalCheckpoint + ", localCheckpoint=" + this.localCheckpoint + ", maxSeqNo=" + this.maxSeqNo + ", syncId=" + this.syncId + ", unassignedAt=" + this.unassignedAt + ", unassignedDetails=" + this.unassignedDetails + ", unassignedFor=" + this.unassignedFor + ", unassignedReason=" + this.unassignedReason + ")";
        }

        public int hashCode() {
            int result = this.index == null ? 0 : this.index.hashCode();
            result = result * 31 + (this.shard == null ? 0 : this.shard.hashCode());
            result = result * 31 + (this.primaryOrReplica == null ? 0 : this.primaryOrReplica.hashCode());
            result = result * 31 + (this.state == null ? 0 : this.state.hashCode());
            result = result * 31 + (this.docs == null ? 0 : this.docs.hashCode());
            result = result * 31 + (this.store == null ? 0 : this.store.hashCode());
            result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
            result = result * 31 + (this.node == null ? 0 : this.node.hashCode());
            result = result * 31 + (this.completionSize == null ? 0 : this.completionSize.hashCode());
            result = result * 31 + (this.fieldDataMemory == null ? 0 : this.fieldDataMemory.hashCode());
            result = result * 31 + (this.fieldDataEvictions == null ? 0 : this.fieldDataEvictions.hashCode());
            result = result * 31 + (this.flushTotal == null ? 0 : this.flushTotal.hashCode());
            result = result * 31 + (this.flushTotalTime == null ? 0 : this.flushTotalTime.hashCode());
            result = result * 31 + (this.getCurrent == null ? 0 : this.getCurrent.hashCode());
            result = result * 31 + (this.getTime == null ? 0 : this.getTime.hashCode());
            result = result * 31 + (this.getTotal == null ? 0 : this.getTotal.hashCode());
            result = result * 31 + (this.getExistsTime == null ? 0 : this.getExistsTime.hashCode());
            result = result * 31 + (this.getExistsTotal == null ? 0 : this.getExistsTotal.hashCode());
            result = result * 31 + (this.getMissingTime == null ? 0 : this.getMissingTime.hashCode());
            result = result * 31 + (this.getMissingTotal == null ? 0 : this.getMissingTotal.hashCode());
            result = result * 31 + (this.indexingDeleteCurrent == null ? 0 : this.indexingDeleteCurrent.hashCode());
            result = result * 31 + (this.indexingDeleteTime == null ? 0 : this.indexingDeleteTime.hashCode());
            result = result * 31 + (this.indexingDeleteTotal == null ? 0 : this.indexingDeleteTotal.hashCode());
            result = result * 31 + (this.indexingIndexCurrent == null ? 0 : this.indexingIndexCurrent.hashCode());
            result = result * 31 + (this.indexingIndexTime == null ? 0 : this.indexingIndexTime.hashCode());
            result = result * 31 + (this.indexingIndexTotal == null ? 0 : this.indexingIndexTotal.hashCode());
            result = result * 31 + (this.indexingIndexFailed == null ? 0 : this.indexingIndexFailed.hashCode());
            result = result * 31 + (this.mergesCurrent == null ? 0 : this.mergesCurrent.hashCode());
            result = result * 31 + (this.mergesCurrentDocs == null ? 0 : this.mergesCurrentDocs.hashCode());
            result = result * 31 + (this.mergesCurrentSize == null ? 0 : this.mergesCurrentSize.hashCode());
            result = result * 31 + (this.mergesTotal == null ? 0 : this.mergesTotal.hashCode());
            result = result * 31 + (this.mergesTotalDocs == null ? 0 : this.mergesTotalDocs.hashCode());
            result = result * 31 + (this.mergesTotalSize == null ? 0 : this.mergesTotalSize.hashCode());
            result = result * 31 + (this.mergesTotalTime == null ? 0 : this.mergesTotalTime.hashCode());
            result = result * 31 + (this.queryCacheMemory == null ? 0 : this.queryCacheMemory.hashCode());
            result = result * 31 + (this.queryCacheEvictions == null ? 0 : this.queryCacheEvictions.hashCode());
            result = result * 31 + (this.recoverySourceType == null ? 0 : this.recoverySourceType.hashCode());
            result = result * 31 + (this.refreshTotal == null ? 0 : this.refreshTotal.hashCode());
            result = result * 31 + (this.refreshTime == null ? 0 : this.refreshTime.hashCode());
            result = result * 31 + (this.searchFetchCurrent == null ? 0 : this.searchFetchCurrent.hashCode());
            result = result * 31 + (this.searchFetchTime == null ? 0 : this.searchFetchTime.hashCode());
            result = result * 31 + (this.searchFetchTotal == null ? 0 : this.searchFetchTotal.hashCode());
            result = result * 31 + (this.searchOpenContexts == null ? 0 : this.searchOpenContexts.hashCode());
            result = result * 31 + (this.searchQueryCurrent == null ? 0 : this.searchQueryCurrent.hashCode());
            result = result * 31 + (this.searchQueryTime == null ? 0 : this.searchQueryTime.hashCode());
            result = result * 31 + (this.searchQueryTotal == null ? 0 : this.searchQueryTotal.hashCode());
            result = result * 31 + (this.searchScrollCurrent == null ? 0 : this.searchScrollCurrent.hashCode());
            result = result * 31 + (this.searchScrollTime == null ? 0 : this.searchScrollTime.hashCode());
            result = result * 31 + (this.searchScrollTotal == null ? 0 : this.searchScrollTotal.hashCode());
            result = result * 31 + (this.segmentsCount == null ? 0 : this.segmentsCount.hashCode());
            result = result * 31 + (this.segmentsMemory == null ? 0 : this.segmentsMemory.hashCode());
            result = result * 31 + (this.segmentsIndexWriterMemory == null ? 0 : this.segmentsIndexWriterMemory.hashCode());
            result = result * 31 + (this.segmentsVersionMapMemory == null ? 0 : this.segmentsVersionMapMemory.hashCode());
            result = result * 31 + (this.fixedBitsetMemory == null ? 0 : this.fixedBitsetMemory.hashCode());
            result = result * 31 + (this.globalCheckpoint == null ? 0 : this.globalCheckpoint.hashCode());
            result = result * 31 + (this.localCheckpoint == null ? 0 : this.localCheckpoint.hashCode());
            result = result * 31 + (this.maxSeqNo == null ? 0 : this.maxSeqNo.hashCode());
            result = result * 31 + (this.syncId == null ? 0 : this.syncId.hashCode());
            result = result * 31 + (this.unassignedAt == null ? 0 : this.unassignedAt.hashCode());
            result = result * 31 + (this.unassignedDetails == null ? 0 : this.unassignedDetails.hashCode());
            result = result * 31 + (this.unassignedFor == null ? 0 : this.unassignedFor.hashCode());
            result = result * 31 + (this.unassignedReason == null ? 0 : this.unassignedReason.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShardInfo)) {
                return false;
            }
            ShardInfo shardInfo = (ShardInfo)other;
            if (!Intrinsics.areEqual((Object)this.index, (Object)shardInfo.index)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shard, (Object)shardInfo.shard)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.primaryOrReplica, (Object)shardInfo.primaryOrReplica)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)shardInfo.state)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.docs, (Object)shardInfo.docs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.store, (Object)shardInfo.store)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)shardInfo.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.node, (Object)shardInfo.node)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.completionSize, (Object)shardInfo.completionSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fieldDataMemory, (Object)shardInfo.fieldDataMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fieldDataEvictions, (Object)shardInfo.fieldDataEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.flushTotal, (Object)shardInfo.flushTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.flushTotalTime, (Object)shardInfo.flushTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getCurrent, (Object)shardInfo.getCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getTime, (Object)shardInfo.getTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getTotal, (Object)shardInfo.getTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getExistsTime, (Object)shardInfo.getExistsTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getExistsTotal, (Object)shardInfo.getExistsTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getMissingTime, (Object)shardInfo.getMissingTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getMissingTotal, (Object)shardInfo.getMissingTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingDeleteCurrent, (Object)shardInfo.indexingDeleteCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingDeleteTime, (Object)shardInfo.indexingDeleteTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingDeleteTotal, (Object)shardInfo.indexingDeleteTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexCurrent, (Object)shardInfo.indexingIndexCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexTime, (Object)shardInfo.indexingIndexTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexTotal, (Object)shardInfo.indexingIndexTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexingIndexFailed, (Object)shardInfo.indexingIndexFailed)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesCurrent, (Object)shardInfo.mergesCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesCurrentDocs, (Object)shardInfo.mergesCurrentDocs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesCurrentSize, (Object)shardInfo.mergesCurrentSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotal, (Object)shardInfo.mergesTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotalDocs, (Object)shardInfo.mergesTotalDocs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotalSize, (Object)shardInfo.mergesTotalSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mergesTotalTime, (Object)shardInfo.mergesTotalTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.queryCacheMemory, (Object)shardInfo.queryCacheMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.queryCacheEvictions, (Object)shardInfo.queryCacheEvictions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.recoverySourceType, (Object)shardInfo.recoverySourceType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshTotal, (Object)shardInfo.refreshTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshTime, (Object)shardInfo.refreshTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchFetchCurrent, (Object)shardInfo.searchFetchCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchFetchTime, (Object)shardInfo.searchFetchTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchFetchTotal, (Object)shardInfo.searchFetchTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchOpenContexts, (Object)shardInfo.searchOpenContexts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchQueryCurrent, (Object)shardInfo.searchQueryCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchQueryTime, (Object)shardInfo.searchQueryTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchQueryTotal, (Object)shardInfo.searchQueryTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchScrollCurrent, (Object)shardInfo.searchScrollCurrent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchScrollTime, (Object)shardInfo.searchScrollTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.searchScrollTotal, (Object)shardInfo.searchScrollTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsCount, (Object)shardInfo.segmentsCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsMemory, (Object)shardInfo.segmentsMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsIndexWriterMemory, (Object)shardInfo.segmentsIndexWriterMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.segmentsVersionMapMemory, (Object)shardInfo.segmentsVersionMapMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fixedBitsetMemory, (Object)shardInfo.fixedBitsetMemory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.globalCheckpoint, (Object)shardInfo.globalCheckpoint)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.localCheckpoint, (Object)shardInfo.localCheckpoint)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.maxSeqNo, (Object)shardInfo.maxSeqNo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.syncId, (Object)shardInfo.syncId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.unassignedAt, (Object)shardInfo.unassignedAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.unassignedDetails, (Object)shardInfo.unassignedDetails)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.unassignedFor, (Object)shardInfo.unassignedFor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.unassignedReason, (Object)shardInfo.unassignedReason);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b>\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/opensearch/alerting/util/clusterMetricsMonitorHelpers/CatShardsResponseWrapper$ShardInfo$Companion;", "", "()V", "COMPLETION_SIZE_FIELD", "", "DOCS_FIELD", "FIELD_DATA_EVICTIONS_FIELD", "FIELD_DATA_MEMORY_FIELD", "FIXED_BITSET_MEMORY_FIELD", "FLUSH_TOTAL_FIELD", "FLUSH_TOTAL_TIME_FIELD", "GET_CURRENT_FIELD", "GET_EXISTS_TIME_FIELD", "GET_EXISTS_TOTAL_FIELD", "GET_MISSING_TIME_FIELD", "GET_MISSING_TOTAL_FIELD", "GET_TIME_FIELD", "GET_TOTAL_FIELD", "GLOBAL_CHECKPOINT_FIELD", "ID_FIELD", "INDEXING_DELETE_CURRENT_FIELD", "INDEXING_DELETE_TIME_FIELD", "INDEXING_DELETE_TOTAL_FIELD", "INDEXING_INDEX_CURRENT_FIELD", "INDEXING_INDEX_FAILED_FIELD", "INDEXING_INDEX_TIME_FIELD", "INDEXING_INDEX_TOTAL_FIELD", "INDEX_FIELD", "LOCAL_CHECKPOINT_FIELD", "MAX_SEQ_NO_FIELD", "MERGES_CURRENT_DOCS_FIELD", "MERGES_CURRENT_FIELD", "MERGES_CURRENT_SIZE_FIELD", "MERGES_TOTAL_DOCS_FIELD", "MERGES_TOTAL_FIELD", "MERGES_TOTAL_SIZE_FIELD", "MERGES_TOTAL_TIME_FIELD", "NODE_FIELD", "PRIMARY_OR_REPLICA_FIELD", "QUERY_CACHE_EVICTIONS_FIELD", "QUERY_CACHE_MEMORY_FIELD", "RECOVERY_SOURCE_TYPE_FIELD", "REFRESH_TIME_FIELD", "REFRESH_TOTAL_FIELD", "SEARCH_FETCH_CURRENT_FIELD", "SEARCH_FETCH_TIME_FIELD", "SEARCH_FETCH_TOTAL_FIELD", "SEARCH_OPEN_CONTEXTS_FIELD", "SEARCH_QUERY_CURRENT_FIELD", "SEARCH_QUERY_TIME_FIELD", "SEARCH_QUERY_TOTAL_FIELD", "SEARCH_SCROLL_CURRENT_FIELD", "SEARCH_SCROLL_TIME_FIELD", "SEARCH_SCROLL_TOTAL_FIELD", "SEGMENTS_COUNT_FIELD", "SEGMENTS_INDEX_WRITER_MEMORY_FIELD", "SEGMENTS_MEMORY_FIELD", "SEGMENTS_VERSION_MAP_MEMORY_FIELD", "SHARD_FIELD", "STATE_FIELD", "STORE_FIELD", "SYNC_ID_FIELD", "UNASSIGNED_AT_FIELD", "UNASSIGNED_DETAILS_FIELD", "UNASSIGNED_FOR_FIELD", "UNASSIGNED_REASON_FIELD", "opensearch-alerting"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

