/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.action.mcpserver.McpAsyncServerHolder;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.mcpserver.requests.message.MLMcpMessageRequest;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.StreamingRestChannel;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import reactor.core.publisher.Mono;

public class TransportMcpMessageDispatchedAction
extends HandledTransportAction<ActionRequest, AcknowledgedResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpMessageDispatchedAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportMcpMessageDispatchedAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/mcp/message/dispatch", transportService, actionFilters, MLMcpMessageRequest::new);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<AcknowledgedResponse> listener) {
        MLMcpMessageRequest mlMcpMessageRequest = MLMcpMessageRequest.fromActionRequest((TransportRequest)request);
        StreamingRestChannel channel = McpAsyncServerHolder.CHANNELS.get(mlMcpMessageRequest.getSessionId());
        Mono.from(McpAsyncServerHolder.getMcpServerTransportProviderInstance().handleMessage(mlMcpMessageRequest.getSessionId(), mlMcpMessageRequest.getRequestBody())).doOnSuccess(y -> listener.onResponse((Object)new AcknowledgedResponse(true))).onErrorResume(e -> Mono.fromRunnable(() -> this.sendErrorResponse(listener, channel, (Throwable)e))).subscribe();
    }

    @VisibleForTesting
    void sendErrorResponse(ActionListener<AcknowledgedResponse> listener, StreamingRestChannel channel, Throwable e) {
        try {
            channel.sendResponse((RestResponse)new BytesRestResponse((RestChannel)channel, new Exception(e)));
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }
        catch (Exception ex) {
            log.error("Failed to send exception response to client during message handling due to IOException", (Throwable)ex);
            listener.onFailure(new Exception(ex));
        }
    }
}

