/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class ExporterReaderUtils {
    private static final String HASH_FORMAT_PATTERN = "%05d";
    public static final String UTC_DATE_FORMAT_PATTERN = "yyyy-MM-dd";

    private ExporterReaderUtils() {
    }

    public static String generateLocalIndexDateHash(LocalDate date) {
        String dateString = DateTimeFormatter.ofPattern(UTC_DATE_FORMAT_PATTERN, Locale.ROOT).format(date);
        return String.format(Locale.ROOT, HASH_FORMAT_PATTERN, (dateString.hashCode() % 100000 + 100000) % 100000);
    }
}

