/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.iocscan.dto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class PerIocTypeScanInputDto
implements Writeable,
ToXContentObject {
    private static final String IOC_TYPE = "ioc_type";
    private static final String INDEX_TO_FIELDS_MAP = "index_to_fields_map";
    private final String iocType;
    private final Map<String, List<String>> indexToFieldsMap;

    public PerIocTypeScanInputDto(String iocType, Map<String, List<String>> indexToFieldsMap) {
        this.iocType = iocType;
        this.indexToFieldsMap = indexToFieldsMap == null ? Collections.emptyMap() : indexToFieldsMap;
    }

    public PerIocTypeScanInputDto(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readMapOfLists(StreamInput::readString, StreamInput::readString));
    }

    public String getIocType() {
        return this.iocType;
    }

    public Map<String, List<String>> getIndexToFieldsMap() {
        return this.indexToFieldsMap;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.iocType);
        out.writeMapOfLists(this.indexToFieldsMap, StreamOutput::writeString, StreamOutput::writeString);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(IOC_TYPE, this.iocType).field(INDEX_TO_FIELDS_MAP, this.indexToFieldsMap).endObject();
    }

    public static PerIocTypeScanInputDto parse(XContentParser xcp) throws IOException {
        String iocType = "";
        Map<String, List<String>> indexToFieldsMap = new HashMap<String, List<String>>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "ioc_type": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block8;
                    iocType = xcp.text();
                    continue block8;
                }
                case "index_to_fields_map": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        indexToFieldsMap = null;
                        continue block8;
                    }
                    indexToFieldsMap = xcp.map(HashMap::new, p -> {
                        ArrayList<String> fields = new ArrayList<String>();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                            fields.add(xcp.text());
                        }
                        return fields;
                    });
                    continue block8;
                }
            }
            xcp.skipChildren();
        }
        return new PerIocTypeScanInputDto(iocType, indexToFieldsMap);
    }
}

