/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.caching;

import com.amazon.randomcutforest.parkservices.RCFCaster;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Optional;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.forecast.caching.ForecastCacheBuffer;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.ml.ForecastCheckpointDao;
import org.opensearch.forecast.ratelimit.ForecastCheckpointMaintainWorker;
import org.opensearch.forecast.ratelimit.ForecastCheckpointWriteWorker;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.caching.PriorityCache;
import org.opensearch.timeseries.caching.PriorityTracker;
import org.opensearch.timeseries.ml.ModelManager;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Config;

public class ForecastPriorityCache
extends PriorityCache<RCFCaster, ForecastIndex, ForecastIndexManagement, ForecastCheckpointDao, ForecastCheckpointWriteWorker, ForecastCheckpointMaintainWorker, ForecastCacheBuffer> {
    private ForecastCheckpointWriteWorker checkpointWriteQueue;
    private ForecastCheckpointMaintainWorker checkpointMaintainQueue;

    public ForecastPriorityCache(ForecastCheckpointDao checkpointDao, int hcDedicatedCacheSize, Setting<TimeValue> checkpointTtl, int maxInactiveStates, MemoryTracker memoryTracker, int numberOfTrees, Clock clock, ClusterService clusterService, Duration modelTtl, ThreadPool threadPool, String threadPoolName, int maintenanceFreqConstant, Settings settings, Setting<TimeValue> checkpointSavingFreq, ForecastCheckpointWriteWorker checkpointWriteQueue, ForecastCheckpointMaintainWorker checkpointMaintainQueue) {
        super(checkpointDao, hcDedicatedCacheSize, checkpointTtl, maxInactiveStates, memoryTracker, numberOfTrees, clock, clusterService, modelTtl, threadPool, threadPoolName, maintenanceFreqConstant, settings, checkpointSavingFreq, MemoryTracker.Origin.REAL_TIME_FORECASTER, ForecastSettings.FORECAST_DEDICATED_CACHE_SIZE, ForecastSettings.FORECAST_MODEL_MAX_SIZE_PERCENTAGE);
        this.checkpointWriteQueue = checkpointWriteQueue;
        this.checkpointMaintainQueue = checkpointMaintainQueue;
    }

    @Override
    protected ForecastCacheBuffer createEmptyCacheBuffer(Config config, long requiredMemory, PriorityTracker tracker) {
        return new ForecastCacheBuffer(config.isHighCardinality() ? this.hcDedicatedCacheSize : 1, this.clock, this.memoryTracker, this.checkpointIntervalHrs, this.modelTtl, requiredMemory, this.checkpointWriteQueue, this.checkpointMaintainQueue, config.getId(), tracker);
    }

    @Override
    protected ModelState<RCFCaster> createEmptyModelState(String modelId, String forecasterId) {
        return new ModelState<Object>(null, modelId, forecasterId, ModelManager.ModelType.RCFCASTER.getName(), this.clock, 0.0f, Optional.empty(), new ArrayDeque<Sample>());
    }

    @Override
    protected boolean isDoorKeeperInCacheEnabled() {
        return false;
    }
}

