/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.mapper.RangeFieldMapper;
import org.opensearch.index.mapper.RangeType;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class RangeHistogramAggregator
extends AbstractHistogramAggregator {
    private final ValuesSource.Range valuesSource;

    public RangeHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinality, metadata);
        ValuesSource.Range range = this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Range)valuesSourceConfig.getValuesSource() : null;
        if (!this.valuesSource.rangeType().isNumeric()) {
            throw new IllegalArgumentException("Expected numeric range type but found non-numeric range [" + this.valuesSource.rangeType().name + "]");
        }
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        final RangeType rangeType = this.valuesSource.rangeType();
        return new LeafBucketCollectorBase(this, sub, values){
            final /* synthetic */ RangeHistogramAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub2, values2);
            }

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    assert (valuesCount == 1) : "Value count for ranges should always be 1";
                    double previousKey = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef encodedRanges = values.nextValue();
                        List<RangeFieldMapper.Range> ranges = rangeType.decodeRanges(encodedRanges);
                        double previousFrom = Double.NEGATIVE_INFINITY;
                        for (RangeFieldMapper.Range range : ranges) {
                            Double from = rangeType.doubleValue(range.getFrom());
                            assert (from >= previousFrom) : "Start of range not >= previous start";
                            Double to = rangeType.doubleValue(range.getTo());
                            double effectiveFrom = this.this$0.hardBounds != null && this.this$0.hardBounds.getMin() != null ? Double.max(from, this.this$0.hardBounds.getMin()) : from;
                            double effectiveTo = this.this$0.hardBounds != null && this.this$0.hardBounds.getMax() != null ? Double.min(to, this.this$0.hardBounds.getMax()) : to;
                            double startKey = Math.floor((effectiveFrom - this.this$0.offset) / this.this$0.interval);
                            double endKey = Math.floor((effectiveTo - this.this$0.offset) / this.this$0.interval);
                            for (double key = Math.max(startKey, previousKey); key <= endKey; key += 1.0) {
                                if (key == previousKey) continue;
                                long bucketOrd = this.this$0.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                                if (bucketOrd < 0L) {
                                    bucketOrd = -1L - bucketOrd;
                                    this.this$0.collectExistingBucket(sub, doc, bucketOrd);
                                    continue;
                                }
                                this.this$0.collectBucket(sub, doc, bucketOrd);
                            }
                            if (!(endKey > previousKey)) continue;
                            previousKey = endKey;
                        }
                    }
                }
            }
        };
    }
}

