/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.Nullable;
import org.opensearch.common.metrics.OperationMetrics;
import org.opensearch.ingest.CompoundProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.IngestDocumentWrapper;
import org.opensearch.ingest.Processor;
import org.opensearch.script.ScriptService;
import reactor.util.annotation.NonNull;

public final class Pipeline {
    public static final String DESCRIPTION_KEY = "description";
    public static final String PROCESSORS_KEY = "processors";
    public static final String VERSION_KEY = "version";
    public static final String ON_FAILURE_KEY = "on_failure";
    private final String id;
    @Nullable
    private final String description;
    @Nullable
    private final Integer version;
    private final CompoundProcessor compoundProcessor;
    private final OperationMetrics metrics;
    private final LongSupplier relativeTimeProvider;

    public Pipeline(String id, @Nullable String description, @Nullable Integer version, CompoundProcessor compoundProcessor) {
        this(id, description, version, compoundProcessor, System::nanoTime);
    }

    Pipeline(String id, @Nullable String description, @Nullable Integer version, CompoundProcessor compoundProcessor, LongSupplier relativeTimeProvider) {
        this.id = id;
        this.description = description;
        this.compoundProcessor = compoundProcessor;
        this.version = version;
        this.metrics = new OperationMetrics();
        this.relativeTimeProvider = relativeTimeProvider;
    }

    public static Pipeline create(String id, Map<String, Object> config, Map<String, Processor.Factory> processorFactories, ScriptService scriptService) throws Exception {
        String description = ConfigurationUtils.readOptionalStringProperty(null, null, config, DESCRIPTION_KEY);
        Integer version = ConfigurationUtils.readIntProperty(null, null, config, VERSION_KEY, null);
        List<Map<String, Object>> processorConfigs = ConfigurationUtils.readList(null, null, config, PROCESSORS_KEY);
        List<Processor> processors = ConfigurationUtils.readProcessorConfigs(processorConfigs, scriptService, processorFactories);
        List<Map<String, Object>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, ON_FAILURE_KEY);
        List<Processor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, scriptService, processorFactories);
        if (!config.isEmpty()) {
            throw new OpenSearchParseException("pipeline [" + id + "] doesn't support one or more provided configuration parameters " + Arrays.toString(config.keySet().toArray()), new Object[0]);
        }
        if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
            throw new OpenSearchParseException("pipeline [" + id + "] cannot have an empty on_failure option defined", new Object[0]);
        }
        CompoundProcessor compoundProcessor = new CompoundProcessor(false, Collections.unmodifiableList(processors), Collections.unmodifiableList(onFailureProcessors));
        return new Pipeline(id, description, version, compoundProcessor);
    }

    public static Pipeline createSystemIngestPipeline(@NonNull String index, @NonNull Map<String, Processor.Factory> systemIngestProcessorFactories, @NonNull Map<String, Object> config) {
        String id = index + "_system_generated_ingest_pipeline";
        String description = "This is an in-memory systematically generated ingest pipeline.";
        ArrayList<Processor> processors = new ArrayList<Processor>();
        Map<String, Object> processorConfig = Collections.unmodifiableMap(config);
        if (config.isEmpty()) {
            return new Pipeline(id, "This is an in-memory systematically generated ingest pipeline.", null, new CompoundProcessor(new Processor[0]));
        }
        systemIngestProcessorFactories.values().forEach(factory -> {
            try {
                Processor processor = factory.create(systemIngestProcessorFactories, null, null, processorConfig);
                if (processor != null) {
                    if (!processor.isSystemGenerated()) {
                        throw new RuntimeException("Cannot create the system generated ingest pipeline for the index [" + index + "] because the processor [" + processor.getClass().getName() + "] is not a system generated ingest processor.");
                    }
                    processors.add(processor);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to systematically create the system ingest processor from the factory " + factory.getClass().getName() + " for the index " + index + ". " + e.getMessage(), e);
            }
        });
        return new Pipeline(id, "This is an in-memory systematically generated ingest pipeline.", null, new CompoundProcessor(false, processors, Collections.emptyList()));
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        long startTimeInNanos = this.relativeTimeProvider.getAsLong();
        this.metrics.before();
        this.compoundProcessor.execute(ingestDocument, (result, e) -> {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTimeInNanos);
            this.metrics.after(ingestTimeInMillis);
            if (e != null) {
                this.metrics.failed();
            }
            handler.accept((IngestDocument)result, (Exception)e);
        });
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public CompoundProcessor getCompoundProcessor() {
        return this.compoundProcessor;
    }

    public List<Processor> getProcessors() {
        return this.compoundProcessor.getProcessors();
    }

    public List<Processor> getOnFailureProcessors() {
        return this.compoundProcessor.getOnFailureProcessors();
    }

    public List<Processor> flattenAllProcessors() {
        return this.compoundProcessor.flattenProcessors();
    }

    public OperationMetrics getMetrics() {
        return this.metrics;
    }

    public void batchExecute(List<IngestDocumentWrapper> ingestDocumentWrappers, Consumer<List<IngestDocumentWrapper>> handler) {
        long startTimeInNanos = this.relativeTimeProvider.getAsLong();
        int size = ingestDocumentWrappers.size();
        this.metrics.beforeN(size);
        this.compoundProcessor.batchExecute(ingestDocumentWrappers, results -> {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTimeInNanos);
            this.metrics.afterN(results.size(), ingestTimeInMillis);
            int failedCount = (int)results.stream().filter(t -> t.getException() != null).count();
            this.metrics.failedN(failedCount);
            handler.accept((List<IngestDocumentWrapper>)results);
        });
    }
}

