/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.mapping.get;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.opensearch.action.admin.indices.mapping.get.TransportGetFieldMappingsIndexAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportGetFieldMappingsAction
extends HandledTransportAction<GetFieldMappingsRequest, GetFieldMappingsResponse> {
    private final ClusterService clusterService;
    private final TransportGetFieldMappingsIndexAction shardAction;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetFieldMappingsAction(TransportService transportService, ClusterService clusterService, TransportGetFieldMappingsIndexAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/mappings/fields/get", transportService, actionFilters, GetFieldMappingsRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected void doExecute(Task task, GetFieldMappingsRequest request, final ActionListener<GetFieldMappingsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(concreteIndices.length);
        final AtomicReferenceArray indexResponses = new AtomicReferenceArray(concreteIndices.length);
        if (concreteIndices.length == 0) {
            listener.onResponse((Object)new GetFieldMappingsResponse(Collections.emptyMap()));
        } else {
            for (String index : concreteIndices) {
                GetFieldMappingsIndexRequest shardRequest = new GetFieldMappingsIndexRequest(request, index);
                this.shardAction.execute(shardRequest, new ActionListener<GetFieldMappingsResponse>(){
                    final /* synthetic */ TransportGetFieldMappingsAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onResponse(GetFieldMappingsResponse result) {
                        indexResponses.set(indexCounter.getAndIncrement(), result);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse((Object)this.this$0.merge(indexResponses));
                        }
                    }

                    public void onFailure(Exception e) {
                        int index = indexCounter.getAndIncrement();
                        indexResponses.set(index, e);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse((Object)this.this$0.merge(indexResponses));
                        }
                    }
                });
            }
        }
    }

    private GetFieldMappingsResponse merge(AtomicReferenceArray<Object> indexResponses) {
        HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>> mergedResponses = new HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>();
        for (int i = 0; i < indexResponses.length(); ++i) {
            Object element = indexResponses.get(i);
            if (!(element instanceof GetFieldMappingsResponse)) continue;
            GetFieldMappingsResponse response = (GetFieldMappingsResponse)((Object)element);
            mergedResponses.putAll(response.mappings());
        }
        return new GetFieldMappingsResponse(Collections.unmodifiableMap(mergedResponses));
    }
}

