/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.CommittedKey;
import com.amazonaws.encryptionsdk.internal.HmacKeyDerivationFunction;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.cryptography.materialproviders.MaterialProviders;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.model.HKDF;
import software.amazon.cryptography.materialproviders.model.MaterialProvidersConfig;

public enum CryptoAlgorithm {
    ALG_AES_128_GCM_IV12_TAG16_NO_KDF(20),
    ALG_AES_192_GCM_IV12_TAG16_NO_KDF(70),
    ALG_AES_256_GCM_IV12_TAG16_NO_KDF(120),
    ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256(276),
    ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA256(326),
    ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA256(376),
    ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256(532),
    ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384(838),
    ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384(888),
    ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY(1144),
    ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY_ECDSA_P384(1400);

    private final AlgorithmSuiteInfo info;
    final MaterialProvidersConfig config = MaterialProvidersConfig.builder().build();
    final MaterialProviders materialProviders = MaterialProviders.builder().MaterialProvidersConfig(this.config).build();
    private final short value;
    private static final String KEY_ALGORITHM = "AES";
    private static final String HKDF_SHA256 = "HkdfSHA256";
    private static final String HKDF_SHA384 = "HkdfSHA384";
    private static final String HKDF_SHA512 = "HkdfSHA512";
    private static final String ECDSA_P256 = "SHA256withECDSA";
    private static final String ECDSA_P384 = "SHA384withECDSA";
    private static final int BLOCK_SIZE_BYTES = 16;
    private static final int VERSION_1_MESSAGE_ID_LEN = 16;
    private static final int VERSION_2_MESSAGE_ID_LEN = 32;
    private static final Map<Integer, CryptoAlgorithm> ID_MAPPING;

    private CryptoAlgorithm(int value) {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Invalid value " + value);
        }
        this.value = (short)value;
        this.info = this.materialProviders.GetAlgorithmSuiteInfo(ByteBuffer.allocate(2).putShort((short)value));
    }

    private static int fieldsToLookupKey(byte messageFormatVersion, short algorithmId) {
        return messageFormatVersion << 16 | algorithmId;
    }

    public static CryptoAlgorithm deserialize(byte messageFormatVersion, short value) {
        return ID_MAPPING.get(CryptoAlgorithm.fieldsToLookupKey(messageFormatVersion, value));
    }

    public AlgorithmSuiteId getAlgorithmSuiteId() {
        return this.info.id();
    }

    public int getMessageIdLength() {
        switch (this.info.messageVersion()) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
        }
        throw new UnsupportedOperationException("Support for version " + this.info.messageVersion() + " not yet built.");
    }

    public byte[] getHeaderNonce() {
        switch (this.info.messageVersion()) {
            case 1: {
                return null;
            }
            case 2: {
                return new byte[this.info.encrypt().AES_GCM().ivLength()];
            }
        }
        throw new UnsupportedOperationException("Support for version " + this.info.messageVersion() + " not yet built.");
    }

    public byte getMessageFormatVersion() {
        return (byte)(this.info.messageVersion() & 0xFF);
    }

    public int getBlockSize() {
        return 16;
    }

    public byte getNonceLen() {
        return (byte)this.info.encrypt().AES_GCM().ivLength();
    }

    public int getTagLen() {
        return this.info.encrypt().AES_GCM().tagLength();
    }

    public long getMaxContentLen() {
        return 0xFFFFFFFE0L;
    }

    public String getKeyAlgo() {
        return KEY_ALGORITHM;
    }

    public int getKeyLength() {
        return this.info.encrypt().AES_GCM().keyLength();
    }

    public short getValue() {
        return this.value;
    }

    public String getDataKeyAlgo() {
        String hmac;
        if (this.info.kdf().HKDF() == null) {
            return KEY_ALGORITHM;
        }
        switch (hmac = this.info.kdf().HKDF().hmac().name()) {
            case "SHA_256": {
                return HKDF_SHA256;
            }
            case "SHA_384": {
                return HKDF_SHA384;
            }
            case "SHA_512": {
                return HKDF_SHA512;
            }
        }
        throw new UnsupportedOperationException("Support for Data Key Algorithm:" + hmac + " not yet built");
    }

    public int getDataKeyLength() {
        return this.getKeyLength();
    }

    public String getTrailingSignatureAlgo() {
        String ecdsa;
        if (this.info.signature().ECDSA() == null) {
            return null;
        }
        switch (ecdsa = this.info.signature().ECDSA().curve().name()) {
            case "ECDSA_P256": {
                return ECDSA_P256;
            }
            case "ECDSA_P384": {
                return ECDSA_P384;
            }
        }
        throw new UnsupportedOperationException("Support for Data Key Algorithm:" + ecdsa + " not yet built");
    }

    public boolean isSafeToCache() {
        return this.info.kdf().HKDF() != null;
    }

    public short getTrailingSignatureLength() {
        String ecdsa;
        if (this.info.signature().ECDSA() == null) {
            return 0;
        }
        switch (ecdsa = this.info.signature().ECDSA().curve().name()) {
            case "ECDSA_P256": {
                return 71;
            }
            case "ECDSA_P384": {
                return 103;
            }
        }
        throw new UnsupportedOperationException("Support for Data Key Algorithm:" + ecdsa + " not yet built");
    }

    public String getKeyCommitmentAlgo_() {
        HKDF keyCommitment = this.info.commitment().HKDF();
        if (keyCommitment == null) {
            return null;
        }
        switch (keyCommitment.hmac().name()) {
            case "SHA_512": {
                return HKDF_SHA512;
            }
        }
        throw new UnsupportedOperationException("Support for Commitment Key Algorithm:" + this.info.commitment().HKDF() + " not yet built");
    }

    public boolean isCommitting() {
        return this.info.commitment().HKDF() != null;
    }

    public int getCommitmentLength() {
        return this.info.commitment().HKDF() == null ? 0 : this.info.commitment().HKDF().inputKeyLength();
    }

    public int getCommitmentNonceLength() {
        return this.info.commitment().HKDF() == null ? 0 : this.info.commitment().HKDF().saltLength();
    }

    public int getSuiteDataLength() {
        return this.info.commitment().HKDF() == null ? 0 : this.info.commitment().HKDF().outputKeyLength();
    }

    public SecretKey getEncryptionKeyFromDataKey(SecretKey dataKey, CiphertextHeaders headers) throws InvalidKeyException {
        if (!dataKey.getAlgorithm().equalsIgnoreCase(this.getDataKeyAlgo())) {
            throw new InvalidKeyException("DataKey of incorrect algorithm. Expected " + this.getDataKeyAlgo() + " but was " + dataKey.getAlgorithm());
        }
        switch (this.info.messageVersion()) {
            case 1: {
                return this.getNonCommittedEncryptionKey(dataKey, headers);
            }
            case 2: {
                return this.getCommittedEncryptionKey(dataKey, headers);
            }
        }
        throw new UnsupportedOperationException("Support for message format version " + this.info.messageVersion() + " not yet built.");
    }

    private SecretKey getCommittedEncryptionKey(SecretKey dataKey, CiphertextHeaders headers) throws InvalidKeyException {
        CommittedKey committedKey = CommittedKey.generate(this, dataKey, headers.getMessageId());
        if (!MessageDigest.isEqual(committedKey.getCommitment(), headers.getSuiteData())) {
            throw new BadCiphertextException("Key commitment validation failed. Key identity does not match the identity asserted in the message. Halting processing of this message.");
        }
        return committedKey.getKey();
    }

    private SecretKey getNonCommittedEncryptionKey(SecretKey dataKey, CiphertextHeaders headers) throws InvalidKeyException {
        HmacKeyDerivationFunction hkdf;
        String macAlgorithm;
        switch (this) {
            case ALG_AES_128_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_192_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: {
                return dataKey;
            }
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA256: 
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: {
                macAlgorithm = "HmacSHA256";
                break;
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: {
                macAlgorithm = "HmacSHA384";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Support for " + (Object)((Object)this) + " not yet built.");
            }
        }
        if (!dataKey.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Currently only RAW format keys are supported for HKDF algorithms. Actual format was " + dataKey.getFormat());
        }
        byte[] messageId = headers.getMessageId();
        ByteBuffer info = ByteBuffer.allocate(messageId.length + 2);
        info.order(ByteOrder.BIG_ENDIAN);
        info.putShort(this.getValue());
        info.put(messageId);
        byte[] rawDataKey = dataKey.getEncoded();
        if (rawDataKey.length != this.getDataKeyLength()) {
            throw new InvalidKeyException("DataKey of incorrect length. Expected " + this.getDataKeyLength() + " but was " + rawDataKey.length);
        }
        try {
            hkdf = HmacKeyDerivationFunction.getInstance(macAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        hkdf.init(rawDataKey);
        return new SecretKeySpec(hkdf.deriveKey(info.array(), this.getKeyLength()), this.getKeyAlgo());
    }

    static {
        ID_MAPPING = new HashMap<Integer, CryptoAlgorithm>();
        for (CryptoAlgorithm s : EnumSet.allOf(CryptoAlgorithm.class)) {
            ID_MAPPING.put(CryptoAlgorithm.fieldsToLookupKey(s.getMessageFormatVersion(), s.getValue()), s);
        }
    }
}

