/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import org.opensearch.notifications.core.repackage.com.amazonaws.DefaultRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.Request;
import org.opensearch.notifications.core.repackage.com.amazonaws.SdkClientException;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpMethodName;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.SdkInternalList;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.DescribeConfigurationSetRequest;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Marshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.StringUtils;

public class DescribeConfigurationSetRequestMarshaller
implements Marshaller<Request<DescribeConfigurationSetRequest>, DescribeConfigurationSetRequest> {
    @Override
    public Request<DescribeConfigurationSetRequest> marshall(DescribeConfigurationSetRequest describeConfigurationSetRequest) {
        if (describeConfigurationSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeConfigurationSetRequest> request = new DefaultRequest<DescribeConfigurationSetRequest>(describeConfigurationSetRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "DescribeConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationSetRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(describeConfigurationSetRequest.getConfigurationSetName()));
        }
        if (!describeConfigurationSetRequest.getConfigurationSetAttributeNames().isEmpty() || !((SdkInternalList)describeConfigurationSetRequest.getConfigurationSetAttributeNames()).isAutoConstruct()) {
            SdkInternalList configurationSetAttributeNamesList = (SdkInternalList)describeConfigurationSetRequest.getConfigurationSetAttributeNames();
            int configurationSetAttributeNamesListIndex = 1;
            for (String configurationSetAttributeNamesListValue : configurationSetAttributeNamesList) {
                if (configurationSetAttributeNamesListValue != null) {
                    request.addParameter("ConfigurationSetAttributeNames.member." + configurationSetAttributeNamesListIndex, StringUtils.fromString(configurationSetAttributeNamesListValue));
                }
                ++configurationSetAttributeNamesListIndex;
            }
        }
        return request;
    }
}

