/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.jersey.JerseyHttpProvider;
import com.oracle.bmc.http.signing.RequestSigningFilter;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.assets.k8s.ClusterItem;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

public class KubernetesUtils {
    public static void runWithClient(ClusterItem cluster, Consumer<KubernetesClient> consumer) {
        if (cluster.getConfig() == null) {
            cluster.update();
        }
        if (cluster.getConfig() == null) {
            throw new RuntimeException("Invalid cluster configuration");
        }
        Config config = KubernetesUtils.prepareConfig(cluster.getConfig(), cluster);
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();){
            consumer.accept(client);
        }
    }

    private static Config prepareConfig(String content, ClusterItem cluster) {
        String token = KubernetesUtils.getBearerToken(cluster);
        LoadSettings settings = LoadSettings.builder().build();
        Load load = new Load(settings);
        Map data = (Map)load.loadFromString(content);
        List users = (List)data.get("users");
        if (users == null) {
            throw new RuntimeException("Invalid cluster configuration");
        }
        Map exec = null;
        for (Map userEntry : users) {
            Map user = (Map)userEntry.get("user");
            if (user == null || !user.containsKey("exec")) continue;
            exec = (Map)user.remove("exec");
        }
        String clusterId = null;
        if (exec != null && "oci".equals(exec.get("command"))) {
            List commandArgs = (List)exec.get("args");
            boolean clusterIdNext = false;
            for (Object arg : commandArgs) {
                if ("--cluster-id".equals(arg)) {
                    clusterIdNext = true;
                    continue;
                }
                if (!clusterIdNext) continue;
                clusterId = (String)arg;
                break;
            }
        }
        if (!cluster.getKey().getValue().equals(clusterId)) {
            throw new RuntimeException("Failed to read cluster config");
        }
        Dump dump = new Dump(DumpSettings.builder().build());
        String noExec = dump.dumpToString((Object)data);
        Config config = Config.fromKubeconfig((String)noExec);
        config.setOauthToken(token);
        return config;
    }

    private static String getBearerToken(ClusterItem cluster) {
        try {
            OCIProfile profile = OCIManager.getDefault().getActiveProfile(cluster);
            Region region = Region.fromRegionCodeOrId((String)cluster.getRegionCode());
            URI uri = new URI(String.format("https://containerengine.%s.oraclecloud.com/cluster_request/%s", region.getRegionId(), cluster.getKey().getValue()));
            RequestSigningFilter requestSigningFilter = RequestSigningFilter.fromAuthProvider((BasicAuthenticationDetailsProvider)profile.getAuthenticationProvider());
            HttpClient client = JerseyHttpProvider.getInstance().newBuilder().registerRequestInterceptor(1000, (RequestInterceptor)requestSigningFilter).baseUri(uri).build();
            HttpRequest request = client.createRequest(Method.GET);
            request.execute().toCompletableFuture();
            List tokenUrlList = (List)request.headers().get("authorization");
            String authorization = URLEncoder.encode((String)tokenUrlList.get(0), "UTF-8");
            List dateList = (List)request.headers().get("date");
            String date = URLEncoder.encode((String)dateList.get(0), "UTF-8");
            String baseString = String.format("%s?authorization=%s&date=%s", uri.toASCIIString(), authorization, date);
            byte[] urlBytes = baseString.getBytes(StandardCharsets.UTF_8);
            return Base64.getUrlEncoder().encodeToString(urlBytes);
        }
        catch (UnsupportedEncodingException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static KubernetesResource findResource(KubernetesClient client, KubernetesResourceList<? extends HasMetadata> existingResources, String resourceName) {
        if (resourceName == null) {
            return null;
        }
        for (HasMetadata resource : existingResources.getItems()) {
            if (!resourceName.equals(resource.getMetadata().getName())) continue;
            return resource;
        }
        return null;
    }
}

