/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.sass;

import java.awt.EventQueue;
import java.io.File;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.sass.Bundle;
import org.netbeans.modules.css.prep.sass.LibSassExecutable;
import org.netbeans.modules.css.prep.sass.SassExecutable;
import org.netbeans.modules.css.prep.util.InvalidExternalExecutableException;
import org.netbeans.modules.css.prep.util.UiUtils;
import org.netbeans.modules.web.common.api.Version;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.netbeans.modules.web.common.ui.api.ExternalExecutableValidator;
import org.openide.filesystems.FileUtil;
import org.openide.windows.IOProvider;

public abstract class SassCli {
    private static final Logger LOGGER = Logger.getLogger(SassCli.class.getName());
    private static final boolean USE_LIBSASS = Boolean.parseBoolean(System.getProperty("nb.sass.libsass", "true"));
    @NullAllowed
    protected static volatile Version version;
    @NonNull
    private final String sassPath;

    protected SassCli(String sassPath) {
        assert (sassPath != null);
        this.sassPath = sassPath;
    }

    public static SassCli getDefault() throws InvalidExternalExecutableException {
        String path = CssPrepOptions.getInstance().getSassPath();
        String error = SassCli.validate(path);
        if (error != null) {
            throw new InvalidExternalExecutableException(error);
        }
        if (USE_LIBSASS) {
            return new LibSassExecutable(path);
        }
        return new SassExecutable(path);
    }

    public static String validate(String path) {
        return ExternalExecutableValidator.validateCommand((String)path, (String)Bundle.SassCli_executable_label());
    }

    public static void resetVersion() {
        version = null;
    }

    public static String[] getExecutableNames() {
        if (USE_LIBSASS) {
            return LibSassExecutable.EXECUTABLE_NAMES;
        }
        return SassExecutable.EXECUTABLE_NAMES;
    }

    protected abstract List<String> getParameters(File var1, File var2, List<String> var3);

    public void compile(File workDir, File source, final File target, List<String> compilerOptions) throws ExecutionException {
        assert (!EventQueue.isDispatchThread());
        assert (workDir.isDirectory()) : "Not directory given: " + workDir;
        assert (source.isFile()) : "Not file given: " + source;
        final File targetDir = target.getParentFile();
        if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
            LOGGER.log(Level.WARNING, "Cannot create directory {0}", targetDir);
            return;
        }
        try {
            this.getExecutable(Bundle.SassCli_compile(), workDir).additionalParameters(this.getParameters(source, target, compilerOptions)).runAndWait(this.getDescriptor(new Runnable(){

                @Override
                public void run() {
                    FileUtil.refreshFor((File[])new File[]{targetDir});
                    UiUtils.refreshCssInBrowser(target);
                }
            }), "Compiling sass files...");
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            throw ex;
        }
    }

    protected ExternalExecutable getExecutable(String title, File workDir) {
        return new ExternalExecutable(this.sassPath).workDir(workDir).displayName(title).optionsPath("Html5/CssPreprocessors");
    }

    private ExecutionDescriptor getDescriptor(Runnable postTask) {
        return new ExecutionDescriptor().inputOutput(IOProvider.getDefault().getIO(Bundle.SassCli_compile(), false)).inputVisible(false).frontWindow(false).frontWindowOnError(CssPrepOptions.getInstance().getSassOutputOnError()).noReset(true).showProgress(true).postExecution(postTask);
    }
}

