/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class IncludeExcludeVisualizerPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String HELP_ID = "java.project.includeexclude";
    private final IncludeExcludeVisualizer handle;
    private final DocumentListener listener = new DocumentListener(){

        private void changes() {
            IncludeExcludeVisualizerPanel.this.handle.changedPatterns(IncludeExcludeVisualizerPanel.this.includes.getText(), IncludeExcludeVisualizerPanel.this.excludes.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changes();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changes();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };
    private final DefaultListModel<File> includedListModel = new DefaultListModel();
    private final DefaultListModel<File> excludedListModel = new DefaultListModel();
    private String rootPrefix;
    private JList excludedList;
    private JLabel excludedListLabel;
    private JScrollPane excludedListPane;
    private JTextField excludes;
    private JLabel excludesLabel;
    private JLabel explanation;
    private JList includedList;
    private JLabel includedListLabel;
    private JScrollPane includedListPane;
    private JTextField includes;
    private JLabel includesLabel;
    private JLabel scanningLabel;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public IncludeExcludeVisualizerPanel(IncludeExcludeVisualizer handle) {
        this.handle = handle;
        this.initComponents();
        this.includes.getDocument().addDocumentListener(this.listener);
        this.excludes.getDocument().addDocumentListener(this.listener);
        this.includedList.setModel(this.includedListModel);
        this.excludedList.setModel(this.excludedListModel);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                File f = (File)value;
                String label = f.getAbsolutePath();
                if (IncludeExcludeVisualizerPanel.this.rootPrefix != null) {
                    assert (label.startsWith(IncludeExcludeVisualizerPanel.this.rootPrefix)) : "Expected " + label + " to start with '" + IncludeExcludeVisualizerPanel.access$300(IncludeExcludeVisualizerPanel.this) + "'";
                    label = label.substring(IncludeExcludeVisualizerPanel.this.rootPrefix.length()).replace(File.separatorChar, '/');
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        };
        this.includedList.setCellRenderer(renderer);
        this.excludedList.setCellRenderer(renderer);
    }

    void setFields(String includes, String excludes) {
        assert (EventQueue.isDispatchThread());
        this.includes.getDocument().removeDocumentListener(this.listener);
        this.includes.setText(includes);
        this.includes.getDocument().addDocumentListener(this.listener);
        this.excludes.getDocument().removeDocumentListener(this.listener);
        this.excludes.setText(excludes);
        this.excludes.getDocument().addDocumentListener(this.listener);
    }

    void setFiles(File[] included, File[] excluded, boolean busy, File singleRoot) {
        assert (EventQueue.isDispatchThread());
        this.includedListModel.clear();
        for (File f : included) {
            this.includedListModel.addElement(f);
        }
        this.excludedListModel.clear();
        for (File f : excluded) {
            this.excludedListModel.addElement(f);
        }
        this.scanningLabel.setVisible(busy);
        if (singleRoot == null) {
            this.rootPrefix = null;
        } else {
            assert (singleRoot.isDirectory()) : singleRoot;
            this.rootPrefix = singleRoot.getAbsolutePath() + File.separatorChar;
        }
    }

    private void initComponents() {
        this.includedListLabel = new JLabel();
        this.includedListPane = new JScrollPane();
        this.includedList = new JList();
        this.excludedListLabel = new JLabel();
        this.excludedListPane = new JScrollPane();
        this.excludedList = new JList();
        this.scanningLabel = new JLabel();
        this.includesLabel = new JLabel();
        this.includes = new JTextField();
        this.excludesLabel = new JLabel();
        this.excludes = new JTextField();
        this.explanation = new JLabel();
        this.includedListLabel.setLabelFor(this.includedList);
        Mnemonics.setLocalizedText((JLabel)this.includedListLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.includedListLabel.text"));
        this.includedListPane.setViewportView(this.includedList);
        this.includedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSN_includedList"));
        this.includedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_includedList"));
        this.excludedListLabel.setLabelFor(this.excludedList);
        Mnemonics.setLocalizedText((JLabel)this.excludedListLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.excludedListLabel.text"));
        this.excludedListPane.setViewportView(this.excludedList);
        this.excludedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSN_excludedList"));
        this.excludedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_excludedList"));
        Mnemonics.setLocalizedText((JLabel)this.scanningLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.scanningLabel.text"));
        this.includesLabel.setLabelFor(this.includes);
        Mnemonics.setLocalizedText((JLabel)this.includesLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.includesLabel.text"));
        this.excludesLabel.setLabelFor(this.excludes);
        Mnemonics.setLocalizedText((JLabel)this.excludesLabel, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.excludesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.explanation, (String)NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"IncludeExcludeVisualizerPanel.explanation.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includesLabel).addComponent(this.excludesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.excludes, -1, 390, Short.MAX_VALUE).addComponent(this.includes, -1, 390, Short.MAX_VALUE))).addComponent(this.scanningLabel).addComponent(this.includedListLabel).addComponent(this.excludedListLabel).addComponent(this.includedListPane, GroupLayout.Alignment.TRAILING, -1, 468, Short.MAX_VALUE).addComponent(this.excludedListPane, GroupLayout.Alignment.TRAILING, -1, 468, Short.MAX_VALUE).addComponent(this.explanation, GroupLayout.Alignment.TRAILING, -1, 468, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.includesLabel).addComponent(this.includes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludesLabel).addComponent(this.excludes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includedListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includedListPane, -1, 143, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludedListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludedListPane, -1, 143, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.explanation).addContainerGap()));
        this.includesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_includesLabel"));
        this.excludesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_excludesLabel"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSN_IncludeExcludeVisualizerPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IncludeExcludeVisualizerPanel.class, (String)"ACSD_IncludeExcludeVisualizerPanel"));
    }
}

