/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.protractor;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.ProtractorPreferences;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.ProtractorPreferencesValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.spi.ImportantFilesImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class ImportantFilesImpl
implements ImportantFilesImplementation,
PreferenceChangeListener {
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean listening = false;

    public ImportantFilesImpl(Project project) {
        assert (project != null);
        this.project = project;
    }

    private synchronized void addListener(Project project) {
        if (this.listening) {
            return;
        }
        ProtractorPreferences.addPreferenceChangeListener(project, (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, ProtractorPreferences.class));
        this.listening = true;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        this.addListener(this.project);
        if (!ProtractorPreferences.isEnabled(this.project)) {
            return Collections.emptyList();
        }
        String config = ProtractorPreferences.getUserConfigurationFile(this.project);
        ValidationResult result = new ProtractorPreferencesValidator().validateUserConfigurationFile(this.project, config).getResult();
        if (!result.isFaultless()) {
            return Collections.emptyList();
        }
        FileObject file = FileUtil.toFileObject((File)new File(config));
        assert (file != null) : config;
        return Collections.singleton(new ImportantFilesImplementation.FileInfo(file));
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        String key = evt.getKey();
        if ("enabled".equals(key) || "user.configuration.file".equals(key)) {
            this.changeSupport.fireChange();
        }
    }
}

