/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.actions.Bundle;
import org.netbeans.modules.php.editor.actions.FixUsesAction;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.AliasedElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.EnumElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.model.ModelUtils;

public class ImportDataCreator {
    public static final String NS_SEPARATOR = "\\";
    private final Map<String, List<UsedNamespaceName>> usedNames;
    private final ElementQuery.Index phpIndex;
    private final QualifiedName currentNamespace;
    private boolean shouldShowUsesPanel = false;
    private final FixUsesAction.Options options;
    private final List<PossibleItem> possibleItems = new ArrayList<PossibleItem>();

    private static Collection<FullyQualifiedElement> sortFQElements(Collection<FullyQualifiedElement> filteredFQElements) {
        ArrayList<FullyQualifiedElement> sortedFQElements = new ArrayList<FullyQualifiedElement>(filteredFQElements);
        sortedFQElements.sort(new FQElementsComparator());
        return sortedFQElements;
    }

    public ImportDataCreator(Map<String, List<UsedNamespaceName>> usedNames, ElementQuery.Index phpIndex, QualifiedName currentNamespace, FixUsesAction.Options options) {
        this.usedNames = usedNames;
        this.phpIndex = phpIndex;
        this.currentNamespace = currentNamespace;
        this.options = options;
    }

    public ImportData create() {
        for (String fqElementName : new TreeSet<String>(this.usedNames.keySet())) {
            this.processFQElementName(fqElementName);
        }
        ImportData data = new ImportData();
        for (PossibleItem possibleItem : this.possibleItems) {
            possibleItem.insertData(data);
        }
        data.shouldShowUsesPanel = this.shouldShowUsesPanel;
        return data;
    }

    private void processFQElementName(String fqElementName) {
        if (!StringUtils.hasText((String)fqElementName)) {
            return;
        }
        String fqeName = CodeUtils.removeNullableTypePrefix(fqElementName);
        Collection<FullyQualifiedElement> possibleFQElements = this.fetchPossibleFQElements(fqeName);
        Collection<FullyQualifiedElement> filteredPlatformConstsAndFunctions = this.filterPlatformConstsAndFunctions(possibleFQElements);
        Collection<FullyQualifiedElement> filteredDuplicates = this.filterDuplicates(filteredPlatformConstsAndFunctions);
        Collection<FullyQualifiedElement> filteredExactUnqualifiedNames = this.filterExactUnqualifiedName(filteredDuplicates, fqeName);
        if (filteredExactUnqualifiedNames.isEmpty()) {
            if (this.options.getPhpVersion().compareTo((Enum)PhpVersion.PHP_56) >= 0) {
                this.possibleItems.add(new EmptyItem(fqeName));
            } else if (!this.isConstOrFunction(fqeName)) {
                this.possibleItems.add(new EmptyItem(fqeName));
            }
        } else {
            Collection<FullyQualifiedElement> filteredFQElements = this.filterFQElementsFromCurrentNamespace(filteredExactUnqualifiedNames);
            if (filteredFQElements.isEmpty()) {
                this.possibleItems.add(new ReplaceItem(fqeName, filteredExactUnqualifiedNames));
            } else {
                this.possibleItems.add(new ValidItem(fqeName, filteredFQElements, filteredFQElements.size() != filteredExactUnqualifiedNames.size()));
            }
        }
    }

    private boolean isConstOrFunction(String typeName) {
        boolean result = false;
        Set<FunctionElement> possibleFunctions = this.phpIndex.getFunctions(NameKind.prefix(typeName));
        if (possibleFunctions != null && !possibleFunctions.isEmpty()) {
            result = true;
        } else {
            Set<ConstantElement> possibleConstants = this.phpIndex.getConstants(NameKind.prefix(typeName));
            if (possibleConstants != null && !possibleConstants.isEmpty()) {
                result = true;
            }
        }
        return result;
    }

    private Collection<FullyQualifiedElement> fetchPossibleFQElements(String typeName) {
        HashSet<FullyQualifiedElement> possibleTypes = new HashSet<FullyQualifiedElement>();
        NameKind.Prefix nameKind = NameKind.prefix(typeName);
        possibleTypes.addAll(this.phpIndex.getClasses(nameKind));
        possibleTypes.addAll(this.phpIndex.getInterfaces(nameKind));
        if (this.options.getPhpVersion().compareTo((Enum)PhpVersion.PHP_54) >= 0) {
            possibleTypes.addAll(this.phpIndex.getTraits(nameKind));
        }
        if (this.options.getPhpVersion().compareTo((Enum)PhpVersion.PHP_56) >= 0) {
            possibleTypes.addAll(this.phpIndex.getFunctions(nameKind));
            possibleTypes.addAll(this.phpIndex.getConstants(nameKind));
        }
        if (this.options.getPhpVersion().compareTo((Enum)PhpVersion.PHP_81) >= 0) {
            possibleTypes.addAll(this.phpIndex.getEnums(nameKind));
        }
        return possibleTypes;
    }

    private Collection<FullyQualifiedElement> filterDuplicates(Collection<FullyQualifiedElement> possibleFQElements) {
        HashSet<FullyQualifiedElement> result = new HashSet<FullyQualifiedElement>();
        HashSet<String> filteredFQElements = new HashSet<String>();
        for (FullyQualifiedElement fqElement : possibleFQElements) {
            String typeElementName = fqElement.toString();
            if (filteredFQElements.contains(typeElementName)) continue;
            filteredFQElements.add(typeElementName);
            result.add(fqElement);
        }
        return result;
    }

    private Collection<FullyQualifiedElement> filterPlatformConstsAndFunctions(Collection<FullyQualifiedElement> possibleFQElements) {
        HashSet<FullyQualifiedElement> result = new HashSet<FullyQualifiedElement>();
        for (FullyQualifiedElement fqElement : possibleFQElements) {
            if (fqElement instanceof ClassElement || fqElement instanceof InterfaceElement || fqElement instanceof TraitElement || fqElement instanceof EnumElement) {
                result.add(fqElement);
                continue;
            }
            if (fqElement.isPlatform()) continue;
            result.add(fqElement);
        }
        return result;
    }

    private Collection<FullyQualifiedElement> filterExactUnqualifiedName(Collection<FullyQualifiedElement> possibleFQElements, String typeName) {
        HashSet<FullyQualifiedElement> result = new HashSet<FullyQualifiedElement>();
        for (FullyQualifiedElement fqElement : possibleFQElements) {
            QualifiedName qualifiedTypeName = QualifiedName.create(typeName);
            LinkedList<String> segments = qualifiedTypeName.getSegments();
            Collections.reverse(segments);
            LinkedList<String> elementSegments = fqElement.getFullyQualifiedName().getSegments();
            Collections.reverse(elementSegments);
            boolean exactUnqualifiedName = true;
            if (!segments.isEmpty() && segments.size() <= elementSegments.size()) {
                for (int i = 0; i < segments.size(); ++i) {
                    if (((String)segments.get(i)).equals(elementSegments.get(i))) continue;
                    exactUnqualifiedName = false;
                    break;
                }
            } else {
                exactUnqualifiedName = false;
            }
            if (!exactUnqualifiedName) continue;
            result.add(fqElement);
        }
        return result;
    }

    private Collection<FullyQualifiedElement> filterFQElementsFromCurrentNamespace(Collection<FullyQualifiedElement> possibleFQElements) {
        HashSet<FullyQualifiedElement> result = new HashSet<FullyQualifiedElement>();
        for (FullyQualifiedElement fqElement : possibleFQElements) {
            if (fqElement.getNamespaceName().equals(this.currentNamespace)) continue;
            result.add(fqElement);
        }
        return result;
    }

    private boolean hasDefaultNamespaceName(Collection<FullyQualifiedElement> possibleFQElements) {
        boolean result = false;
        for (FullyQualifiedElement fqElement : possibleFQElements) {
            if (!fqElement.getNamespaceName().isDefaultNamespace()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static class FQElementsComparator
    implements Comparator<FullyQualifiedElement>,
    Serializable {
        private FQElementsComparator() {
        }

        @Override
        public int compare(FullyQualifiedElement o1, FullyQualifiedElement o2) {
            return o1.getFullyQualifiedName().toString().compareToIgnoreCase(o2.getFullyQualifiedName().toString()) * -1;
        }
    }

    private static interface PossibleItem {
        public void insertData(ImportData var1);
    }

    private static class EmptyItem
    implements PossibleItem {
        private final String typeName;

        public EmptyItem(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public void insertData(ImportData data) {
            ImportData.ItemVariant itemVariant = new ImportData.ItemVariant(Bundle.CanNotBeResolved(), ImportData.ItemVariant.UsagePolicy.CAN_NOT_BE_USED, ImportData.ItemVariant.Type.ERROR, false);
            data.add(new ImportData.DataItem(this.typeName, Arrays.asList(itemVariant), itemVariant));
        }
    }

    private final class ReplaceItem
    implements PossibleItem {
        private final String fqName;
        private final Collection<FullyQualifiedElement> filteredExactUnqualifiedNames;

        public ReplaceItem(String fqName, Collection<FullyQualifiedElement> filteredExactUnqualifiedNames) {
            this.fqName = fqName;
            this.filteredExactUnqualifiedNames = filteredExactUnqualifiedNames;
        }

        @Override
        public void insertData(ImportData data) {
            FullyQualifiedElement fqElement = this.findBestElement();
            assert (fqElement != null);
            String itemVariantReplaceName = ImportDataCreator.this.options.preferFullyQualifiedNames() ? fqElement.getFullyQualifiedName().toString() : fqElement.getName();
            ImportData.ItemVariant replaceItemVariant = new ImportData.ItemVariant(itemVariantReplaceName, ImportData.ItemVariant.UsagePolicy.CAN_BE_USED);
            assert (ImportDataCreator.this.usedNames.get(this.fqName) != null) : "fqName: " + this.fqName;
            data.addJustToReplace(new ImportData.DataItem(this.fqName, Collections.singletonList(replaceItemVariant), replaceItemVariant, ImportDataCreator.this.usedNames.get(this.fqName)));
        }

        private FullyQualifiedElement findBestElement() {
            String fullName = ImportDataCreator.NS_SEPARATOR + this.fqName;
            for (FullyQualifiedElement element : this.filteredExactUnqualifiedNames) {
                if (!fullName.equals(element.getFullyQualifiedName().toString())) continue;
                return element;
            }
            return ModelUtils.getFirst(this.filteredExactUnqualifiedNames);
        }
    }

    private final class ValidItem
    implements PossibleItem {
        private final Collection<FullyQualifiedElement> filteredFQElements;
        private final String typeName;
        private final boolean existsFQElementFromCurrentNamespace;

        private ValidItem(String typeName, Collection<FullyQualifiedElement> filteredFQElements, boolean existsFQELEMENTFromCurrentNamespace) {
            this.typeName = typeName;
            this.filteredFQElements = filteredFQElements;
            this.existsFQElementFromCurrentNamespace = existsFQELEMENTFromCurrentNamespace;
        }

        @Override
        public void insertData(ImportData data) {
            Collection<FullyQualifiedElement> sortedFQElements = ImportDataCreator.sortFQElements(this.filteredFQElements);
            ArrayList<ImportData.ItemVariant> variants = new ArrayList<ImportData.ItemVariant>();
            ImportData.ItemVariant defaultValue = null;
            boolean isFirst = true;
            for (FullyQualifiedElement fqElement : sortedFQElements) {
                String variantName = fqElement.getFullyQualifiedName().toString();
                boolean isFromAliasedElement = false;
                if (fqElement instanceof AliasedElement) {
                    AliasedElement aliasedElement = (AliasedElement)fqElement;
                    variantName = aliasedElement.getAliasedName().getAliasName();
                    isFromAliasedElement = true;
                }
                ImportData.ItemVariant itemVariant = new ImportData.ItemVariant(variantName, ImportData.ItemVariant.UsagePolicy.CAN_BE_USED, fqElement.getPhpElementKind(), isFromAliasedElement);
                variants.add(itemVariant);
                if (isFirst) {
                    defaultValue = itemVariant;
                    isFirst = false;
                }
                ImportDataCreator.this.shouldShowUsesPanel = true;
            }
            ImportData.ItemVariant dontUseItemVariant = new ImportData.ItemVariant(Bundle.DoNotUseType(), ImportData.ItemVariant.UsagePolicy.CAN_NOT_BE_USED);
            variants.add(dontUseItemVariant);
            QualifiedName qualifiedTypeName = QualifiedName.create(this.typeName);
            if (qualifiedTypeName.getKind().isFullyQualified()) {
                if (ImportDataCreator.this.options.preferFullyQualifiedNames()) {
                    defaultValue = dontUseItemVariant;
                }
            } else if (ImportDataCreator.this.currentNamespace.isDefaultNamespace() && ImportDataCreator.this.hasDefaultNamespaceName(sortedFQElements) || this.existsFQElementFromCurrentNamespace) {
                defaultValue = dontUseItemVariant;
            }
            Collections.sort(variants);
            assert (ImportDataCreator.this.usedNames.get(this.typeName) != null) : "typeName: " + this.typeName;
            data.add(new ImportData.DataItem(this.typeName, variants, defaultValue, ImportDataCreator.this.usedNames.get(this.typeName)));
        }
    }
}

