/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstBracketSuffix;
import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.Node;
import java.util.List;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.ELElement;
import org.openide.util.Parameters;

public class NodeUtil {
    private static final String INDENT = "    ";

    public static String dump(Node node) {
        StringBuilder buf = new StringBuilder();
        NodeUtil.dump(node, "", buf);
        return buf.toString();
    }

    private static void dump(Node node, String prefix, StringBuilder buf) {
        buf.append(prefix);
        buf.append(node.toString());
        buf.append('\n');
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            NodeUtil.dump(child, prefix + INDENT, buf);
        }
    }

    private static int getIndex(Node parent, Node child) {
        for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
            Node n = parent.jjtGetChild(i);
            if (!n.equals((Object)child)) continue;
            return i;
        }
        return -1;
    }

    public static Node getSiblingBefore(Node node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Node parent = node.jjtGetParent();
        if (parent == null) {
            return null;
        }
        int index = NodeUtil.getIndex(parent, node);
        assert (index >= 0);
        if (index == 0) {
            return null;
        }
        return parent.jjtGetChild(index - 1);
    }

    public static boolean isMethodCall(Node n) {
        if (n instanceof AstDotSuffix && n.jjtGetNumChildren() > 0) {
            return true;
        }
        return n instanceof AstBracketSuffix && n.jjtGetNumChildren() > 1;
    }

    public static List<Node> getRootToNode(ELElement element, Node target) {
        AstPath path = new AstPath(element.getNode());
        return path.rootToNode(target);
    }
}

