/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.swing.laf.flatlaf.ui.Utils;
import org.openide.util.VectorIcon;

public final class FlatTabControlIcon
extends VectorIcon {
    private static final boolean chevron = "chevron".equals(UIManager.getString("Component.arrowType"));
    private static final int arc = UIManager.getInt("TabControlIcon.arc");
    private static final Color foreground = UIManager.getColor("TabControlIcon.foreground");
    private static final Color disabledForeground = UIManager.getColor("TabControlIcon.disabledForeground");
    private static final Color rolloverBackground = UIManager.getColor("TabControlIcon.rolloverBackground");
    private static final Color pressedBackground = UIManager.getColor("TabControlIcon.pressedBackground");
    private static final Color closeRolloverBackground = UIManager.getColor("TabControlIcon.close.rolloverBackground");
    private static final Color closeRolloverForeground = UIManager.getColor("TabControlIcon.close.rolloverForeground");
    private static final Map<Map.Entry<Integer, Integer>, Icon> INSTANCES = FlatTabControlIcon.populateInstances();
    private final int buttonId;
    private final Integer buttonState;
    private final float userScaleFactor;

    private static void populateOne(Map<Map.Entry<Integer, Integer>, Icon> toMap, int buttonId, Integer buttonState) {
        toMap.put(new AbstractMap.SimpleEntry<Integer, Integer>(buttonId, buttonState), (Icon)((Object)new FlatTabControlIcon(buttonId, buttonState)));
    }

    private static Map<Map.Entry<Integer, Integer>, Icon> populateInstances() {
        LinkedHashMap<String, Integer> buttonIDs = new LinkedHashMap<String, Integer>();
        buttonIDs.put("close", 1);
        buttonIDs.put("pin", 2);
        buttonIDs.put("restore_group", 11);
        buttonIDs.put("slide_group", 12);
        buttonIDs.put("scroll_left", 9);
        buttonIDs.put("scroll_right", 10);
        buttonIDs.put("drop_down", 8);
        buttonIDs.put("maximize", 3);
        buttonIDs.put("restore", 4);
        LinkedHashMap<String, Integer> buttonStates = new LinkedHashMap<String, Integer>();
        buttonStates.put("component", null);
        buttonStates.put("default", 0);
        buttonStates.put("pressed", 1);
        buttonStates.put("disabled", 2);
        buttonStates.put("rollover", 3);
        LinkedHashMap<Map.Entry<Integer, Integer>, Icon> ret = new LinkedHashMap<Map.Entry<Integer, Integer>, Icon>();
        for (Map.Entry buttonID : buttonIDs.entrySet()) {
            for (Map.Entry buttonState : buttonStates.entrySet()) {
                FlatTabControlIcon.populateOne(ret, (Integer)buttonID.getValue(), (Integer)buttonState.getValue());
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    private FlatTabControlIcon(int buttonId, Integer buttonState) {
        super(UIScale.scale((int)16), UIScale.scale((int)(buttonId == 1 ? 15 : 16)));
        this.buttonId = buttonId;
        this.buttonState = buttonState;
        this.userScaleFactor = UIScale.getUserScaleFactor();
    }

    public static Icon get(int buttonId, int buttonState) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Integer>(buttonId, buttonState));
    }

    public static Icon get(int buttonId) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Object>(buttonId, null));
    }

    protected void paintIcon(Component c, Graphics2D g, int width, int height, double scaling) {
        Color closeColor;
        int buttonState;
        scaling *= (double)this.userScaleFactor;
        Color bgColor = new Color(0, 0, 0, 0);
        Color fgColor = foreground;
        if (this.buttonState != null) {
            buttonState = this.buttonState;
        } else {
            buttonState = 0;
            if (!c.isEnabled()) {
                buttonState = 2;
            } else if (c instanceof AbstractButton) {
                ButtonModel bm = ((AbstractButton)c).getModel();
                if (bm.isPressed()) {
                    buttonState = 1;
                } else if (bm.isRollover()) {
                    buttonState = 3;
                }
            }
        }
        Color color = closeColor = this.buttonId == 1 ? closeRolloverBackground : null;
        if (buttonState == 2) {
            fgColor = disabledForeground;
        } else if (buttonState == 1) {
            Color color2 = bgColor = closeColor != null ? closeColor : pressedBackground;
            if (closeColor != null && closeRolloverForeground != null) {
                fgColor = closeRolloverForeground;
            }
        } else if (buttonState == 3) {
            Color color3 = bgColor = closeColor != null ? closeColor : rolloverBackground;
            if (closeColor != null && closeRolloverForeground != null) {
                fgColor = closeRolloverForeground;
            }
        }
        if (bgColor.getAlpha() > 0) {
            int scaledArc = FlatTabControlIcon.round((double)((double)(arc * 2) * scaling));
            g.setColor(bgColor);
            g.fillRoundRect(0, 0, width, height, scaledArc, scaledArc);
        }
        g.setColor(fgColor);
        if (this.buttonId == 1) {
            double strokeWidth = (bgColor.getAlpha() > 0 ? 1.0 : 0.8) * scaling;
            if (scaling > 1.0) {
                strokeWidth *= 1.5;
            } else if (strokeWidth < 1.0) {
                strokeWidth = 1.0;
            }
            double mx = (double)width / 2.0;
            double my = (double)height / 2.0;
            double cr = 3.25 * scaling;
            BasicStroke stroke = new BasicStroke((float)strokeWidth, 1, 1);
            Area area = new Area();
            area.add(new Area(stroke.createStrokedShape(new Line2D.Double(mx - cr, my - cr, mx + cr, my + cr))));
            area.add(new Area(stroke.createStrokedShape(new Line2D.Double(mx + cr, my - cr, mx - cr, my + cr))));
            g.fill(area);
        } else if (this.buttonId == 2 || this.buttonId == 11 || this.buttonId == 4) {
            int wh = FlatTabControlIcon.round((double)(8.0 * scaling));
            int win1X = FlatTabControlIcon.round((double)(5.0 * scaling));
            int win1Y = FlatTabControlIcon.round((double)(3.0 * scaling));
            int win2X = FlatTabControlIcon.round((double)(3.0 * scaling));
            int win2Y = FlatTabControlIcon.round((double)(5.0 * scaling));
            Area win1 = FlatTabControlIcon.getWindowSymbol(scaling, win1X, win1Y, wh, wh);
            Area win2 = FlatTabControlIcon.getWindowSymbol(scaling, win2X, win2Y, wh, wh);
            win1.subtract(new Area(win2.getBounds2D()));
            g.fill(win1);
            g.fill(win2);
        } else if (this.buttonId == 3) {
            int xy = (int)(3.0 * scaling);
            int wh = width - 2 * xy;
            g.fill(FlatTabControlIcon.getWindowSymbol(scaling, xy, xy, wh, wh));
        } else if (this.buttonId == 12) {
            int barX = (int)(3.0 * scaling);
            int barY = FlatTabControlIcon.round((double)(11.0 * scaling));
            int barWidth = width - 2 * barX;
            int barThickness = (int)(1.0 * scaling);
            g.fill(new Rectangle2D.Double(barX, barY, barWidth, barThickness));
        } else if (this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            if (this.buttonId == 9) {
                g.rotate(1.5707963267948966, (double)width / 2.0, (double)height / 2.0);
            } else if (this.buttonId == 10) {
                g.rotate(-1.5707963267948966, (double)width / 2.0, (double)height / 2.0);
            }
            int y = FlatTabControlIcon.round((double)(((double)height - 4.0 * scaling) / 2.0));
            double arrowWidth = (chevron ? 8.0 : 9.0) * scaling;
            double arrowHeight = (chevron ? 4.0 : 5.0) * scaling;
            double arrowMidX = (double)width / 2.0;
            if (!chevron && scaling == 1.0) {
                arrowMidX -= 0.5;
                if (this.buttonId == 9) {
                    arrowMidX += 1.0;
                }
            }
            Path2D.Double arrowPath = new Path2D.Double();
            arrowPath.moveTo(arrowMidX - arrowWidth / 2.0, y);
            arrowPath.lineTo(arrowMidX, (double)y + arrowHeight);
            arrowPath.lineTo(arrowMidX + arrowWidth / 2.0, y);
            if (chevron) {
                Utils.setRenderingHints(g);
                g.setStroke(new BasicStroke((float)scaling));
                g.draw(arrowPath);
            } else {
                arrowPath.closePath();
                g.fill(arrowPath);
            }
        }
    }

    private static Area getWindowSymbol(double scaling, int x, int y, int width, int height) {
        int borderThickness = FlatTabControlIcon.round((double)(0.8 * scaling));
        Area ret = new Area(new Rectangle2D.Double(x, y, width, height));
        ret.subtract(new Area(new Rectangle2D.Double(x + borderThickness, y + borderThickness, width - borderThickness * 2, height - borderThickness * 2)));
        return ret;
    }
}

