/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.lib.chrome_devtools_protocol.ChromeDevToolsClient;
import org.netbeans.lib.chrome_devtools_protocol.Unregisterer;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.debugger.PauseRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ResumeRequest;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ScriptFailedToParse;
import org.netbeans.lib.chrome_devtools_protocol.debugger.ScriptParsed;
import org.netbeans.lib.chrome_devtools_protocol.json.Endpoint;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.netbeans.modules.javascript.cdtdebug.api.Connector;
import org.netbeans.modules.javascript.cdtdebug.breakpoints.BreakpointsHandler;
import org.netbeans.modules.javascript.cdtdebug.sources.ChangeLiveSupport;
import org.openide.util.Exceptions;

public class CDTDebugger {
    private static final Logger LOG = Logger.getLogger(CDTDebugger.class.getName());
    private final Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();
    private final Endpoint endpoint;
    private final ChromeDevToolsClient connection;
    private final ScriptsHandler scriptsHandler;
    private final BreakpointsHandler breakpointsHandler;
    private final ChangeLiveSupport changeLiveSupport;
    private final Runnable finishCallback;
    private boolean finished;
    private boolean suspended;
    private DebuggerEngine engine;
    private DebuggerEngine.Destructor engineDestructor;
    private CallFrame currentFrame;
    private List<CallFrame> currentCallStack;

    public static DebuggerEngine startSession(Connector.Properties properties, @NullAllowed Runnable finishCallback) throws IOException {
        String host = properties.getHostName();
        if (host == null || host.isBlank()) {
            host = "127.0.0.1";
        }
        int port = properties.getPort();
        Endpoint endpoint = null;
        String targetIdentifier = properties.getTargetIdentifier();
        for (Endpoint ep : ChromeDevToolsClient.listEndpoints((String)host, (int)port)) {
            if (targetIdentifier != null && !targetIdentifier.isBlank() && !ep.getId().equals(targetIdentifier)) continue;
            endpoint = ep;
            break;
        }
        CDTDebugger dbg = new CDTDebugger(endpoint, properties, finishCallback);
        DebuggerInfo dInfo = DebuggerInfo.create((String)"javascript-cdtdebuginfo", (Object[])new Object[]{dbg});
        DebuggerEngine[] engines = DebuggerManager.getDebuggerManager().startDebugging(dInfo);
        if (engines.length > 0) {
            dbg.setEngine(engines[0]);
            return engines[0];
        }
        if (finishCallback != null) {
            finishCallback.run();
        }
        return null;
    }

    private CDTDebugger(Endpoint endpoint, Connector.Properties properties, Runnable finishCallback) {
        this.finishCallback = finishCallback;
        this.endpoint = endpoint;
        this.connection = new ChromeDevToolsClient(endpoint.getWebSocketDebuggerUrl());
        this.scriptsHandler = new ScriptsHandler(properties.getLocalPaths(), properties.getServerPaths(), properties.getLocalPathExclusionFilters(), this);
        this.breakpointsHandler = new BreakpointsHandler(this);
        this.changeLiveSupport = new ChangeLiveSupport(this);
        this.connection.getDebugger().onScriptFailedToParse(dto -> this.scriptsHandler.add(new CDTScript((ScriptFailedToParse)dto)));
        this.connection.getDebugger().onScriptParsed(dto -> this.scriptsHandler.add(new CDTScript((ScriptParsed)dto)));
        this.connection.getDebugger().onPaused(paused -> {
            this.suspended = true;
            this.currentFrame = (CallFrame)paused.getCallFrames().get(0);
            this.currentCallStack = paused.getCallFrames();
            this.listeners.forEach(c -> {
                c.notifyCurrentFrame((CallFrame)paused.getCallFrames().get(0));
                c.notifySuspended(true);
            });
        });
        this.connection.getDebugger().onResumed(resumed -> {
            this.currentFrame = null;
            this.currentCallStack = null;
            this.listeners.forEach(c -> {
                c.notifyCurrentFrame(null);
                c.notifySuspended(false);
            });
            this.suspended = false;
        });
        try {
            this.connection.connect();
            this.connection.getDebugger().enable(null).toCompletableFuture().get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public URI getWebSocketDebuggerUrl() {
        return this.endpoint.getWebSocketDebuggerUrl();
    }

    public void start() {
        this.connection.getRuntime().runIfWaitingForDebugger();
    }

    public void suspend() {
        ChromeDevToolsClient cdtc = this.connection;
        if (cdtc != null) {
            cdtc.getDebugger().pause(new PauseRequest());
        }
    }

    public void resume() {
        ChromeDevToolsClient cdtc = this.connection;
        if (cdtc != null) {
            cdtc.getDebugger().resume(new ResumeRequest());
        }
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listeners.forEach(cl -> cl.notifyFinished());
        this.engineDestructor.killEngine();
        if (this.finishCallback != null) {
            this.finishCallback.run();
        }
    }

    private static void unregister(Unregisterer registerer) {
        if (registerer != null) {
            try {
                registerer.close();
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "Failed to unregister", ex);
            }
        }
    }

    public ChromeDevToolsClient getConnection() {
        return this.connection;
    }

    public ScriptsHandler getScriptsHandler() {
        return this.scriptsHandler;
    }

    public BreakpointsHandler getBreakpointsHandler() {
        return this.breakpointsHandler;
    }

    public ChangeLiveSupport getChangeLiveSupport() {
        return this.changeLiveSupport;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public CallFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(CallFrame currentFrame) {
        this.currentFrame = currentFrame;
        this.listeners.forEach(cl -> cl.notifyCurrentFrame(currentFrame));
    }

    public List<CallFrame> getCurrentCallStack() {
        return this.currentCallStack;
    }

    DebuggerEngine getEngine() {
        return this.engine;
    }

    void setEngine(DebuggerEngine engine) {
        this.engine = engine;
    }

    void setEngineDestructor(DebuggerEngine.Destructor destructor) {
        this.engineDestructor = destructor;
    }

    public static interface Listener {
        public void notifySuspended(boolean var1);

        public void notifyCurrentFrame(@NullAllowed CallFrame var1);

        public void notifyFinished();
    }
}

