/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DBMONEY
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNYHIGH;
    public static final int MNYLOW;

    public DBMONEY(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), DBMONEY.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int mnyhigh() {
        return DBMONEY.nmnyhigh(this.address());
    }

    @NativeType(value="ULONG")
    public int mnylow() {
        return DBMONEY.nmnylow(this.address());
    }

    public DBMONEY mnyhigh(@NativeType(value="LONG") int value) {
        DBMONEY.nmnyhigh(this.address(), value);
        return this;
    }

    public DBMONEY mnylow(@NativeType(value="ULONG") int value) {
        DBMONEY.nmnylow(this.address(), value);
        return this;
    }

    public DBMONEY set(int mnyhigh, int mnylow) {
        this.mnyhigh(mnyhigh);
        this.mnylow(mnylow);
        return this;
    }

    public DBMONEY set(DBMONEY src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static DBMONEY malloc() {
        return (DBMONEY)DBMONEY.wrap(DBMONEY.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static DBMONEY calloc() {
        return (DBMONEY)DBMONEY.wrap(DBMONEY.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static DBMONEY create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (DBMONEY)DBMONEY.wrap(DBMONEY.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static DBMONEY create(long address) {
        return (DBMONEY)DBMONEY.wrap(DBMONEY.class, (long)address);
    }

    @Nullable
    public static DBMONEY createSafe(long address) {
        return address == 0L ? null : (DBMONEY)DBMONEY.wrap(DBMONEY.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)DBMONEY.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)DBMONEY.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)DBMONEY.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = DBMONEY.__create((int)capacity, (int)SIZEOF);
        return (Buffer)DBMONEY.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)DBMONEY.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)DBMONEY.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static DBMONEY mallocStack() {
        return DBMONEY.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBMONEY callocStack() {
        return DBMONEY.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBMONEY mallocStack(MemoryStack stack) {
        return DBMONEY.malloc(stack);
    }

    @Deprecated
    public static DBMONEY callocStack(MemoryStack stack) {
        return DBMONEY.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return DBMONEY.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return DBMONEY.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return DBMONEY.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return DBMONEY.calloc(capacity, stack);
    }

    public static DBMONEY malloc(MemoryStack stack) {
        return (DBMONEY)DBMONEY.wrap(DBMONEY.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static DBMONEY calloc(MemoryStack stack) {
        return (DBMONEY)DBMONEY.wrap(DBMONEY.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)DBMONEY.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)DBMONEY.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmnyhigh(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNYHIGH);
    }

    public static int nmnylow(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNYLOW);
    }

    public static void nmnyhigh(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNYHIGH, value);
    }

    public static void nmnylow(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNYLOW, value);
    }

    static {
        Struct.Layout layout = DBMONEY.__struct((Struct.Member[])new Struct.Member[]{DBMONEY.__member((int)4), DBMONEY.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNYHIGH = layout.offsetof(0);
        MNYLOW = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<DBMONEY, Buffer>
    implements NativeResource {
        private static final DBMONEY ELEMENT_FACTORY = DBMONEY.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected DBMONEY getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LONG")
        public int mnyhigh() {
            return DBMONEY.nmnyhigh(this.address());
        }

        @NativeType(value="ULONG")
        public int mnylow() {
            return DBMONEY.nmnylow(this.address());
        }

        public Buffer mnyhigh(@NativeType(value="LONG") int value) {
            DBMONEY.nmnyhigh(this.address(), value);
            return this;
        }

        public Buffer mnylow(@NativeType(value="ULONG") int value) {
            DBMONEY.nmnylow(this.address(), value);
            return this;
        }
    }
}

