/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.dex.Dex2jar;
import com.googlecode.d2j.dex.DexExceptionHandler;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.tools.BaksmaliBaseDexExceptionHandler;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@BaseCmd.Syntax(cmd="d2j-dex2jar", syntax="[options] <file0> [file1 ... fileN]", desc="convert dex to jar")
public class Dex2jarCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="e", longOpt="exception-file", description="detail exception file, default is $current_dir/[file-name]-error.zip", argName="file")
    private Path exceptionFile;
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="n", longOpt="not-handle-exception", hasArg=false, description="not handle any exception throwed by dex2jar")
    private boolean notHandleException = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file, default is $current_dir/[file-name]-dex2jar.jar", argName="out-jar-file")
    private Path output;
    @BaseCmd.Opt(opt="r", longOpt="reuse-reg", hasArg=false, description="reuse regiter while generate java .class file")
    private boolean reuseReg = false;
    @BaseCmd.Opt(opt="s", hasArg=false, description="same with --topological-sort/-ts")
    private boolean topologicalSort1 = false;
    @BaseCmd.Opt(opt="ts", longOpt="topological-sort", hasArg=false, description="sort block by topological, that will generate more readable code, default enabled")
    private boolean topologicalSort = false;
    @BaseCmd.Opt(opt="d", longOpt="debug-info", hasArg=false, description="translate debug info")
    private boolean debugInfo = false;
    @BaseCmd.Opt(opt="p", longOpt="print-ir", hasArg=false, description="print ir to Syste.out")
    private boolean printIR = false;
    @BaseCmd.Opt(opt="os", longOpt="optmize-synchronized", hasArg=false, description="optmize-synchronized")
    private boolean optmizeSynchronized = false;
    @BaseCmd.Opt(opt="nc", longOpt="no-code", hasArg=false, description="")
    private boolean noCode = false;

    public static void main(String ... args) {
        new Dex2jarCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        String fileName;
        int n;
        int n2;
        String[] stringArray;
        if (this.remainingArgs.length == 0) {
            this.usage();
            return;
        }
        if ((this.exceptionFile != null || this.output != null) && this.remainingArgs.length != 1) {
            System.err.println("-e/-o can only used with one file");
            return;
        }
        if (this.debugInfo && this.reuseReg) {
            System.err.println("-d/-r can not use together");
            return;
        }
        Path currentDir = new File(".").toPath();
        if (this.output != null) {
            if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
                System.err.println(this.output + " exists, use --force to overwrite");
                return;
            }
        } else {
            stringArray = this.remainingArgs;
            n2 = this.remainingArgs.length;
            n = 0;
            while (n < n2) {
                fileName = stringArray[n];
                Path file = currentDir.resolve(String.valueOf(Dex2jarCmd.getBaseName((Path)new File(fileName).toPath())) + "-dex2jar.jar");
                if (Files.exists(file, new LinkOption[0]) && !this.forceOverwrite) {
                    System.err.println(file + " exists, use --force to overwrite");
                    return;
                }
                ++n;
            }
        }
        stringArray = this.remainingArgs;
        n2 = this.remainingArgs.length;
        n = 0;
        while (n < n2) {
            fileName = stringArray[n];
            String baseName = Dex2jarCmd.getBaseName((Path)new File(fileName).toPath());
            Path file = this.output == null ? currentDir.resolve(String.valueOf(baseName) + "-dex2jar.jar") : this.output;
            System.err.println("dex2jar " + fileName + " -> " + file);
            DexFileReader reader = new DexFileReader(ZipUtil.readDex((File)new File(fileName)));
            BaksmaliBaseDexExceptionHandler handler = this.notHandleException ? null : new BaksmaliBaseDexExceptionHandler();
            Dex2jar.from((DexFileReader)reader).withExceptionHandler((DexExceptionHandler)handler).reUseReg(this.reuseReg).topoLogicalSort().skipDebug(!this.debugInfo).optimizeSynchronized(this.optmizeSynchronized).printIR(this.printIR).noCode(this.noCode).to(file);
            if (!this.notHandleException && handler.hasException()) {
                Path errorFile = this.exceptionFile == null ? currentDir.resolve(String.valueOf(baseName) + "-error.zip") : this.exceptionFile;
                System.err.println("Detail Error Information in File " + errorFile);
                System.err.println("Please report this file to http://code.google.com/p/dex2jar/issues/entry if possible.");
                handler.dump(errorFile, this.orginalArgs);
            }
            ++n;
        }
    }

    protected String getVersionString() {
        return "reader-" + DexFileReader.class.getPackage().getImplementationVersion() + ", translator-" + Dex2jar.class.getPackage().getImplementationVersion() + ", ir-" + ET.class.getPackage().getImplementationVersion();
    }
}

