"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sqlSearchStrategyProvider = void 0;
var _common = require("../../../data/common");
var _utils = require("../utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const sqlSearchStrategyProvider = (_config$, logger, client, usage) => {
  const sqlFacet = new _utils.Facet({
    client,
    logger,
    endpoint: 'enhancements.sqlQuery'
  });
  return {
    search: async (context, request, _options) => {
      try {
        var _rawResponse$data, _dataFrame$fields, _rawResponse$data$dat;
        request.body.query = request.body.query.qs;
        const rawResponse = await sqlFacet.describeQuery(context, request);
        if (!rawResponse.success) {
          return {
            type: _common.DATA_FRAME_TYPES.ERROR,
            body: {
              error: rawResponse.data
            },
            took: rawResponse.took
          };
        }
        const partial = {
          ...request.body.df,
          fields: ((_rawResponse$data = rawResponse.data) === null || _rawResponse$data === void 0 ? void 0 : _rawResponse$data.schema) || []
        };
        const dataFrame = (0, _common.createDataFrame)(partial);
        (_dataFrame$fields = dataFrame.fields) === null || _dataFrame$fields === void 0 || _dataFrame$fields.forEach((field, index) => {
          field.values = rawResponse.data.datarows.map(row => row[index]);
        });
        dataFrame.size = ((_rawResponse$data$dat = rawResponse.data.datarows) === null || _rawResponse$data$dat === void 0 ? void 0 : _rawResponse$data$dat.length) || 0;
        if (usage) usage.trackSuccess(rawResponse.took);
        return {
          type: _common.DATA_FRAME_TYPES.DEFAULT,
          body: dataFrame,
          took: rawResponse.took
        };
      } catch (e) {
        logger.error(`sqlSearchStrategy: ${e.message}`);
        if (usage) usage.trackError();
        throw e;
      }
    }
  };
};
exports.sqlSearchStrategyProvider = sqlSearchStrategyProvider;