"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerText2VizRoutes = registerText2VizRoutes;
var _configSchema = require("@osd/config-schema");
var _llm = require("../../common/constants/llm");
var _get_opensearch_client_transport = require("../utils/get_opensearch_client_transport");
var _constants = require("../utils/constants");
var _get_agent = require("./get_agent");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const TEXT2VEGA_AGENT_CONFIG_ID = 'text2vega';
const TEXT2PPL_AGENT_CONFIG_ID = 'text2ppl';
function registerText2VizRoutes(router) {
  router.post({
    path: _llm.TEXT2VIZ_API.TEXT2VEGA,
    validate: {
      body: _configSchema.schema.object({
        input: _configSchema.schema.string(),
        ppl: _configSchema.schema.string(),
        dataSchema: _configSchema.schema.string(),
        sampleData: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    const client = await (0, _get_opensearch_client_transport.getOpenSearchClientTransport)({
      context,
      dataSourceId: req.query.dataSourceId
    });
    const agentId = await (0, _get_agent.getAgent)(TEXT2VEGA_AGENT_CONFIG_ID, client);
    const response = await client.request({
      method: 'POST',
      path: `${_constants.ML_COMMONS_BASE_API}/agents/${agentId}/_execute`,
      body: {
        parameters: {
          input: req.body.input,
          ppl: req.body.ppl,
          dataSchema: req.body.dataSchema,
          sampleData: req.body.sampleData
        }
      }
    });
    try {
      // let result = response.body.inference_results[0].output[0].dataAsMap;
      let result = JSON.parse(response.body.inference_results[0].output[0].result);
      // sometimes llm returns {response: <schema>} instead of <schema>
      if (result.response) {
        result = JSON.parse(result.response);
      }
      // Sometimes the response contains width and height which is not needed, here delete the these fields
      delete result.width;
      delete result.height;
      return res.ok({
        body: result
      });
    } catch (e) {
      return res.internalError();
    }
  }));
  router.post({
    path: _llm.TEXT2VIZ_API.TEXT2PPL,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.string(),
        question: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    const client = await (0, _get_opensearch_client_transport.getOpenSearchClientTransport)({
      context,
      dataSourceId: req.query.dataSourceId
    });
    const agentId = await (0, _get_agent.getAgent)(TEXT2PPL_AGENT_CONFIG_ID, client);
    const response = await client.request({
      method: 'POST',
      path: `${_constants.ML_COMMONS_BASE_API}/agents/${agentId}/_execute`,
      body: {
        parameters: {
          question: req.body.question,
          index: req.body.index
        }
      }
    });
    try {
      const result = JSON.parse(response.body.inference_results[0].output[0].result);
      return res.ok({
        body: result
      });
    } catch (e) {
      return res.internalError();
    }
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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