/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.CDexBackedMethodImplementation;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.android.tools.smali.dexlib2.dexbacked.raw.CdexHeaderItem;
import com.android.tools.smali.dexlib2.util.DexUtil;
import java.io.UnsupportedEncodingException;

public class CDexBackedDexFile
extends DexBackedDexFile {
    public CDexBackedDexFile(Opcodes opcodes, byte[] buf, int offset) {
        super(opcodes, buf, offset);
    }

    public static boolean isCdex(byte[] buf, int offset) {
        byte[] cdexMagic;
        if (offset + 4 > buf.length) {
            return false;
        }
        try {
            cdexMagic = "cdex".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return buf[offset] == cdexMagic[0] && buf[offset + 1] == cdexMagic[1] && buf[offset + 2] == cdexMagic[2] && buf[offset + 3] == cdexMagic[3];
    }

    @Override
    protected int getVersion(byte[] buf, int offset, boolean verifyMagic) {
        if (verifyMagic) {
            return DexUtil.verifyCdexHeader(buf, offset);
        }
        return CdexHeaderItem.getVersion(buf, offset);
    }

    @Override
    protected Opcodes getDefaultOpcodes(int version) {
        return Opcodes.forApi(28);
    }

    @Override
    public int getBaseDataOffset() {
        return this.getBuffer().readSmallUint(108);
    }

    public int getDebugInfoOffsetsPos() {
        return this.getBuffer().readSmallUint(116);
    }

    public int getDebugInfoOffsetsTableOffset() {
        return this.getBuffer().readSmallUint(120);
    }

    public int getDebugInfoBase() {
        return this.getBuffer().readSmallUint(124);
    }

    @Override
    protected DexBackedMethodImplementation createMethodImplementation(DexBackedDexFile dexFile, DexBackedMethod method, int codeOffset) {
        return new CDexBackedMethodImplementation(dexFile, method, codeOffset);
    }
}

