/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl.exception;

import org.xeustechnologies.jcl.ResourceType;
import org.xeustechnologies.jcl.exception.JclException;

public class ResourceNotFoundException
extends JclException {
    private static final long serialVersionUID = 1L;
    private String resourceName;
    private ResourceType resourceType;

    public ResourceNotFoundException() {
    }

    public ResourceNotFoundException(String message) {
        super(message);
    }

    public ResourceNotFoundException(String resource2, String message) {
        super(message);
        this.resourceName = resource2;
        this.determineResourceType(resource2);
    }

    public ResourceNotFoundException(Throwable e, String resource2, String message) {
        super(message, e);
        this.resourceName = resource2;
        this.determineResourceType(resource2);
    }

    private void determineResourceType(String resourceName) {
        this.resourceType = resourceName.toLowerCase().endsWith("." + ResourceType.CLASS.name().toLowerCase()) ? ResourceType.CLASS : (resourceName.toLowerCase().endsWith("." + ResourceType.PROPERTIES.name().toLowerCase()) ? ResourceType.PROPERTIES : (resourceName.toLowerCase().endsWith("." + ResourceType.XML.name().toLowerCase()) ? ResourceType.XML : ResourceType.UNKNOWN));
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }
}

