/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.formtypes;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlUtil;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FormFieldRegistry {
    private static final Logger LOGGER = Logger.getLogger(FormFieldRegistry.class.getName());
    private static final Map<String, Map<String, FormField.Type>> REGISTRY = new HashMap<String, Map<String, FormField.Type>>();
    private static final Map<String, FormField.Type> CLARK_NOTATION_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();
    private static final Map<String, FormField.Type> LOOKASIDE_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();

    public static void register(DataForm dataForm) {
        if (dataForm.getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        String formType = null;
        TextSingleFormField hiddenFormTypeField = dataForm.getHiddenFormTypeField();
        if (hiddenFormTypeField != null) {
            formType = hiddenFormTypeField.getValue();
        }
        for (FormField formField : dataForm.getFields()) {
            FormField.Type type2;
            if (formField == hiddenFormTypeField || (type2 = formField.getType()) == FormField.Type.fixed) continue;
            String fieldName = formField.getFieldName();
            FormFieldRegistry.register(formType, fieldName, type2);
        }
    }

    public static void register(String formType, FormField.Type fieldType, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            FormFieldRegistry.register(formType, fieldName, fieldType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String formType, String fieldName, FormField.Type fieldType) {
        FormField.Type previousType;
        StringUtils.requireNotNullNorEmpty(fieldName, "fieldName must be provided");
        Objects.requireNonNull(fieldType);
        if (formType == null) {
            if (XmlUtil.isClarkNotation(fieldName)) {
                CLARK_NOTATION_FIELD_REGISTRY.put(fieldName, fieldType);
            }
            return;
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            Map<String, FormField.Type> fieldNameToType = REGISTRY.get(formType);
            if (fieldNameToType == null) {
                fieldNameToType = new HashMap<String, FormField.Type>();
                REGISTRY.put(formType, fieldNameToType);
            } else {
                previousType = fieldNameToType.get(fieldName);
                if (previousType != null && previousType != fieldType) {
                    throw new IllegalArgumentException();
                }
            }
            previousType = fieldNameToType.put(fieldName, fieldType);
        }
        if (previousType != null && fieldType != previousType) {
            LOGGER.warning("Form field registry inconsitency detected: Registered field '" + fieldName + "' of type " + (Object)((Object)fieldType) + " but previous type was " + (Object)((Object)previousType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormField.Type lookup(String formType, String fieldName) {
        if (formType == null) {
            if (XmlUtil.isClarkNotation(fieldName)) {
                return CLARK_NOTATION_FIELD_REGISTRY.get(fieldName);
            }
            return LOOKASIDE_FIELD_REGISTRY.get(fieldName);
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            FormField.Type type2;
            Map<String, FormField.Type> fieldNameToTypeMap = REGISTRY.get(formType);
            if (fieldNameToTypeMap != null && (type2 = fieldNameToTypeMap.get(fieldName)) != null) {
                return type2;
            }
        }
        return null;
    }

    public static synchronized FormField.Type lookup(String fieldName) {
        return FormFieldRegistry.lookup(null, fieldName);
    }

    public static void addLookasideFieldRegistryEntry(String fieldName, FormField.Type formFieldType) {
        LOOKASIDE_FIELD_REGISTRY.put(fieldName, formFieldType);
    }
}

