/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.TlsFailure;
import org.jivesoftware.smack.packet.TlsProceed;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.tcp.ConnectionAttemptState;
import org.jivesoftware.smack.tcp.XmppTcpTransportModuleDescriptor;
import org.jivesoftware.smack.tcp.rce.RemoteXmppTcpConnectionEndpoints;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.UTF8;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.util.JidUtil;
import org.jxmpp.xml.splitter.Utf8ByteXmppXmlSplitter;
import org.jxmpp.xml.splitter.XmlPrettyPrinter;
import org.jxmpp.xml.splitter.XmlPrinter;
import org.jxmpp.xml.splitter.XmppElementCallback;
import org.jxmpp.xml.splitter.XmppXmlSplitter;

public class XmppTcpTransportModule
extends ModularXmppClientToServerConnectionModule<XmppTcpTransportModuleDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(XmppTcpTransportModule.class.getName());
    private static final int CALLBACK_MAX_BYTES_READ = 0xA00000;
    private static final int CALLBACK_MAX_BYTES_WRITEN = 0xA00000;
    private static final int MAX_ELEMENT_SIZE = 65536;
    private final XmppTcpNioTransport tcpNioTransport;
    private SelectionKey selectionKey;
    private SmackReactor.SelectionKeyAttachment selectionKeyAttachment;
    private SocketChannel socketChannel;
    private InetSocketAddress remoteAddress;
    private TlsState tlsState;
    private Iterator<CharSequence> outgoingCharSequenceIterator;
    private final List<TopLevelStreamElement> currentlyOutgoingElements = new ArrayList<TopLevelStreamElement>();
    private final Map<ByteBuffer, List<TopLevelStreamElement>> bufferToElementMap = new IdentityHashMap<ByteBuffer, List<TopLevelStreamElement>>();
    private ByteBuffer outgoingBuffer;
    private ByteBuffer filteredOutgoingBuffer;
    private final List<ByteBuffer> networkOutgoingBuffers = new ArrayList<ByteBuffer>();
    private long networkOutgoingBuffersBytes;
    private final ByteBuffer incomingBuffer = ByteBuffer.allocateDirect(8192);
    private final ReentrantLock channelSelectedCallbackLock = new ReentrantLock();
    private long totalBytesRead;
    private long totalBytesWritten;
    private long totalBytesReadAfterFilter;
    private long totalBytesWrittenBeforeFilter;
    private long handledChannelSelectedCallbacks;
    private long callbackPreemtBecauseBytesWritten;
    private long callbackPreemtBecauseBytesRead;
    private int sslEngineDelegatedTasks;
    private int maxPendingSslEngineDelegatedTasks;
    private final AtomicLong setWriteInterestAfterChannelSelectedCallback = new AtomicLong();
    private final AtomicLong reactorThreadAlreadyRacing = new AtomicLong();
    private final AtomicLong afterOutgoingElementsQueueModifiedSetInterestOps = new AtomicLong();
    private final AtomicLong rejectedChannelSelectedCallbacks = new AtomicLong();
    private Jid lastDestinationAddress;
    private boolean pendingInputFilterData;
    private boolean pendingOutputFilterData;
    private boolean pendingWriteInterestAfterRead;
    private Utf8ByteXmppXmlSplitter splitter;
    private XmppXmlSplitter outputDebugSplitter;
    private static final Level STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL = Level.FINER;
    private final XmppElementCallback xmppElementCallback = new XmppElementCallback(){
        private String streamOpen;
        private String streamClose;

        @Override
        public void onCompleteElement(String completeElement) {
            assert (this.streamOpen != null);
            assert (this.streamClose != null);
            XmppTcpTransportModule.this.connectionInternal.withSmackDebugger(debugger -> debugger.onIncomingElementCompleted());
            String wrappedCompleteElement = this.streamOpen + completeElement + this.streamClose;
            XmppTcpTransportModule.this.connectionInternal.parseAndProcessElement(wrappedCompleteElement);
        }

        @Override
        public void streamOpened(String prefix, Map<String, String> attributes) {
            XmlPullParser streamOpenParser;
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " opened. prefix=" + prefix + " attributes=" + attributes);
            }
            String prefixXmlns = "xmlns:" + prefix;
            StringBuilder streamClose = new StringBuilder(32);
            StringBuilder streamOpen = new StringBuilder(256);
            streamOpen.append('<');
            streamClose.append("</");
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                streamOpen.append(prefix).append(':');
                streamClose.append(prefix).append(':');
            }
            streamOpen.append("stream");
            streamClose.append("stream>");
            block15: for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                String attributeValue = entry.getValue();
                switch (attributeName) {
                    case "to": 
                    case "from": 
                    case "id": 
                    case "version": {
                        continue block15;
                    }
                    case "xml:lang": {
                        streamOpen.append(" xml:lang='").append(attributeValue).append('\'');
                        continue block15;
                    }
                    case "xmlns": {
                        streamOpen.append(" xmlns='").append(attributeValue).append('\'');
                        continue block15;
                    }
                }
                if (attributeName.equals(prefixXmlns)) {
                    streamOpen.append(' ').append(prefixXmlns).append("='").append(attributeValue).append('\'');
                    continue;
                }
                LOGGER.info("Unknown <stream/> attribute: " + attributeName);
            }
            streamOpen.append('>');
            this.streamOpen = streamOpen.toString();
            this.streamClose = streamClose.toString();
            try {
                streamOpenParser = PacketParserUtils.getParserFor(this.streamOpen);
            }
            catch (IOException | XmlPullParserException e) {
                throw new AssertionError((Object)e);
            }
            XmppTcpTransportModule.this.connectionInternal.onStreamOpen(streamOpenParser);
        }

        @Override
        public void streamClosed() {
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " closed");
            }
            XmppTcpTransportModule.this.connectionInternal.onStreamClosed();
        }
    };
    XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredTcpEndpoints;
    private static final Level SSL_ENGINE_DEBUG_LOG_LEVEL = Level.FINEST;

    XmppTcpTransportModule(XmppTcpTransportModuleDescriptor moduleDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        super(moduleDescriptor, connectionInternal);
        this.tcpNioTransport = new XmppTcpNioTransport(connectionInternal);
        XmlPrettyPrinter incomingDebugPrettyPrinter = null;
        SmackDebugger debugger = connectionInternal.smackDebugger;
        if (debugger != null) {
            incomingDebugPrettyPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> debugger.incomingStreamSink(sb)).build();
            XmlPrettyPrinter outgoingDebugPrettyPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> debugger.outgoingStreamSink(sb)).build();
            this.outputDebugSplitter = new XmppXmlSplitter(outgoingDebugPrettyPrinter);
        }
        XmppXmlSplitter xmppXmlSplitter = new XmppXmlSplitter(65536, this.xmppElementCallback, (XmlPrinter)incomingDebugPrettyPrinter);
        this.splitter = new Utf8ByteXmppXmlSplitter(xmppXmlSplitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChannelSelected(SelectableChannel selectedChannel, SelectionKey selectedSelectionKey) {
        int newInterestedOps;
        block55: {
            assert (this.selectionKey == null || this.selectionKey == selectedSelectionKey);
            SocketChannel selectedSocketChannel = (SocketChannel)selectedChannel;
            newInterestedOps = 1;
            boolean newPendingOutputFilterData = false;
            if (!this.channelSelectedCallbackLock.tryLock()) {
                this.rejectedChannelSelectedCallbacks.incrementAndGet();
                return;
            }
            ++this.handledChannelSelectedCallbacks;
            long callbackBytesRead = 0L;
            long callbackBytesWritten = 0L;
            try {
                block54: {
                    boolean destinationAddressChanged = false;
                    boolean isLastPartOfElement = false;
                    TopLevelStreamElement currentlyOutgonigTopLevelStreamElement = null;
                    StringBuilder outgoingStreamForDebugger = null;
                    while (true) {
                        CharSequence nextCharSequence;
                        boolean moreDataAvailable;
                        boolean bl = moreDataAvailable = !isLastPartOfElement || !this.connectionInternal.outgoingElementsQueue.isEmpty();
                        if (this.filteredOutgoingBuffer != null || !this.networkOutgoingBuffers.isEmpty()) {
                            long bytesWritten;
                            if (this.filteredOutgoingBuffer != null) {
                                this.networkOutgoingBuffers.add(this.filteredOutgoingBuffer);
                                this.networkOutgoingBuffersBytes += (long)this.filteredOutgoingBuffer.remaining();
                                this.filteredOutgoingBuffer = null;
                                if (moreDataAvailable && this.networkOutgoingBuffersBytes < 8096L) continue;
                            }
                            ByteBuffer[] output = this.networkOutgoingBuffers.toArray(new ByteBuffer[this.networkOutgoingBuffers.size()]);
                            try {
                                bytesWritten = selectedSocketChannel.write(output);
                            }
                            catch (IOException e) {
                                this.handleReadWriteIoException(e);
                                break block54;
                            }
                            if (bytesWritten == 0L) {
                                newInterestedOps |= 4;
                            } else {
                                callbackBytesWritten += bytesWritten;
                                this.networkOutgoingBuffersBytes -= bytesWritten;
                                List<? extends Buffer> prunedBuffers = XmppTcpTransportModule.pruneBufferList(this.networkOutgoingBuffers);
                                for (Buffer buffer : prunedBuffers) {
                                    List<TopLevelStreamElement> sendElements = this.bufferToElementMap.remove(buffer);
                                    if (sendElements == null) continue;
                                    for (TopLevelStreamElement elementJustSend : sendElements) {
                                        this.connectionInternal.fireFirstLevelElementSendListeners(elementJustSend);
                                    }
                                }
                                if (callbackBytesWritten <= 0xA00000L) continue;
                                newInterestedOps |= 4;
                                ++this.callbackPreemtBecauseBytesWritten;
                            }
                            break block54;
                        }
                        if (this.outgoingBuffer != null || this.pendingOutputFilterData) {
                            this.pendingOutputFilterData = false;
                            if (this.outgoingBuffer != null) {
                                this.totalBytesWrittenBeforeFilter += (long)this.outgoingBuffer.remaining();
                                if (isLastPartOfElement) {
                                    assert (currentlyOutgonigTopLevelStreamElement != null);
                                    this.currentlyOutgoingElements.add(currentlyOutgonigTopLevelStreamElement);
                                }
                            }
                            ByteBuffer outputFilterInputData = this.outgoingBuffer;
                            this.outgoingBuffer = null;
                            ListIterator<XmppInputOutputFilter> it = this.connectionInternal.getXmppInputOutputFilterBeginIterator();
                            while (it.hasNext()) {
                                XmppInputOutputFilter.OutputResult outputResult;
                                XmppInputOutputFilter inputOutputFilter = it.next();
                                try {
                                    outputResult = inputOutputFilter.output(outputFilterInputData, isLastPartOfElement, destinationAddressChanged, moreDataAvailable);
                                }
                                catch (IOException e) {
                                    this.connectionInternal.notifyConnectionError(e);
                                    break block54;
                                }
                                newPendingOutputFilterData |= outputResult.pendingFilterData;
                                outputFilterInputData = outputResult.filteredOutputData;
                                if (outputFilterInputData == null) continue;
                                outputFilterInputData.flip();
                            }
                            this.filteredOutgoingBuffer = outputFilterInputData != null && outputFilterInputData.hasRemaining() ? outputFilterInputData : null;
                            if (this.filteredOutgoingBuffer == null && newPendingOutputFilterData) {
                                this.pendingWriteInterestAfterRead = true;
                            }
                            if (this.filteredOutgoingBuffer != null && isLastPartOfElement) {
                                this.bufferToElementMap.put(this.filteredOutgoingBuffer, new ArrayList<TopLevelStreamElement>(this.currentlyOutgoingElements));
                                this.currentlyOutgoingElements.clear();
                            }
                            if (!destinationAddressChanged) continue;
                            destinationAddressChanged = false;
                            continue;
                        }
                        if (this.outgoingCharSequenceIterator != null) {
                            SmackDebugger debugger;
                            nextCharSequence = this.outgoingCharSequenceIterator.next();
                            this.outgoingBuffer = UTF8.encode(nextCharSequence);
                            if (!this.outgoingCharSequenceIterator.hasNext()) {
                                this.outgoingCharSequenceIterator = null;
                                isLastPartOfElement = true;
                            } else {
                                isLastPartOfElement = false;
                            }
                            if ((debugger = this.connectionInternal.smackDebugger) == null) continue;
                            if (outgoingStreamForDebugger == null) {
                                outgoingStreamForDebugger = new StringBuilder();
                            }
                            outgoingStreamForDebugger.append(nextCharSequence);
                            if (!isLastPartOfElement) continue;
                            try {
                                this.outputDebugSplitter.append(outgoingStreamForDebugger);
                            }
                            catch (IOException e) {
                                throw new AssertionError((Object)e);
                            }
                            debugger.onOutgoingElementCompleted();
                            outgoingStreamForDebugger = null;
                            continue;
                        }
                        if (this.connectionInternal.outgoingElementsQueue.isEmpty()) break block54;
                        currentlyOutgonigTopLevelStreamElement = this.connectionInternal.outgoingElementsQueue.poll();
                        if (currentlyOutgonigTopLevelStreamElement instanceof Stanza) {
                            Stanza currentlyOutgoingStanza = (Stanza)currentlyOutgonigTopLevelStreamElement;
                            Jid currentDestinationAddress = currentlyOutgoingStanza.getTo();
                            destinationAddressChanged = !JidUtil.equals(this.lastDestinationAddress, currentDestinationAddress);
                            this.lastDestinationAddress = currentDestinationAddress;
                        }
                        if ((nextCharSequence = currentlyOutgonigTopLevelStreamElement.toXML("jabber:client")) instanceof XmlStringBuilder) {
                            XmlStringBuilder xmlStringBuilder = (XmlStringBuilder)nextCharSequence;
                            XmlEnvironment outgoingStreamXmlEnvironment = this.connectionInternal.getOutgoingStreamXmlEnvironment();
                            this.outgoingCharSequenceIterator = xmlStringBuilder.toList(outgoingStreamXmlEnvironment).iterator();
                        } else {
                            this.outgoingCharSequenceIterator = Collections.singletonList(nextCharSequence).iterator();
                        }
                        if (!$assertionsDisabled && this.outgoingCharSequenceIterator == null) break;
                    }
                    throw new AssertionError();
                }
                this.pendingOutputFilterData = newPendingOutputFilterData;
                if (!this.pendingWriteInterestAfterRead && this.pendingOutputFilterData) {
                    newInterestedOps |= 4;
                }
                while (true) {
                    int bytesRead;
                    if (callbackBytesRead > 0xA00000L) {
                        ++this.callbackPreemtBecauseBytesRead;
                        break;
                    }
                    this.incomingBuffer.clear();
                    try {
                        bytesRead = selectedSocketChannel.read(this.incomingBuffer);
                    }
                    catch (IOException e) {
                        this.handleReadWriteIoException(e);
                        this.totalBytesWritten += callbackBytesWritten;
                        this.totalBytesRead += callbackBytesRead;
                        this.channelSelectedCallbackLock.unlock();
                        return;
                    }
                    if (bytesRead < 0) {
                        LOGGER.finer("NIO read() returned " + bytesRead + " for " + this + ". This probably means that the TCP connection was terminated.");
                        return;
                    }
                    if (!this.pendingInputFilterData) {
                        if (bytesRead == 0) {
                            break;
                        }
                    } else {
                        this.pendingInputFilterData = false;
                    }
                    if (this.pendingWriteInterestAfterRead) {
                        this.pendingWriteInterestAfterRead = false;
                        newInterestedOps |= 4;
                    }
                    callbackBytesRead += (long)bytesRead;
                    ByteBuffer filteredIncomingBuffer = this.incomingBuffer;
                    ListIterator<XmppInputOutputFilter> it = this.connectionInternal.getXmppInputOutputFilterEndIterator();
                    while (it.hasPrevious()) {
                        ByteBuffer newFilteredIncomingBuffer;
                        filteredIncomingBuffer.flip();
                        try {
                            newFilteredIncomingBuffer = it.previous().input(filteredIncomingBuffer);
                        }
                        catch (IOException e) {
                            this.connectionInternal.notifyConnectionError(e);
                            this.totalBytesWritten += callbackBytesWritten;
                            this.totalBytesRead += callbackBytesRead;
                            this.channelSelectedCallbackLock.unlock();
                            return;
                        }
                        if (newFilteredIncomingBuffer == null) {
                            break block55;
                        }
                        filteredIncomingBuffer = newFilteredIncomingBuffer;
                    }
                    int bytesReadAfterFilter = filteredIncomingBuffer.flip().remaining();
                    this.totalBytesReadAfterFilter += (long)bytesReadAfterFilter;
                    try {
                        this.splitter.write(filteredIncomingBuffer);
                    }
                    catch (IOException e) {
                        this.connectionInternal.notifyConnectionError(e);
                        this.totalBytesWritten += callbackBytesWritten;
                        this.totalBytesRead += callbackBytesRead;
                        this.channelSelectedCallbackLock.unlock();
                        return;
                    }
                }
            }
            finally {
                this.totalBytesWritten += callbackBytesWritten;
                this.totalBytesRead += callbackBytesRead;
                this.channelSelectedCallbackLock.unlock();
            }
        }
        SmackReactor.SelectionKeyAttachment selectionKeyAttachment = this.selectionKeyAttachment;
        if (selectionKeyAttachment != null) {
            selectionKeyAttachment.resetReactorThreadRacing();
        }
        if (!this.connectionInternal.outgoingElementsQueue.isEmpty()) {
            this.setWriteInterestAfterChannelSelectedCallback.incrementAndGet();
            newInterestedOps |= 4;
        }
        this.connectionInternal.setInterestOps(this.selectionKey, newInterestedOps);
    }

    private void handleReadWriteIoException(IOException e) {
        if (e instanceof ClosedChannelException && !this.tcpNioTransport.isConnected()) {
            return;
        }
        this.connectionInternal.notifyConnectionError(e);
    }

    private void afterOutgoingElementsQueueModified() {
        SmackReactor.SelectionKeyAttachment selectionKeyAttachment = this.selectionKeyAttachment;
        if (selectionKeyAttachment != null && selectionKeyAttachment.isReactorThreadRacing()) {
            this.reactorThreadAlreadyRacing.incrementAndGet();
            return;
        }
        this.afterOutgoingElementsQueueModifiedSetInterestOps.incrementAndGet();
        this.connectionInternal.setInterestOps(this.selectionKey, 5);
    }

    @Override
    protected XmppTcpNioTransport getTransport() {
        return this.tcpNioTransport;
    }

    private EstablishingTcpConnectionState constructEstablishingTcpConnectionState(EstablishingTcpConnectionStateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        return new EstablishingTcpConnectionState(stateDescriptor, connectionInternal);
    }

    private EstablishTlsState constructEstablishingTlsState(EstablishTlsStateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        return new EstablishTlsState(stateDescriptor, connectionInternal);
    }

    private static void debugLogSslEngineResult(String operation, SSLEngineResult result) {
        if (!LOGGER.isLoggable(SSL_ENGINE_DEBUG_LOG_LEVEL)) {
            return;
        }
        LOGGER.log(SSL_ENGINE_DEBUG_LOG_LEVEL, "SSLEngineResult of " + operation + "(): " + result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callChannelSelectedCallback(boolean setPendingInputFilterData, boolean setPendingOutputFilterData) {
        SocketChannel channel = this.socketChannel;
        SelectionKey key = this.selectionKey;
        if (channel == null || key == null) {
            LOGGER.info("Not calling channel selected callback because the connection was eventually disconnected");
            return;
        }
        this.channelSelectedCallbackLock.lock();
        try {
            if (setPendingInputFilterData) {
                this.pendingInputFilterData = true;
            }
            if (setPendingOutputFilterData) {
                this.pendingOutputFilterData = true;
            }
            this.onChannelSelected(channel, key);
        }
        finally {
            this.channelSelectedCallbackLock.unlock();
        }
    }

    private void closeSocketAndCleanup() {
        SocketChannel socketChannel;
        SelectionKey selectionKey = this.selectionKey;
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        if ((socketChannel = this.socketChannel) != null) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.selectionKey = null;
        this.socketChannel = null;
        this.selectionKeyAttachment = null;
        this.remoteAddress = null;
    }

    private static List<? extends Buffer> pruneBufferList(Collection<? extends Buffer> buffers) {
        return CollectionUtil.removeUntil(buffers, b -> b.hasRemaining());
    }

    public Stats getStats() {
        return new Stats(this);
    }

    public static final class Stats
    extends XmppClientToServerTransport.Stats {
        public final long totalBytesWritten;
        public final long totalBytesWrittenBeforeFilter;
        public final double writeRatio;
        public final long totalBytesRead;
        public final long totalBytesReadAfterFilter;
        public final double readRatio;
        public final long handledChannelSelectedCallbacks;
        public final long setWriteInterestAfterChannelSelectedCallback;
        public final long reactorThreadAlreadyRacing;
        public final long afterOutgoingElementsQueueModifiedSetInterestOps;
        public final long rejectedChannelSelectedCallbacks;
        public final long totalCallbackRequests;
        public final long callbackPreemtBecauseBytesWritten;
        public final long callbackPreemtBecauseBytesRead;
        public final int sslEngineDelegatedTasks;
        public final int maxPendingSslEngineDelegatedTasks;
        private transient String toStringCache;

        private Stats(XmppTcpTransportModule connection) {
            this.totalBytesWritten = connection.totalBytesWritten;
            this.totalBytesWrittenBeforeFilter = connection.totalBytesWrittenBeforeFilter;
            this.writeRatio = (double)this.totalBytesWritten / (double)this.totalBytesWrittenBeforeFilter;
            this.totalBytesReadAfterFilter = connection.totalBytesReadAfterFilter;
            this.totalBytesRead = connection.totalBytesRead;
            this.readRatio = (double)this.totalBytesRead / (double)this.totalBytesReadAfterFilter;
            this.handledChannelSelectedCallbacks = connection.handledChannelSelectedCallbacks;
            this.setWriteInterestAfterChannelSelectedCallback = connection.setWriteInterestAfterChannelSelectedCallback.get();
            this.reactorThreadAlreadyRacing = connection.reactorThreadAlreadyRacing.get();
            this.afterOutgoingElementsQueueModifiedSetInterestOps = connection.afterOutgoingElementsQueueModifiedSetInterestOps.get();
            this.rejectedChannelSelectedCallbacks = connection.rejectedChannelSelectedCallbacks.get();
            this.totalCallbackRequests = this.handledChannelSelectedCallbacks + this.rejectedChannelSelectedCallbacks;
            this.callbackPreemtBecauseBytesRead = connection.callbackPreemtBecauseBytesRead;
            this.callbackPreemtBecauseBytesWritten = connection.callbackPreemtBecauseBytesWritten;
            this.sslEngineDelegatedTasks = connection.sslEngineDelegatedTasks;
            this.maxPendingSslEngineDelegatedTasks = connection.maxPendingSslEngineDelegatedTasks;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "Total bytes\nrecv: " + this.totalBytesRead + '\n' + "send: " + this.totalBytesWritten + '\n' + "recv-aft-filter: " + this.totalBytesReadAfterFilter + '\n' + "send-bef-filter: " + this.totalBytesWrittenBeforeFilter + '\n' + "read-ratio: " + this.readRatio + '\n' + "write-ratio: " + this.writeRatio + '\n' + "Events\ntotal-callback-requests: " + this.totalCallbackRequests + '\n' + "handled-channel-selected-callbacks: " + this.handledChannelSelectedCallbacks + '\n' + "rejected-channel-selected-callbacks: " + this.rejectedChannelSelectedCallbacks + '\n' + "set-write-interest-after-callback: " + this.setWriteInterestAfterChannelSelectedCallback + '\n' + "reactor-thread-already-racing: " + this.reactorThreadAlreadyRacing + '\n' + "after-queue-modified-set-interest-ops: " + this.afterOutgoingElementsQueueModifiedSetInterestOps + '\n' + "callback-preemt-because-bytes-read: " + this.callbackPreemtBecauseBytesRead + '\n' + "callback-preemt-because-bytes-written: " + this.callbackPreemtBecauseBytesWritten + '\n' + "ssl-engine-delegated-tasks: " + this.sslEngineDelegatedTasks + '\n' + "max-pending-ssl-engine-delegated-tasks: " + this.maxPendingSslEngineDelegatedTasks + '\n';
            return this.toStringCache;
        }
    }

    public static final class TlsStateStats {
        public final long wrapInBytes;
        public final long wrapOutBytes;
        public final double wrapRatio;
        public final long unwrapInBytes;
        public final long unwrapOutBytes;
        public final double unwrapRatio;
        private transient String toStringCache;

        private TlsStateStats(TlsState tlsState) {
            this.wrapOutBytes = tlsState.wrapOutBytes;
            this.wrapInBytes = tlsState.wrapInBytes;
            this.wrapRatio = (double)this.wrapOutBytes / (double)this.wrapInBytes;
            this.unwrapOutBytes = tlsState.unwrapOutBytes;
            this.unwrapInBytes = tlsState.unwrapInBytes;
            this.unwrapRatio = (double)this.unwrapInBytes / (double)this.unwrapOutBytes;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "wrap-in-bytes: " + this.wrapInBytes + '\n' + "wrap-out-bytes: " + this.wrapOutBytes + '\n' + "wrap-ratio: " + this.wrapRatio + '\n' + "unwrap-in-bytes: " + this.unwrapInBytes + '\n' + "unwrap-out-bytes: " + this.unwrapOutBytes + '\n' + "unwrap-ratio: " + this.unwrapRatio + '\n';
            return this.toStringCache;
        }
    }

    private final class TlsState
    implements XmppInputOutputFilter {
        private static final int MAX_PENDING_OUTPUT_BYTES = 8096;
        private final SmackTlsContext smackTlsContext;
        private final SSLEngine engine;
        private TlsHandshakeStatus handshakeStatus = TlsHandshakeStatus.initial;
        private SSLException handshakeException;
        private ByteBuffer myNetData;
        private ByteBuffer peerAppData;
        private final List<ByteBuffer> pendingOutputData = new ArrayList<ByteBuffer>();
        private int pendingOutputBytes;
        private ByteBuffer pendingInputData;
        private final AtomicInteger pendingDelegatedTasks = new AtomicInteger();
        private long wrapInBytes;
        private long wrapOutBytes;
        private long unwrapInBytes;
        private long unwrapOutBytes;

        private TlsState(SmackTlsContext smackTlsContext) throws IOException {
            this.smackTlsContext = smackTlsContext;
            String peerHost = ((XmppTcpTransportModule)XmppTcpTransportModule.this).connectionInternal.connection.getConfiguration().getXMPPServiceDomain().toString();
            this.engine = smackTlsContext.sslContext.createSSLEngine(peerHost, XmppTcpTransportModule.this.remoteAddress.getPort());
            this.engine.setUseClientMode(true);
            SSLSession session = this.engine.getSession();
            int applicationBufferSize = session.getApplicationBufferSize();
            int packetBufferSize = session.getPacketBufferSize();
            this.myNetData = ByteBuffer.allocateDirect(packetBufferSize);
            this.peerAppData = ByteBuffer.allocate(applicationBufferSize);
        }

        @Override
        public XmppInputOutputFilter.OutputResult output(ByteBuffer outputData, boolean isFinalDataOfElement, boolean destinationAddressChanged, boolean moreDataAvailable) throws SSLException {
            if (outputData != null) {
                this.pendingOutputData.add(outputData);
                this.pendingOutputBytes += outputData.remaining();
                if (moreDataAvailable && this.pendingOutputBytes < 8096) {
                    return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                }
            }
            ByteBuffer[] outputDataArray = this.pendingOutputData.toArray(new ByteBuffer[this.pendingOutputData.size()]);
            this.myNetData.clear();
            block12: while (true) {
                SSLEngineResult result;
                try {
                    result = this.engine.wrap(outputDataArray, this.myNetData);
                }
                catch (SSLException e) {
                    this.handleSslException(e);
                    throw e;
                }
                XmppTcpTransportModule.debugLogSslEngineResult("wrap", result);
                SSLEngineResult.Status engineResultStatus = result.getStatus();
                this.pendingOutputBytes -= result.bytesConsumed();
                if (engineResultStatus == SSLEngineResult.Status.OK) {
                    this.wrapInBytes += (long)result.bytesConsumed();
                    this.wrapOutBytes += (long)result.bytesProduced();
                    SSLEngineResult.HandshakeStatus handshakeStatus = this.handleHandshakeStatus(result);
                    switch (handshakeStatus) {
                        case NEED_UNWRAP: {
                            break;
                        }
                        case NEED_WRAP: 
                        case NEED_TASK: {
                            return new XmppInputOutputFilter.OutputResult(true, this.myNetData);
                        }
                    }
                }
                switch (engineResultStatus) {
                    case OK: {
                        XmppTcpTransportModule.pruneBufferList(this.pendingOutputData);
                        return new XmppInputOutputFilter.OutputResult(!this.pendingOutputData.isEmpty(), this.myNetData);
                    }
                    case CLOSED: {
                        this.pendingOutputData.clear();
                        return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                    }
                    case BUFFER_OVERFLOW: {
                        LOGGER.warning("SSLEngine status BUFFER_OVERFLOW, this is hopefully uncommon");
                        int outputDataRemaining = outputData != null ? outputData.remaining() : 0;
                        int newCapacity = (int)(1.3 * (double)outputDataRemaining);
                        if (newCapacity <= this.myNetData.capacity()) {
                            newCapacity = 2 * this.myNetData.capacity();
                        }
                        ByteBuffer newMyNetData = ByteBuffer.allocateDirect(newCapacity);
                        this.myNetData.flip();
                        newMyNetData.put(this.myNetData);
                        this.myNetData = newMyNetData;
                        continue block12;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new IllegalStateException("Buffer underflow as result of SSLEngine.wrap() should never happen");
                    }
                }
            }
        }

        @Override
        public ByteBuffer input(ByteBuffer inputData) throws SSLException {
            ByteBuffer accumulatedData;
            if (this.pendingInputData == null) {
                accumulatedData = inputData;
            } else {
                assert (this.pendingInputData != inputData);
                int accumulatedDataBytes = this.pendingInputData.remaining() + inputData.remaining();
                accumulatedData = ByteBuffer.allocate(accumulatedDataBytes);
                accumulatedData.put(this.pendingInputData).put(inputData).flip();
                this.pendingInputData = null;
            }
            this.peerAppData.clear();
            block13: while (true) {
                SSLEngineResult result;
                try {
                    result = this.engine.unwrap(accumulatedData, this.peerAppData);
                }
                catch (SSLException e) {
                    this.handleSslException(e);
                    throw e;
                }
                XmppTcpTransportModule.debugLogSslEngineResult("unwrap", result);
                SSLEngineResult.Status engineResultStatus = result.getStatus();
                if (engineResultStatus == SSLEngineResult.Status.OK) {
                    this.unwrapInBytes += (long)result.bytesConsumed();
                    this.unwrapOutBytes += (long)result.bytesProduced();
                    SSLEngineResult.HandshakeStatus handshakeStatus = this.handleHandshakeStatus(result);
                    switch (handshakeStatus) {
                        case NEED_TASK: {
                            this.addAsPendingInputData(accumulatedData);
                            return null;
                        }
                        case NEED_UNWRAP: {
                            continue block13;
                        }
                        case NEED_WRAP: {
                            this.addAsPendingInputData(accumulatedData);
                            XmppTcpTransportModule.this.connectionInternal.asyncGo(() -> XmppTcpTransportModule.this.callChannelSelectedCallback(false, true));
                            return null;
                        }
                    }
                }
                switch (engineResultStatus) {
                    case OK: {
                        if (accumulatedData.hasRemaining()) continue block13;
                        return this.peerAppData;
                    }
                    case CLOSED: {
                        return null;
                    }
                    case BUFFER_UNDERFLOW: {
                        this.addAsPendingInputData(accumulatedData);
                        return null;
                    }
                    case BUFFER_OVERFLOW: {
                        int applicationBufferSize = this.engine.getSession().getApplicationBufferSize();
                        assert (this.peerAppData.remaining() < applicationBufferSize);
                        this.peerAppData = ByteBuffer.allocate(applicationBufferSize);
                        continue block13;
                    }
                }
            }
        }

        private void addAsPendingInputData(ByteBuffer byteBuffer) {
            this.pendingInputData = ByteBuffer.allocate(byteBuffer.remaining());
            this.pendingInputData.put(byteBuffer).flip();
            XmppTcpTransportModule.this.pendingInputFilterData = this.pendingInputData.hasRemaining();
        }

        private SSLEngineResult.HandshakeStatus handleHandshakeStatus(SSLEngineResult sslEngineResult) {
            SSLEngineResult.HandshakeStatus handshakeStatus = sslEngineResult.getHandshakeStatus();
            switch (handshakeStatus) {
                case NEED_TASK: {
                    Runnable delegatedTask;
                    while ((delegatedTask = this.engine.getDelegatedTask()) != null) {
                        XmppTcpTransportModule.this.sslEngineDelegatedTasks++;
                        int currentPendingDelegatedTasks = this.pendingDelegatedTasks.incrementAndGet();
                        if (currentPendingDelegatedTasks > XmppTcpTransportModule.this.maxPendingSslEngineDelegatedTasks) {
                            XmppTcpTransportModule.this.maxPendingSslEngineDelegatedTasks = currentPendingDelegatedTasks;
                        }
                        Runnable wrappedDelegatedTask = () -> {
                            delegatedTask.run();
                            int wrappedCurrentPendingDelegatedTasks = this.pendingDelegatedTasks.decrementAndGet();
                            if (wrappedCurrentPendingDelegatedTasks == 0) {
                                XmppTcpTransportModule.this.callChannelSelectedCallback(true, true);
                            }
                        };
                        XmppTcpTransportModule.this.connectionInternal.asyncGo(wrappedDelegatedTask);
                    }
                    break;
                }
                case FINISHED: {
                    this.onHandshakeFinished();
                    break;
                }
            }
            SSLEngineResult.HandshakeStatus afterHandshakeStatus = this.engine.getHandshakeStatus();
            return afterHandshakeStatus;
        }

        private void handleSslException(SSLException e) {
            this.handshakeException = e;
            this.handshakeStatus = TlsHandshakeStatus.failed;
            XmppTcpTransportModule.this.connectionInternal.notifyWaitingThreads();
        }

        private void onHandshakeFinished() {
            this.handshakeStatus = TlsHandshakeStatus.successful;
            XmppTcpTransportModule.this.connectionInternal.notifyWaitingThreads();
        }

        private boolean isHandshakeFinished() {
            return this.handshakeStatus == TlsHandshakeStatus.successful || this.handshakeStatus == TlsHandshakeStatus.failed;
        }

        private void waitForHandshakeFinished() throws InterruptedException, CertificateException, SSLException, SmackException, XMPPException {
            XmppTcpTransportModule.this.connectionInternal.waitForConditionOrThrowConnectionException(() -> this.isHandshakeFinished(), "TLS handshake to finish");
            if (this.handshakeStatus == TlsHandshakeStatus.failed) {
                throw this.handshakeException;
            }
            assert (this.handshakeStatus == TlsHandshakeStatus.successful);
            if (this.smackTlsContext.daneVerifier != null) {
                this.smackTlsContext.daneVerifier.finish(this.engine.getSession());
            }
        }

        @Override
        public Object getStats() {
            return new TlsStateStats(this);
        }

        @Override
        public void closeInputOutput() {
            this.engine.closeOutbound();
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                LOGGER.log(Level.FINEST, "SSLException when closing inbound TLS session. This can likely be ignored if a possible truncation attack is suggested. You may want to ask your XMPP server vendor to implement a clean TLS session shutdown sending close_notify after </stream>", e);
            }
        }

        @Override
        public void waitUntilInputOutputClosed() throws IOException, CertificateException, InterruptedException, SmackException, XMPPException {
            this.waitForHandshakeFinished();
        }

        @Override
        public String getFilterName() {
            return "TLS (" + this.engine + ')';
        }
    }

    private static enum TlsHandshakeStatus {
        initial,
        initiated,
        successful,
        failed;

    }

    private final class EstablishTlsState
    extends State {
        private EstablishTlsState(EstablishTlsStateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) throws SmackException.SecurityRequiredByClientException, SmackException.SecurityRequiredByServerException {
            StartTls startTlsFeature = this.connectionInternal.connection.getFeature(StartTls.class);
            ConnectionConfiguration.SecurityMode securityMode = this.connectionInternal.connection.getConfiguration().getSecurityMode();
            switch (securityMode) {
                case required: 
                case ifpossible: {
                    if (startTlsFeature == null) {
                        if (securityMode == ConnectionConfiguration.SecurityMode.ifpossible) {
                            return new StateTransitionResult.TransitionImpossibleReason("Server does not announce support for TLS and we do not required it");
                        }
                        throw new SmackException.SecurityRequiredByClientException();
                    }
                    return null;
                }
                case disabled: {
                    if (startTlsFeature != null && startTlsFeature.required()) {
                        throw new SmackException.SecurityRequiredByServerException();
                    }
                    return new StateTransitionResult.TransitionImpossibleReason("TLS disabled in client settings and server does not require it");
                }
            }
            throw new AssertionError((Object)("Unknown security mode: " + (Object)((Object)securityMode)));
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws IOException, InterruptedException, SmackException, XMPPException {
            this.connectionInternal.sendAndWaitForResponse(StartTls.INSTANCE, TlsProceed.class, TlsFailure.class);
            SmackTlsContext smackTlsContext = this.connectionInternal.getSmackTlsContext();
            XmppTcpTransportModule.this.tlsState = new TlsState(smackTlsContext);
            this.connectionInternal.addXmppInputOutputFilter(XmppTcpTransportModule.this.tlsState);
            XmppTcpTransportModule.this.channelSelectedCallbackLock.lock();
            try {
                XmppTcpTransportModule.this.pendingOutputFilterData = true;
                XmppTcpTransportModule.this.tlsState.engine.beginHandshake();
                XmppTcpTransportModule.this.tlsState.handshakeStatus = TlsHandshakeStatus.initiated;
            }
            finally {
                XmppTcpTransportModule.this.channelSelectedCallbackLock.unlock();
            }
            this.connectionInternal.setInterestOps(XmppTcpTransportModule.this.selectionKey, 5);
            try {
                XmppTcpTransportModule.this.tlsState.waitForHandshakeFinished();
            }
            catch (CertificateException e) {
                throw new SmackException.SmackCertificateException(e);
            }
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("stream features after TLS established");
            return new TlsEstablishedResult(XmppTcpTransportModule.this.tlsState.engine);
        }

        @Override
        public void resetState() {
            XmppTcpTransportModule.this.tlsState = null;
        }
    }

    static final class EstablishTlsStateDescriptor
    extends StateDescriptor {
        private EstablishTlsStateDescriptor() {
            super(EstablishTlsState.class, "RFC 6120 \u00a7 5");
            this.addSuccessor(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.declarePrecedenceOver(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }

        @Override
        protected EstablishTlsState constructState(ModularXmppClientToServerConnectionInternal connectionInternal) {
            XmppTcpTransportModule tcpTransportModule = (XmppTcpTransportModule)connectionInternal.connection.getConnectionModuleFor(XmppTcpTransportModuleDescriptor.class);
            return tcpTransportModule.constructEstablishingTlsState(this, connectionInternal);
        }
    }

    public static final class TlsEstablishedResult
    extends StateTransitionResult.Success {
        private TlsEstablishedResult(SSLEngine sslEngine) {
            super("TLS established: " + sslEngine.getSession());
        }
    }

    public static final class TcpSocketConnectedResult
    extends StateTransitionResult.Success {
        private final InetSocketAddress remoteAddress;

        private TcpSocketConnectedResult(InetSocketAddress remoteAddress) {
            super("TCP connection established to " + remoteAddress);
            this.remoteAddress = remoteAddress;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    final class EstablishingTcpConnectionState
    extends State {
        private EstablishingTcpConnectionState(EstablishingTcpConnectionStateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws InterruptedException, IOException, SmackException, XMPPException {
            ConnectionAttemptState connectionAttemptState = new ConnectionAttemptState(this.connectionInternal, XmppTcpTransportModule.this.discoveredTcpEndpoints, this);
            StateTransitionResult.Failure failure = connectionAttemptState.establishTcpConnection();
            if (failure != null) {
                return failure;
            }
            XmppTcpTransportModule.this.socketChannel = connectionAttemptState.socketChannel;
            XmppTcpTransportModule.this.remoteAddress = (InetSocketAddress)XmppTcpTransportModule.this.socketChannel.socket().getRemoteSocketAddress();
            XmppTcpTransportModule.this.selectionKey = this.connectionInternal.registerWithSelector(XmppTcpTransportModule.this.socketChannel, 1, (x$0, x$1) -> XmppTcpTransportModule.this.onChannelSelected(x$0, x$1));
            XmppTcpTransportModule.this.selectionKeyAttachment = (SmackReactor.SelectionKeyAttachment)XmppTcpTransportModule.this.selectionKey.attachment();
            this.connectionInternal.setTransport(XmppTcpTransportModule.this.tcpNioTransport);
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("stream features after initial connection");
            return new TcpSocketConnectedResult(XmppTcpTransportModule.this.remoteAddress);
        }

        @Override
        public void resetState() {
            XmppTcpTransportModule.this.closeSocketAndCleanup();
        }
    }

    static final class EstablishingTcpConnectionStateDescriptor
    extends StateDescriptor {
        private EstablishingTcpConnectionStateDescriptor() {
            super(EstablishingTcpConnectionState.class);
            this.addPredeccessor(ModularXmppClientToServerConnection.LookupRemoteConnectionEndpointsStateDescriptor.class);
            this.addSuccessor(EstablishTlsStateDescriptor.class);
            this.addSuccessor(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }

        @Override
        protected EstablishingTcpConnectionState constructState(ModularXmppClientToServerConnectionInternal connectionInternal) {
            XmppTcpTransportModule tcpTransportModule = (XmppTcpTransportModule)connectionInternal.connection.getConnectionModuleFor(XmppTcpTransportModuleDescriptor.class);
            return tcpTransportModule.constructEstablishingTcpConnectionState(this, connectionInternal);
        }
    }

    final class XmppTcpNioTransport
    extends XmppClientToServerTransport {
        protected XmppTcpNioTransport(ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(connectionInternal);
        }

        @Override
        protected void resetDiscoveredConnectionEndpoints() {
            XmppTcpTransportModule.this.discoveredTcpEndpoints = null;
        }

        @Override
        protected List<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> lookupConnectionEndpoints() {
            assert (XmppTcpTransportModule.this.discoveredTcpEndpoints == null);
            ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> futures = new ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>>(2);
            SmackFuture.InternalSmackFuture tcpEndpointsLookupFuture = new SmackFuture.InternalSmackFuture();
            this.connectionInternal.asyncGo(() -> {
                RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result = RemoteXmppTcpConnectionEndpoints.lookup(this.connectionInternal.connection.getConfiguration());
                XmppClientToServerTransport.LookupConnectionEndpointsResult endpointsResult = result.discoveredRemoteConnectionEndpoints.isEmpty() ? new TcpEndpointDiscoveryFailed(result) : new DiscoveredTcpEndpoints(result);
                tcpEndpointsLookupFuture.setResult(endpointsResult);
            });
            futures.add(tcpEndpointsLookupFuture);
            if (((XmppTcpTransportModuleDescriptor)XmppTcpTransportModule.this.moduleDescriptor).isDirectTlsEnabled()) {
                throw new IllegalArgumentException("DirectTLS is not implemented yet");
            }
            return futures;
        }

        @Override
        protected void loadConnectionEndpoints(XmppClientToServerTransport.LookupConnectionEndpointsSuccess lookupConnectionEndpointsSuccess) {
            XmppTcpTransportModule.this.discoveredTcpEndpoints = (DiscoveredTcpEndpoints)lookupConnectionEndpointsSuccess;
        }

        @Override
        protected void afterFiltersClosed() {
            XmppTcpTransportModule.this.pendingInputFilterData = (XmppTcpTransportModule.this.pendingOutputFilterData = true);
            XmppTcpTransportModule.this.afterOutgoingElementsQueueModified();
        }

        @Override
        protected void disconnect() {
            XmppTcpTransportModule.this.closeSocketAndCleanup();
        }

        @Override
        protected void notifyAboutNewOutgoingElements() {
            XmppTcpTransportModule.this.afterOutgoingElementsQueueModified();
        }

        @Override
        public SSLSession getSslSession() {
            TlsState tlsState = XmppTcpTransportModule.this.tlsState;
            if (tlsState == null) {
                return null;
            }
            return tlsState.engine.getSession();
        }

        @Override
        public boolean isConnected() {
            SocketChannel socketChannel = XmppTcpTransportModule.this.socketChannel;
            if (socketChannel == null) {
                return false;
            }
            return socketChannel.isConnected();
        }

        @Override
        public boolean isTransportSecured() {
            TlsState tlsState = XmppTcpTransportModule.this.tlsState;
            return tlsState != null && tlsState.handshakeStatus == TlsHandshakeStatus.successful;
        }

        @Override
        public Stats getStats() {
            return XmppTcpTransportModule.this.getStats();
        }

        final class TcpEndpointDiscoveryFailed
        implements XmppClientToServerTransport.LookupConnectionEndpointsFailed {
            final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

            TcpEndpointDiscoveryFailed(RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result) {
                this.lookupFailures = result.lookupFailures;
            }
        }

        final class DiscoveredTcpEndpoints
        implements XmppClientToServerTransport.LookupConnectionEndpointsSuccess {
            final RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result;

            DiscoveredTcpEndpoints(RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result) {
                this.result = result;
            }
        }
    }
}

