/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.bind2.Bind2ModuleDescriptor;
import org.jivesoftware.smack.compress.provider.CompressedProvider;
import org.jivesoftware.smack.compress.provider.FailureProvider;
import org.jivesoftware.smack.compression.CompressionModuleDescriptor;
import org.jivesoftware.smack.compression.Java7ZlibInputOutputStream;
import org.jivesoftware.smack.compression.XmppCompressionManager;
import org.jivesoftware.smack.compression.zlib.ZlibXmppCompressionFactory;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.isr.InstantStreamResumptionModuleDescriptor;
import org.jivesoftware.smack.provider.BindIQProvider;
import org.jivesoftware.smack.provider.BodyElementProvider;
import org.jivesoftware.smack.provider.MessageSubjectElementProvider;
import org.jivesoftware.smack.provider.MessageThreadElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.provider.SaslChallengeProvider;
import org.jivesoftware.smack.provider.SaslFailureProvider;
import org.jivesoftware.smack.provider.SaslSuccessProvider;
import org.jivesoftware.smack.provider.TlsFailureProvider;
import org.jivesoftware.smack.provider.TlsProceedProvider;
import org.jivesoftware.smack.sasl.core.SASLAnonymous;
import org.jivesoftware.smack.sasl.core.SASLXOauth2Mechanism;
import org.jivesoftware.smack.sasl.core.SCRAMSHA1Mechanism;
import org.jivesoftware.smack.sasl.core.ScramSha1PlusMechanism;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public final class SmackInitialization {
    static final String SMACK_VERSION;
    private static final String DEFAULT_CONFIG_FILE = "org.jivesoftware.smack/smack-config.xml";
    private static final Logger LOGGER;

    public static void processConfigFile(InputStream cfgFileStream, Collection<Exception> exceptions) throws Exception {
        SmackInitialization.processConfigFile(cfgFileStream, exceptions, SmackInitialization.class.getClassLoader());
    }

    public static void processConfigFile(InputStream cfgFileStream, Collection<Exception> exceptions, ClassLoader classLoader) throws Exception {
        XmlPullParser parser = PacketParserUtils.getParserFor(cfgFileStream);
        XmlPullParser.Event eventType = parser.getEventType();
        do {
            if (eventType != XmlPullParser.Event.START_ELEMENT) continue;
            if (parser.getName().equals("startupClasses")) {
                SmackInitialization.parseClassesToLoad(parser, false, exceptions, classLoader);
                continue;
            }
            if (!parser.getName().equals("optionalStartupClasses")) continue;
            SmackInitialization.parseClassesToLoad(parser, true, exceptions, classLoader);
        } while ((eventType = parser.next()) != XmlPullParser.Event.END_DOCUMENT);
        CloseableUtil.maybeClose(cfgFileStream, LOGGER);
    }

    private static void parseClassesToLoad(XmlPullParser parser, boolean optional, Collection<Exception> exceptions, ClassLoader classLoader) throws Exception {
        XmlPullParser.Event eventType;
        String startName = parser.getName();
        do {
            String classToLoad;
            if ((eventType = parser.next()) != XmlPullParser.Event.START_ELEMENT || !"className".equals(parser.getName()) || SmackConfiguration.isDisabledSmackClass(classToLoad = parser.nextText())) continue;
            try {
                SmackInitialization.loadSmackClass(classToLoad, optional, classLoader);
            }
            catch (Exception e) {
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw e;
            }
        } while (eventType != XmlPullParser.Event.END_ELEMENT || !startName.equals(parser.getName()));
    }

    private static void loadSmackClass(String className, boolean optional, ClassLoader classLoader) throws Exception {
        Class<?> initClass;
        try {
            initClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            Level logLevel = optional ? Level.FINE : Level.WARNING;
            LOGGER.log(logLevel, "A startup class '" + className + "' could not be loaded.");
            if (!optional) {
                throw cnfe;
            }
            return;
        }
        if (SmackInitializer.class.isAssignableFrom(initClass)) {
            SmackInitializer initializer = (SmackInitializer)initClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            List<Exception> exceptions = initializer.initialize();
            if (exceptions == null || exceptions.size() == 0) {
                LOGGER.log(Level.FINE, "Loaded SmackInitializer " + className);
            } else {
                for (Exception e : exceptions) {
                    LOGGER.log(Level.SEVERE, "Exception in loadSmackClass", e);
                }
            }
        } else {
            LOGGER.log(Level.FINE, "Loaded " + className);
        }
    }

    static {
        InputStream configFileStream;
        String smackVersion;
        LOGGER = Logger.getLogger(SmackInitialization.class.getName());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(FileUtils.getStreamForClasspathFile("org.jivesoftware.smack/version", null), StandardCharsets.UTF_8));
            smackVersion = reader.readLine();
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.SEVERE, "Could not determine Smack version", e);
                smackVersion = "unknown";
            }
            catch (Throwable throwable) {
                CloseableUtil.maybeClose(reader, LOGGER);
                throw throwable;
            }
            CloseableUtil.maybeClose(reader, LOGGER);
        }
        CloseableUtil.maybeClose(reader, LOGGER);
        SMACK_VERSION = smackVersion;
        String disabledClasses = System.getProperty("smack.disabledClasses");
        if (disabledClasses != null) {
            String[] splitDisabledClasses;
            for (String s2 : splitDisabledClasses = disabledClasses.split(",")) {
                SmackConfiguration.disabledSmackClasses.add(s2);
            }
        }
        try {
            configFileStream = FileUtils.getStreamForClasspathFile(DEFAULT_CONFIG_FILE, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load Smack configuration file", e);
        }
        try {
            SmackInitialization.processConfigFile(configFileStream, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not parse Smack configuration file", e);
        }
        SmackConfiguration.addCompressionHandler(new Java7ZlibInputOutputStream());
        XmppCompressionManager.registerXmppCompressionFactory(ZlibXmppCompressionFactory.INSTANCE);
        try {
            if (Boolean.getBoolean("smack.debugEnabled")) {
                SmackConfiguration.DEBUG = true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not handle debugEnable property on Smack initialization", e);
        }
        SASLAuthentication.registerSASLMechanism(new SCRAMSHA1Mechanism());
        SASLAuthentication.registerSASLMechanism(new ScramSha1PlusMechanism());
        SASLAuthentication.registerSASLMechanism(new SASLXOauth2Mechanism());
        SASLAuthentication.registerSASLMechanism(new SASLAnonymous());
        ProviderManager.addIQProvider("bind", "urn:ietf:params:xml:ns:xmpp-bind", new BindIQProvider());
        ProviderManager.addExtensionProvider("body", "jabber:client", new BodyElementProvider());
        ProviderManager.addExtensionProvider("thread", "jabber:client", new MessageThreadElementProvider());
        ProviderManager.addExtensionProvider("subject", "jabber:client", new MessageSubjectElementProvider());
        ProviderManager.addNonzaProvider(SaslChallengeProvider.INSTANCE);
        ProviderManager.addNonzaProvider(SaslSuccessProvider.INSTANCE);
        ProviderManager.addNonzaProvider(SaslFailureProvider.INSTANCE);
        ProviderManager.addNonzaProvider(TlsProceedProvider.INSTANCE);
        ProviderManager.addNonzaProvider(TlsFailureProvider.INSTANCE);
        ProviderManager.addNonzaProvider(CompressedProvider.INSTANCE);
        ProviderManager.addNonzaProvider(FailureProvider.INSTANCE);
        SmackConfiguration.addModule(Bind2ModuleDescriptor.class);
        SmackConfiguration.addModule(CompressionModuleDescriptor.class);
        SmackConfiguration.addModule(InstantStreamResumptionModuleDescriptor.class);
        SmackConfiguration.smackInitialized = true;
    }
}

