/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.util.Maps;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names;
    private final JsScope parent;
    private static final Pattern FRESH_NAME_SUFFIX = Pattern.compile("[\\$_]\\d+$");

    public JsScope(JsScope parent2, @NotNull String description2) {
        if (description2 == null) {
            JsScope.$$$reportNull$$$0(0);
        }
        this.names = Collections.emptyMap();
        this.description = description2;
        this.parent = parent2;
    }

    protected JsScope(@NotNull String description2) {
        if (description2 == null) {
            JsScope.$$$reportNull$$$0(1);
        }
        this.names = Collections.emptyMap();
        this.description = description2;
        this.parent = null;
    }

    @NotNull
    public JsScope innerObjectScope(@NotNull String scopeName) {
        if (scopeName == null) {
            JsScope.$$$reportNull$$$0(2);
        }
        return new JsObjectScope(this, scopeName);
    }

    @NotNull
    public JsName declareName(@NotNull String identifier) {
        JsName name2;
        if (identifier == null) {
            JsScope.$$$reportNull$$$0(3);
        }
        JsName jsName = (name2 = this.findOwnName(identifier)) != null ? name2 : this.doCreateName(identifier);
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(4);
        }
        return jsName;
    }

    @NotNull
    public JsName declareFreshName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            JsScope.$$$reportNull$$$0(5);
        }
        assert (!suggestedName.isEmpty());
        String ident = this.getFreshIdent(suggestedName);
        JsName jsName = this.doCreateName(ident);
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(6);
        }
        return jsName;
    }

    @NotNull
    public static JsName declareTemporaryName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            JsScope.$$$reportNull$$$0(7);
        }
        assert (!suggestedName.isEmpty());
        return new JsName(suggestedName, true);
    }

    @NotNull
    public static JsName declareTemporary() {
        return JsScope.declareTemporaryName("tmp$");
    }

    @Nullable
    public final JsName findName(@NotNull String ident) {
        JsName name2;
        if (ident == null) {
            JsScope.$$$reportNull$$$0(8);
        }
        if ((name2 = this.findOwnName(ident)) == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name2;
    }

    public boolean hasOwnName(@NotNull String name2) {
        if (name2 == null) {
            JsScope.$$$reportNull$$$0(9);
        }
        return this.names.containsKey(name2);
    }

    private boolean hasName(@NotNull String name2) {
        if (name2 == null) {
            JsScope.$$$reportNull$$$0(10);
        }
        return this.hasOwnName(name2) || this.parent != null && this.parent.hasName(name2);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    public void copyOwnNames(JsScope other) {
        if (!other.names.isEmpty()) {
            this.names = new HashMap<String, JsName>(this.names);
            this.names.putAll(other.names);
        }
    }

    @NotNull
    public String getDescription() {
        String string2 = this.description;
        if (string2 == null) {
            JsScope.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(12);
        }
        JsName name2 = new JsName(ident, false);
        this.names = Maps.put(this.names, ident, name2);
        JsName jsName = name2;
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(13);
        }
        return jsName;
    }

    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(14);
        }
        return this.names.get(ident);
    }

    @NotNull
    protected String getFreshIdent(@NotNull String suggestedIdent) {
        if (suggestedIdent == null) {
            JsScope.$$$reportNull$$$0(15);
        }
        char sep = '_';
        String baseName = suggestedIdent;
        int counter = 0;
        Matcher matcher = FRESH_NAME_SUFFIX.matcher(suggestedIdent);
        if (matcher.find()) {
            String group = matcher.group();
            baseName = matcher.replaceAll("");
            sep = group.charAt(0);
            counter = Integer.valueOf(group.substring(1));
        }
        String freshName = suggestedIdent;
        while (this.hasName(freshName)) {
            freshName = baseName + sep + counter++;
        }
        String string2 = freshName;
        if (string2 == null) {
            JsScope.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ident";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedIdent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "declareName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "declareFreshName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFreshIdent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "innerObjectScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "declareName";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "declareFreshName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "declareTemporaryName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasOwnName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCreateName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findOwnName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFreshIdent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

