/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson.internal.bind;

import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.JsonDeserializer;
import org.jetbrains.kotlin.com.google.gson.JsonSerializer;
import org.jetbrains.kotlin.com.google.gson.TypeAdapter;
import org.jetbrains.kotlin.com.google.gson.TypeAdapterFactory;
import org.jetbrains.kotlin.com.google.gson.annotations.JsonAdapter;
import org.jetbrains.kotlin.com.google.gson.internal.ConstructorConstructor;
import org.jetbrains.kotlin.com.google.gson.internal.bind.TreeTypeAdapter;
import org.jetbrains.kotlin.com.google.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        Class<T> rawType = targetType.getRawType();
        JsonAdapter annotation2 = rawType.getAnnotation(JsonAdapter.class);
        if (annotation2 == null) {
            return null;
        }
        return this.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation2);
    }

    TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> type2, JsonAdapter annotation2) {
        TypeAdapter<?> typeAdapter;
        Object instance2 = constructorConstructor.get(TypeToken.get(annotation2.value())).construct();
        if (instance2 instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter<?>)instance2;
        } else if (instance2 instanceof TypeAdapterFactory) {
            typeAdapter = ((TypeAdapterFactory)instance2).create(gson, type2);
        } else if (instance2 instanceof JsonSerializer || instance2 instanceof JsonDeserializer) {
            JsonSerializer serializer2 = instance2 instanceof JsonSerializer ? (JsonSerializer)instance2 : null;
            JsonDeserializer deserializer2 = instance2 instanceof JsonDeserializer ? (JsonDeserializer)instance2 : null;
            typeAdapter = new TreeTypeAdapter(serializer2, deserializer2, gson, type2, null);
        } else {
            throw new IllegalArgumentException("Invalid attempt to bind an instance of " + instance2.getClass().getName() + " as a @JsonAdapter for " + type2.toString() + ". @JsonAdapter value must be a TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer.");
        }
        if (typeAdapter != null && annotation2.nullSafe()) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

