/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentDetailsSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

@ThreadSafe
public class ThisBuildOnlyComponentDetailsSerializer
implements ComponentDetailsSerializer {
    private final Long2ObjectMap<ComponentGraphResolveState> components = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());

    @Override
    public void writeComponentDetails(ComponentGraphResolveState component, boolean requireAllVariants, Encoder encoder) throws IOException {
        long instanceId = component.getInstanceId();
        this.components.putIfAbsent(instanceId, (Object)component);
        encoder.writeSmallLong(instanceId);
        encoder.writeBoolean(requireAllVariants);
    }

    @Override
    public void readComponentDetails(Decoder decoder, ResolvedComponentVisitor visitor) throws IOException {
        long instanceId = decoder.readSmallLong();
        ComponentGraphResolveState component = (ComponentGraphResolveState)this.components.get(instanceId);
        if (component == null) {
            throw new IllegalStateException("No component with id " + instanceId + " found.");
        }
        visitor.visitComponentDetails(component.getId(), component.getMetadata().getModuleVersionId());
        Object availableVariants = decoder.readBoolean() ? component.getAllSelectableVariantResults() : ImmutableList.of();
        visitor.visitComponentVariants((List<ResolvedVariantResult>)availableVariants);
    }
}

