/*
 * TOPCAT display device access
 */

#define XTOPCAT_IOSIZE			0x10000

#define XTOPCAT_PRIID_DISPLAY		0x39
#define XTOPCAT_SECID_TOPCAT		0x02
#define XTOPCAT_SECID_LRCATSEYE		0x05	/* low-res */
#define XTOPCAT_SECID_HRCCATSEYE	0x06	/* high-res color */
#define XTOPCAT_SECID_HRMCATSEYE	0x07	/* high-est mono */

/* TOPCAT registers (access is u_int8_t) */
#define XTOPCAT_PRIID			0x01	/* R: */
#define XTOPCAT_RESET			0x01	/* W: reset register */
#define XTOPCAT_BASEADDR		0x02	/* R: fb base address */
#define XTOPCAT_INTR			0x03	/* R: interrupt register */
#define XTOPCAT_FBWMSB			0x05	/* R: fb width MSB */ 
#define XTOPCAT_FBWLSB			0x07	/* R: fb width LSB */
#define XTOPCAT_FBHMSB			0x09	/* R: fb height MSB */
#define XTOPCAT_FBHLSB			0x0b	/* R: fb height LSB */
#define XTOPCAT_DPYWMSB			0x0d	/* R: display width MSB */
#define XTOPCAT_DPYWLSB			0x0f	/* R: display width LSB */
#define XTOPCAT_DPYHMSB			0x11	/* R: display height MSB */
#define XTOPCAT_DPYHLSB			0x13	/* R: display height LSB */
#define XTOPCAT_SECID			0x15	/* R: secondary id */
#define XTOPCAT_BITS			0x17

#define XTOPCAT_ROMOFFMSB		0x3b	/* R: ROM offset MSB */
#define XTOPCAT_ROMOFFLSB		0x3d	/* R: ROM offset LSB */

#define XTOPCAT_DEPTH			0x5b	/* R: colour depth */
#define XTOPCAT_FBOMSB			0x5d	/* R: fb offset MSB */
#define XTOPCAT_FBOLSB			0x5f	/* R: fb offset LSB */
#define XTOPCAT_VBLANK			0x4040	/* vertical blanking */
#define XTOPCAT_BUSY			0x4044	/* window move active */
#define XTOPCAT_VTRACE_REQ		0x4048	/* vert retact inter request */
#define XTOPCAT_MOVE_REQ		0x404c	/* window move inter request */
#define XTOPCAT_NBLANK			0x4080	/* display enable planes */
#define XTOPCAT_WEN			0x4088	/* write-enable plane */
#define XTOPCAT_REN			0x408c	/* read-enable plane */
#define XTOPCAT_FBEN			0x4090	/* fb write enable */
#define XTOPCAT_WMOVE			0x409c	/* start window move */
#define XTOPCAT_BLINK			0x40a0	/* enable blink planes */
#define XTOPCAT_ALTFRAME		0x40a8	/* enable alternate frame */
#define XTOPCAT_CURON			0x40ac	/* cursor control */
#define XTOPCAT_PRR			0x40ea	/* pixel replacement rule */
#define XTOPCAT_WMRR			0x40ef	/* move replacement rule */

/* register access is u_int16_t */
#define XTOPCAT_SOURCE_X		0x40f2	/* source x pixle # */
#define XTOPCAT_SOURCE_Y		0x40f6	/* source y pixel # */
#define XTOPCAT_DEST_X			0x40fa	/* dest x pixel # */
#define XTOPCAT_DEST_Y			0x40fe	/* dest y pixel # */
#define XTOPCAT_WWIDTH			0x4102	/* block mover pixel width */
#define XTOPCAT_WHEIGHT			0x4106	/* block mover pixel height */
#define XTOPCAT_RUG_CMDSTAT		0x4206	/* RUG command/status */
#define XTOPCAT_VB_SELECT		0x4510	/* vector/bitblt select */
#define XTOPCAT_TCTL			0x4512	/* three operand control */
#define XTOPCAT_ACTL			0x4514	/* bitblt mode */
#define XTOPCAT_PNCTL			0x4516	/* plane control */
#define XTOPCAT_CATSEYE_STATUS		0x4800	/* catseye status */
#define XTOPCAT_CMAP_BUSY		0x6002	/* color ram busy */
#define XTOPCAT_RDATA			0x60b2	/* colourmap red data */
#define XTOPCAT_GDATA			0x60b4	/* colourmap green data */
#define XTOPCAT_BDATA			0x60b6	/* colourmap blue data */
#define XTOPCAT_CINDEX			0x60b8	/* colourmap index */
#define XTOPCAT_PLANE_MASK		0x60ba	/* plane mask select */
#define XTOPCAT_STROBE			0x60f0	/* color map trigger */

/* pixel replacement rules */
#define RR_CLEAR		0x00
#define RR_COPY			0x03
#define RR_XOR			0x06
#define RR_COPYINVERTED		0x0c

/*
 * Offsets into the display ROM.
 */
#define ROM_FONTOFFMSB		0x4		/* font offset MSB */
#define ROM_FONTOFFLSB		0x6		/* font offset LSB */ 

/* font layout */
#define FONT_HEIGHT		0x0		/* font height */
#define FONT_WIDTH		0x2		/* font width */
#define FONT_DATA		0xA		/* font glyphs */
