/*	$NetBSD$	*/

/*
 * intio wired-device status codes are recognised
 */

#define XHIL_INTIO_STATAVAIL	0x05	/* HIL status in intio data register */
#define XHIL_INTIO_DATAAVAIL	0x06	/* HIL data in intio data register */

/* HIL status codes */
#define XHIL_STATUS_COMMAND	0x08	/* Start of original command */
#define XHIL_STATUS_POLLDATA	0x10	/* HIL poll data follows */
#define XHIL_STATUS_ERROR	0x80	/* HIL error */
#define XHIL_STATUS_RECONFIG	0x80	/* HIL has reconfigured */
#define XHIL_STATUS_MASK			\
	(XHIL_STATUS_COMMAND|XHIL_STATUS_POLLDATA|XHIL_STATUS_ERROR)

/*
 * HIL controller commands
 */

#define XHIL_SETARD		0xA0		/* set auto-repeat delay */
#define XHIL_SETARR		0xA2		/* set auto-repeat rate */
#define XHIL_SETTONE	   	0xA3		/* set tone generator */
#define XHIL_CNMT		0xB2		/* clear nmi */
#define XHIL_INTON		0x5C		/* Turn on interrupts. */
#define XHIL_INTOFF		0x5D		/* Turn off interrupts. */
#define XHIL_TRIGGER		0xC5		/* trigger command */
#define XHIL_STARTCMD		0xE0		/* start loop command */
#define XHIL_TIMEOUT		0xFE		/* timeout */
#define XHIL_READBUSY		0x02		/* internal "busy" register */
#define XHIL_RB_LOOPBUSY		0x04
#define XHIL_READKBDLANG	0x12		/* keyboard language code */
#define XHIL_READKBDSADR	0xF9
#define XHIL_WRITEKBDSADR	0xE9
#define XHIL_READLPSTAT		0xFA		/* loop status */
#define XHIL_WRITELPSTAT	0xEA
#define XHIL_LPS_DEVMASK		0x07	/* number of loop devices */
#define XHIL_LPS_CONFGOOD		0x08	/* reconfiguration worked */
#define XHIL_LPS_CONFFAIL		0x80	/* reconfiguration failed */
#define XHIL_READLPCTRL		0xFB		/* loop control */
#define XHIL_LPC_AUTOPOLL		0x01	/* enable auto-polling */
#define XHIL_LPC_NOERROR		0x02    /* don't report errors */
#define XHIL_LPC_NORECONF		0x04    /* don't report reconfigure */
#define XHIL_LPC_KBDCOOK		0x10    /* cook all keyboards */
#define XHIL_LPC_RECONF			0x80    /* reconfigure the loop */
#define XHIL_WRITELPCTRL	0xEB
