/*	$NetBSD$	*/

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/ioctl.h>

#include <arch/hp300/dev/xhilreg.h>
#include <arch/hp300/dev/xhilvar.h>

#include <arch/hp300/dev/hilreg.h>		/* XXX should go away */

#include <dev/wscons/wsconsio.h>
#include <dev/wscons/wsmousevar.h>

#include "wsmouse.h"

static int xhilmsmatch(struct device *, struct cfdata *, void *);
static void xhilmsattach(struct device *, struct device *, void *aux);

struct xhilms_softc {
	struct device sc_dev;
	struct device *sc_wsmousedev;
	int sc_enabled;
};

const struct cfattach xhilms_ca = {
	sizeof (struct xhilms_softc), xhilmsmatch, xhilmsattach, 
};

static int xhilms_handler(void *arg, u_int8_t *pkt, int len);

static int xhilms_enable(void *);
static int xhilms_ioctl(void *, u_long, caddr_t, int, struct proc *);
static void xhilms_disable(void *);

static const struct wsmouse_accessops xhilms_accessops = {
	xhilms_enable,
	xhilms_ioctl,
	xhilms_disable,
};

static int
xhilmsmatch(struct device *parent, struct cfdata *match, void *aux)
{
	struct xhil_attach_args *ha = aux;

	if (ha->ha_id != 0x02)
		return (0);

	return (1);
}

static void
xhilmsattach(struct device *parent, struct device *self, void *aux)
{
	struct xhilms_softc *sc = (struct xhilms_softc *)self;
	struct wsmousedev_attach_args waa;

	printf("\n");

	xhilregister(parent, xhilms_handler, sc, 0x02);

	waa.accessops = &xhilms_accessops;
	waa.accesscookie = sc;

	sc->sc_wsmousedev = config_found(self, &waa, wsmousedevprint);
}

static int
xhilms_handler(void *arg, u_int8_t *pkt, int len)
{
	struct xhilms_softc *sc = arg;
	int x, y;
	u_int btns, flags;

#if 0
	/* XXX these events are probably received by the keyboard */
	switch (pkt[1]>>1) {
	case 0x40:		/* left mouse button */
	case 0x41:		/* right mouse button */
	}
#endif

	flags = WSMOUSE_INPUT_DELTA;
	x = pkt[1];
	y = pkt[2];
	wsmouse_input(sc->sc_wsmousedev, btns, x, y, 0, flags);

	return (1);
}

static int
xhilms_enable(void *cookie)
{
	struct xhilms_softc *sc = cookie;
	sc->sc_enabled = 1;
	return (0);
}

static void
xhilms_disable(void *cookie)
{

	struct xhilms_softc *sc = cookie;
	sc->sc_enabled = 0;
}

static int
xhilms_ioctl(void *v, u_long cmd, caddr_t data, int flag, struct proc *p)
{
	switch(cmd) {
	case WSMOUSEIO_GTYPE:
		*(int *)data = WSMOUSE_TYPE_HP_HIL;
		return (0);
	}
	return (-1);
}
