#include <sys/types.h>
#include <dev/wscons/wsksymdef.h>
#include <dev/wscons/wsksymvar.h>

#define KC(n) KS_KEYCODE(n)

/* the basic US-style keymap */
static const keysym_t xhilkbd_keydesc_us[] = {
/*	pos		command		normal		shifted	*/
	KC(2),	KS_Cmd2,		KS_Meta_R,
	KC(3),	KS_Cmd2,		KS_Meta_L,
	KC(4),	KS_Cmd,			KS_Shift_R,
	KC(5),	KS_Cmd,			KS_Shift_L,
	KC(6),	KS_Cmd1,		KS_Control_L,
	KC(7),	KS_Cmd_Debugger,	KS_Pause,
	KC(8),				KS_KP_4,
	KC(9),				KS_KP_8,
	KC(10),				KS_KP_5,
	KC(11),				KS_KP_9,
	KC(12),				KS_KP_6,
	KC(13),				KS_KP_7,
	KC(14),				KS_KP_Separator,
	KC(15),				KS_KP_Enter,
	KC(16),				KS_KP_1,
	KC(17),				KS_KP_Divide,
	KC(18),				KS_KP_2,
	KC(19),				KS_KP_Add,
	KC(20),				KS_KP_3,
	KC(21),				KS_KP_Multiply,
	KC(22),				KS_KP_0,
	KC(23),				KS_KP_Subtract,
	KC(24),				KS_b,		KS_B,
	KC(25),				KS_v,		KS_V,
	KC(26),				KS_c,		KS_C,
	KC(27),				KS_x,		KS_X,
	KC(28),				KS_z,		KS_Z,
	KC(31),				KS_Escape,	KS_Delete,
	KC(33),				KS_KP_F2,
	KC(33),				KS_KP_F3,
	KC(36),				KS_KP_Decimal,
	KC(37),				KS_KP_F1,
	KC(38),				KS_KP_Tab,
	KC(39),				KS_KP_F4,
	KC(40),				KS_h,		KS_H,
	KC(41),				KS_g,		KS_G,
	KC(42),				KS_f,		KS_F,
	KC(43),				KS_d,		KS_D,
	KC(44),				KS_s,		KS_S,
	KC(45),				KS_a,		KS_A,
	KC(47),				KS_Caps_Lock,
	KC(48),				KS_u,		KS_U,
	KC(49),				KS_y,		KS_Y,
	KC(50),				KS_t,		KS_T,
	KC(51),				KS_r,		KS_R,
	KC(52),				KS_e,		KS_E,
	KC(53),				KS_w,		KS_W,
	KC(54),				KS_q,		KS_Q,
	KC(55),				KS_Tab,		KS_Tab,
	KC(56),				KS_7,		KS_ampersand,
	KC(57),				KS_6,		KS_acute,
	KC(58),				KS_5,		KS_percent,
	KC(59),				KS_4,		KS_dollar,
	KC(60),				KS_3,		KS_numbersign,
	KC(61),				KS_2,		KS_at,
	KC(62),				KS_1,		KS_exclam,
	KC(63),				KS_grave,	KS_asciitilde,
	KC(72),				KS_Menu,
	KC(73),	KS_Cmd_Screen3,		KS_f4,
	KC(74),	KS_Cmd_Screen2,		KS_f3,
	KC(75),	KS_Cmd_Screen1,		KS_f2,
	KC(76),	KS_Cmd_Screen0,		KS_f1,
	KC(78),				KS_Hold_Screen,
	KC(79),				KS_Return,	KS_Print_Screen,
/*	KC(80),				System/User */
	KC(81),	KS_Cmd_Screen4,		KS_f5,
	KC(82),	KS_Cmd_Screen5,		KS_f6,
	KC(83),	KS_Cmd_Screen6,		KS_f7,
	KC(84),	KS_Cmd_Screen7,		KS_f8,
/*	KC(86),				Clear Line */
/*	KC(87),				Clear Display */
	KC(88),				KS_8,		KS_asterisk,
	KC(89),				KS_9,		KS_parenleft,
	KC(90),				KS_0,		KS_parenright,
	KC(91),				KS_minus,	KS_underscore,
	KC(92),				KS_equal,	KS_plus,
	KC(93),				KS_BackSpace,
/*	KC(94),				Insert Line */
/*	KC(95),				Delete Line */
	KC(96),				KS_i,		KS_I,
	KC(97),				KS_o,		KS_O,
	KC(98),				KS_p,		KS_P,
	KC(99),				KS_bracketleft,	KS_braceleft,
	KC(100),			KS_bracketright,KS_braceright,
	KC(101),			KS_backslash,	KS_bar,
	KC(102),			KS_Insert,
	KC(103),			KS_Delete,
	KC(104),			KS_j,		KS_J,
	KC(105),			KS_k,		KS_K,
	KC(106),			KS_l,		KS_L,
	KC(107),			KS_semicolon,	KS_colon,
	KC(108),			KS_apostrophe,	KS_quotedbl,
	KC(109),			KS_Return,
	KC(111),			KS_Prior,
	KC(112),			KS_m,		KS_M,
	KC(113),			KS_comma,	KS_less,
	KC(114),			KS_period,	KS_greater,
	KC(115),			KS_slash,	KS_question,
	KC(117),			KS_Select,
	KC(119),			KS_Next,
	KC(120),			KS_n,		KS_N,
	KC(121),			KS_space,
	KC(124),			KS_Left,
	KC(125),			KS_Down,
	KC(126),			KS_Up,
	KC(127),			KS_Right,
};

/* the basic UK-style keymap */
static const keysym_t xhilkbd_keydesc_uk[] = {
/*	pos		command		normal		shifted	*/
};

/* the basic DK-style keymap */
static const keysym_t xhilkbd_keydesc_dk[] = {
/*	pos		command		normal		shifted	*/
};

#define KBD_MAP(name, base, map)	\
	{ name, base, sizeof(map)/sizeof(keysym_t), map }

const struct wscons_keydesc xhilkbd_keydesctab[] = {
	KBD_MAP(KB_US, 0, xhilkbd_keydesc_us),
	KBD_MAP(KB_UK, 0, xhilkbd_keydesc_uk),
	KBD_MAP(KB_DK, 0, xhilkbd_keydesc_dk),
	{0, 0, 0 ,0}
};
#undef KBD_MAP
#undef KC
