/*	$NetBSD$	*/

/*
 *  Registers for interface to the wired devices.
 */

/* HP3xx/4xx registers */
#define INTIO_DEV_3xx_PAD0	0
#define INTIO_DEV_3xx_DATA	1
#define INTIO_DEV_3xx_PAD1	2
#define INTIO_DEV_3xx_CMD	3
#define INTIO_DEV_3xx_STAT	3

/* HP7xx registers - XXX check these */
#define INTIO_DEV_7xx_RSTHOLD	0
#define INTIO_DEV_7xx_DATA	2048
#define INTIO_DEV_7xx_CMD	2049
#define INTIO_DEV_7xx_STAT	2049
#define INTIO_DEV_7xx_RSTREL	3072

/* HP8xx registers - XXX check these */
#define INTIO_DEV_8xx_DATA	3	
#define INTIO_DEV_8xx_CMD	11
#define INTIO_DEV_8xx_STAT	11

/* Status bits */
#define INTIO_DEV_DATA_READY	0x01
#define INTIO_DEV_BUSY		0x02
/* the top four bits specify a "service request" status code */
#define INTIO_DEV_SRSHIFT	4
#define INTIO_DEV_SRMASK	0x0f

/* Valid "service request" status codes */
#define INTIO_DEV_SR_DATAAVAIL	0x04
/* the specific wired device will overload the remaining bits */
