/*
 * Web Services on Devices
 * Internal header
 *
 * Copyright 2017-2018 Owen Rudge for CodeWeavers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef _WINE_WSDAPI_INTERNAL_H
#define _WINE_WSDAPI_INTERNAL_H

#include "winsock2.h"
#include "ws2tcpip.h"
#include "windef.h"
#include "winbase.h"
#include "objbase.h"
#include "wsdapi.h"
#include "wine/list.h"

#define WSD_MAX_TEXT_LENGTH    8192

/* discovery.c */

struct notificationSink
{
    struct list entry;
    IWSDiscoveryPublisherNotify *notificationSink;
};

typedef struct IWSDiscoveryPublisherImpl {
    IWSDiscoveryPublisher IWSDiscoveryPublisher_iface;
    LONG                  ref;
    IWSDXMLContext        *xmlContext;
    DWORD                 addressFamily;
    struct list           notificationSinks;
    BOOL                  publisherStarted;
} IWSDiscoveryPublisherImpl;

/* network.c */

BOOL init_networking(IWSDiscoveryPublisherImpl *impl);
void terminate_networking(IWSDiscoveryPublisherImpl *impl);
BOOL send_udp_multicast(IWSDiscoveryPublisherImpl *impl, char *data, int length, int max_initial_delay);

/* soap.c */

HRESULT send_hello_message(IWSDiscoveryPublisherImpl *impl, LPCWSTR id, ULONGLONG metadata_ver, ULONGLONG instance_id,
    ULONGLONG msg_num, LPCWSTR session_id, const WSD_NAME_LIST *types_list, const WSD_URI_LIST *scopes_list,
    const WSD_URI_LIST *xaddrs_list, const WSDXML_ELEMENT *hdr_any, const WSDXML_ELEMENT *ref_param_any,
    const WSDXML_ELEMENT *endpoint_ref_any, const WSDXML_ELEMENT *any);

/* xml.c */

LPWSTR duplicate_string(void *parentMemoryBlock, LPCWSTR value);
WSDXML_NAME *duplicate_name(void *parentMemoryBlock, WSDXML_NAME *name);

#endif
