CHANGELOG for 2.4.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.4 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.4.0...v2.4.1

* 2.4.9 (2014-09-03)

 * security #11832 CVE-2014-6072 (fabpot)
 * security #11831 CVE-2014-5245 (stof)
 * security #11830 CVE-2014-4931 (aitboudad, Jérémy Derussé)
 * security #11829 CVE-2014-6061 (damz, fabpot)
 * security #11828 CVE-2014-5244 (nicolas-grekas, larowlan)
 * bug #10197 [FrameworkBundle] PhpExtractor bugfix and improvements (mtibben)
 * bug #11772 [Filesystem] Add FTP stream wrapper context option to enable overwrite (Damian Sromek)
 * bug #11788 [Yaml] fixed mapping keys containing a quoted # (hvt, fabpot)
 * bug #11160 [DoctrineBridge] Abstract Doctrine Subscribers with tags (merk)
 * bug #11768 [ClassLoader] Add a __call() method to XcacheClassLoader (tstoeckler)
 * bug #11726 [Filesystem Component] mkdir race condition fix #11626 (kcassam)
 * bug #11677 [YAML] resolve variables in inlined YAML (xabbuh)
 * bug #11639 [DependencyInjection] Fixed factory service not within the ServiceReferenceGraph. (boekkooi)
 * bug #11778 [Validator] Fixed wrong translations for Collection constraints (samicemalone)
 * bug #11756 [DependencyInjection] fix @return anno created by PhpDumper (jakubkulhan)
 * bug #11711 [DoctrineBridge] Fix empty parameter logging in the dbal logger (jakzal)
 * bug #11692 [DomCrawler] check for the correct field type (xabbuh)
 * bug #11672 [Routing] fix handling of nullable XML attributes (xabbuh)
 * bug #11624 [DomCrawler] fix the axes handling in a bc way (xabbuh)
 * bug #11676 [Form] Fixed #11675 ValueToDuplicatesTransformer accept "0" value (Nek-)
 * bug #11695 [Validators] Fixed failing tests requiring ICU 52.1 which are skipped otherwise (webmozart)
 * bug #11529 [WebProfilerBundle] Fixed double height of canvas (hason)
 * bug #11641 [WebProfilerBundle ] Fix toolbar vertical alignment (blaugueux)
 * bug #11559 [Validator] Convert objects to string in comparison validators (webmozart)
 * feature #11510 [HttpFoundation] MongoDbSessionHandler supports auto expiry via configurable expiry_field (catchamonkey)
 * bug #11408 [HttpFoundation] Update QUERY_STRING when overrideGlobals (yguedidi)
 * bug #11633 [FrameworkBundle] add missing attribute to XSD (xabbuh)
 * bug #11601 [Validator] Allow basic auth in url when using UrlValidator. (blaugueux)
 * bug #11609 [Console] fixed style creation when providing an unknown tag option (fabpot)
 * bug #10914 [HttpKernel] added an analyze of environment parameters for built-in server (mauchede)
 * bug #11598 [Finder] Shell escape and windows support (Gordon Franke, gimler)
 * bug #11499 [BrowserKit] Fixed relative redirects for ambiguous paths (pkruithof)
 * bug #11516 [BrowserKit] Fix browser kit redirect with ports (dakota)
 * bug #11545 [Bundle][FrameworkBundle] built-in server: exit when docroot does not exist (xabbuh)
 * bug #11560 Plural fix (1emming)
 * bug #11558 [DependencyInjection] Fixed missing 'factory-class' attribute in XmlDumper output (kerdany)
 * bug #11548 [Component][DomCrawler] fix axes handling in Crawler::filterXPath() (xabbuh)
 * bug #11422 [DependencyInjection] Self-referenced 'service_container' service breaks garbage collection (sun)
 * bug #11428 [Serializer] properly handle null data when denormalizing (xabbuh)
 * bug #10687 [Validator] Fixed string conversion in constraint violations (eagleoneraptor, webmozart)
 * bug #11475 [EventDispatcher] don't count empty listeners (xabbuh)
 * bug #11436 fix signal handling in wait() on calls to stop() (xabbuh, romainneutron)
 * bug #11469  [BrowserKit] Fixed server HTTP_HOST port uri conversion (bcremer, fabpot)
 * bug #11425 Fix issue described in #11421 (Ben, ben-rosio)
 * bug #11423 Pass a Scope instance instead of a scope name when cloning a container in the GrahpvizDumper (jakzal)
 * bug #11448 [MonologBridge] fixed Console handler priorities (fabpot)
 * bug #11120 [Process] Reduce I/O load on Windows platform (romainneutron)
 * bug #11342 [Form] Check if IntlDateFormatter constructor returned a valid object before using it (romainneutron)
 * bug #11439 [ExpressionLanguage] Fixed double quoted string literals containing sharps (pylebecq)
 * bug #11411 [Validator] Backported #11410 to 2.3: Object initializers are called only once per object (webmozart)
 * bug #11403 [Translator][FrameworkBundle] Added @ to the list of allowed chars in Translator (takeit)
 * bug #11381  [Process] Use correct test for empty string in UnixPipes (whs, romainneutron)

* 2.4.8 (2014-07-15)

 * [Security] Forced validate of locales passed to the translator
 * bug #11278 Remove Spaceless Blocks From Twig Templates (chrisguitarguy)
 * feature #11367 [HttpFoundation] Fix to prevent magic bytes injection in JSONP responses... (CVE-2014-4671) (Andrew Moore)
 * bug #11386 Remove Spaceless Blocks from Twig Form Templates (chrisguitarguy)
 * bug #9719 [TwigBundle] fix configuration tree for paths (mdavis1982, cordoval)
 * bug #11244 [HttpFoundation] Remove body-related headers when sending the response, if body is empty (SimonSimCity)

* 2.4.7 (2014-07-08)

 * bug #11283 [SecurityBundle] Remove Expression Language services when the component is unavailable (thewilkybarkid)
 * bug #11238 [Translation] Added unescaping of ids in PoFileLoader (JustBlackBird)
 * bug #11194 [DomCrawler] Remove the query string and the anchor of the uri of a link (benja-M-1)
 * bug #11272 [Console] Make sure formatter is the same. (akimsko)
 * bug #11259 [Config] Fixed failed config schema loads due to libxml_disable_entity_loader usage (ccorliss)
 * bug #11234 [ClassLoader] fixed PHP warning on PHP 5.3 (fabpot)
 * bug #11179 [Process] Fix ExecutableFinder with open basedir (cs278)
 * bug #11242 [CssSelector] Refactored the CssSelector to remove the circular object graph (stof)
 * bug #11219 [DomCrawler] properly handle buttons with single and double quotes insid... (xabbuh)
 * bug #11220 [Components][Serializer] optional constructor arguments can be omitted during the denormalization process (xabbuh)
 * bug #11186 Added missing `break` statement (apfelbox)
 * bug #11169 [Console] Fixed notice in DialogHelper (florianv)
 * bug #11144 [HttpFoundation] Fixed Request::getPort returns incorrect value under IPv6 (kicken)
 * bug #10966 PHP Fatal error when getContainer method of ContainerAwareCommand has be... (kevinvergauwen)
 * bug #10981 [HttpFoundation] Fixed isSecure() check to be compliant with the docs (Jannik Zschiesche)
 * bug #11092 [HttpFoundation] Fix basic authentication in url with PHP-FPM (Kdecherf)
 * bug #10808 [DomCrawler] Empty select with attribute name="foo[]" bug fix (darles)
 * bug #11063 [HttpFoundation] fix switch statement (Tobion)
 * bug #11009 [HttpFoundation] smaller fixes for PdoSessionHandler (Tobion)
 * bug #11041 Remove undefined variable $e (skydiablo)

* 2.4.6 (2014-05-31)

 * bug #11014 [Validator] Remove property and method targets from the optional and required constraints (jakzal)
 * bug #10983 [DomCrawler] Fixed charset detection in html5 meta charset tag (77web)
 * Merge branch '2.3' into 2.4
 * bug #10979 Make rootPath part of regex greedy (artursvonda)
 * bug #10995 [TwigBridge][Trans]set %count% only on transChoice from the current context. (aitboudad)
 * bug #10987 [DomCrawler] Fixed a forgotten case of complex XPath queries (stof)

* 2.4.5 (2014-05-22)

 * bug #10849 [WIP][Finder] Fix wrong implementation on sortable callback comparator (ProPheT777)
 * bug #10929 [Process] Add validation on Process input (romainneutron)
 * bug #10958 [DomCrawler] Fixed filterXPath() chaining loosing the parent DOM nodes (stof, robbertkl)
 * bug #10953 [HttpKernel] fixed file uploads in functional tests without file selected (realmfoo)
 * bug #10947 [PropertyAccess] Fixed getValue() when accessing non-existing indices of ArrayAccess implementations (webmozart)
 * bug #10937 [HttpKernel] Fix "absolute path" when we look to the cache directory (BenoitLeveque)
 * bug #10894 [HttpKernel] removed absolute paths from the generated container (fabpot)
 * bug #10926 [DomCrawler] Fixed the initial state for options without value attribute (stof)
 * bug #10925 [DomCrawler] Fixed the handling of boolean attributes in ChoiceFormField (stof)
 * bug #10777 [Form] Automatically add step attribute to HTML5 time widgets to display seconds if needed (tucksaun)
 * bug #10909 [PropertyAccess] Fixed plurals for -ves words (csarrazi)
 * bug #10904 [HttpKernel] Replace sha1 with sha256 in recently added tests (jakzal)
 * bug #10899 Explicitly define the encoding. (jakzal)
 * bug #10897 [Console] Fix a console test (jakzal)
 * bug #10896 [HttpKernel] Fixed cache behavior when TTL has expired and a default "global" TTL is defined (alquerci, fabpot)
 * bug #10841 [DomCrawler] Fixed image input case sensitive (geoffrey-brier)
 * bug #10714 [Console]Improve formatter for double-width character (denkiryokuhatsuden)
 * bug #10872 [Form] Fixed TrimListenerTest as of PHP 5.5 (webmozart)
 * bug #10762 [BrowserKit] Allow URLs that don't contain a path when creating a cookie from a string (thewilkybarkid)
 * bug #10863 [Security] Add check for supported attributes in AclVoter (artursvonda)
 * bug #10833 [TwigBridge][Transchoice] set %count% from the current context. (aitboudad)
 * bug #10820 [WebProfilerBundle] Fixed profiler seach/homepage with empty token (tucksaun)
 * bug #10815 Fixed issue #5427 (umpirsky)
 * bug #10817 [Debug] fix #10313: FlattenException not found (nicolas-grekas)
 * bug #10803 [Debug] fix ErrorHandlerTest when context is not an array (nicolas-grekas)
 * bug #10801 [Debug] ErrorHandler: remove $GLOBALS from context in PHP5.3 fix #10292 (nicolas-grekas)
 * bug #10797 [HttpFoundation] Allow File instance to be passed to BinaryFileResponse (anlutro)
 * bug #10643 [TwigBridge] Removed strict check when found variables inside a translation (goetas)
 * bug #10605 [ExpressionLanguage] Strict in_array check in Parser.php (parnas)

* 2.4.4 (2014-04-27)

 * bug #10789 [Console] Fixed the rendering of exceptions on HHVM with a terminal width (stof)
 * bug #10773 [WebProfilerBundle ] Fixed an edge case on WDT loading (tucksaun)
 * bug #10784 [Security] removed $csrfTokenManager type hint from SimpleFormAuthenticationListener constructor argument (choonge)
 * bug #10763 [Process] Disable TTY mode on Windows platform (romainneutron)
 * bug #10772 [Finder] Fix ignoring of unreadable dirs in the RecursiveDirectoryIterator (jakzal)
 * bug #10757 [Process] Setting STDIN while running should not be possible (romainneutron)
 * bug #10749 Fixed incompatibility of x509 auth with nginx (alcaeus)
 * bug #10735 [Translation] [PluralizationRules] Little correction for case 'ar' (klyk50)
 * bug #10720 [HttpFoundation] Fix DbalSessionHandler  (Tobion)
 * bug #10721 [HttpFoundation] status 201 is allowed to have a body (Tobion)
 * bug #10728 [Process] Fix #10681, process are failing on Windows Server 2003 (romainneutron)
 * bug #10733 [DomCrawler] Textarea value should default to empty string instead of null. (Berdir)
 * bug #10723 [Security] fix DBAL connection typehint (Tobion)
 * bug #10715 [Debug] Fixed ClassNotFoundFatalErrorHandler on windows. (lyrixx)
 * bug #10700 Fixes various inconsistencies in the code (fabpot)
 * bug #10697 [Translation] Make IcuDatFileLoader/IcuResFileLoader::load invalid resource compatible with HHVM. (idn2104)
 * bug #10652 [HttpFoundation] fix PDO session handler under high concurrency (Tobion)
 * bug #10690 [Validator] Fix hack for nested Collection/All losing context (GromNaN)
 * bug #10669 [Profiler] Prevent throwing fatal errors when searching timestamps or invalid dates (stloyd)
 * bug #10670 [Templating] PhpEngine should propagate charset to its helpers (stloyd)
 * bug #10665 [DependencyInjection] Fix ticket #10663 - Added setCharset method call to PHP templating engine (koku)
 * bug #10654 Changed the typehint of the EsiFragmentRenderer to the interface (stof)
 * bug #10649 [BrowserKit] Fix #10641 : BrowserKit is broken when using ip as host (romainneutron)

* 2.4.3 (2014-04-04)

 * bug #10586 Fixes URL validator to accept single part urls (merk)
 * bug #10591 [Form] Buttons are now disabled if their containing form is disabled (webmozart)
 * bug #10587 [Process] Fix Process test suite (romainneutron)
 * bug #10579 HHVM fixes (fabpot)
 * bug #10564 fixed the profiler when an uncalled listener throws an exception when instantiated (fabpot)
 * bug #10568 [Form] Fixed hashing of choice lists containing non-UTF-8 characters (webmozart)
 * bug #10536 Avoid levenshtein comparison when using ContainerBuilder. (catch56)
 * bug #10549 Fixed server values in BrowserKit (fabpot)
 * bug #10540 [HttpKernel] made parsing controllers more robust (fabpot)
 * bug #10545 [DependencyInjection] Fixed YamlFileLoader imports path (jrnickell)
 * bug #10523 [Debug] Check headers sent before sending PHP response (GromNaN)
 * bug #10363 [FrameworkBundle][Console] Fix issue #10345 container:debug --parameter="" not working anymore (FineWolf)
 * bug #10275 [Validator] Fixed ACE domain checks on UrlValidator (#10031) (aeoris)
 * bug #10123 handle array root element (greg0ire)
 * bug #10532 Fixed regression when using Symfony on filesystems without chmod support (fabpot)
 * bug #10502 [HttpKernel] Fix #10437: Catch exceptions when reloading a no-cache request (romainneutron)
 * bug #10493  Fix libxml_use_internal_errors and libxml_disable_entity_loader usage (romainneutron)
 * bug #9784 [HttpFoundation] Removed ini check to make Uploadedfile work on Google App Engine (micheleorselli)
 * bug #10416 [Form] Allow options to be grouped by objects (felds)
 * bug #10410 [Form] Fix "Array was modified outside object" in ResizeFormListener. (Chekote)
 * bug #10494 [Validator] Minor fix in IBAN validator (sprain)
 * bug #10491 Fixed bug that incorrectly causes the "required" attribute to be omitted from select even though it contains the "multiple" attribute (fabpot)
 * bug #10479 [Process] Fix escaping on Windows (romainneutron)
 * bug #10480 [Process] Fixed fatal errors in getOutput and getErrorOutput when process was not started  (romainneutron)
 * bug #10420 [Process] Make Process::start non-blocking on Windows platform (romainneutron)
 * bug #10455 [Process] Fix random failures in test suite on TravisCI (romainneutron)
 * bug #10448 [Process] Fix quoted arguments escaping (romainneutron)
 * bug #10444 [DomCrawler] Fixed incorrect value name conversion in getPhpValues() and getPhpFiles() (romainneutron)
 * bug #10423 [Config] XmlUtils::convertDomElementToArray does not handle '0' (bendavies)
 * bug #10153 [Process] Fixed data in pipe being truncated if not read before process termination (astephens25)
 * bug #10429 [Process] Fix #9160 : escaping an argument with a trailing backslash on windows fails (romainneutron)
 * bug #10412 [Process] Fix process status in TTY mode (romainneutron)
 * bug #10382 10158 get vary multiple (bbinkovitz)
 * bug #10251 [Form] Fixes empty file-inputs getting treated as extra field. (jenkoian)
 * bug #10284 [HttpKernel] Fix issue #10209 (stephpy)
 * bug #10351 [HttpKernel] fix stripComments() normalizing new-lines (sstok)
 * bug #10348 Update FileLoader to fix issue #10339 (msumme)
 * bug #10306 [Serializer] Throw exception when unable to normalize embedded object (gquemener)
 * bug #10338 [ExpressionLanguage] Fixed evaluation of short circuit operators (florianv)
 * bug #10146 [WebProfilerBundle] fixed parsing Mongo DSN and added Test for it (malarzm)
 * bug #10299 [Finder] () is also a valid delimiter (WouterJ)
 * bug #10255 [FrameworkBundle] Fixed wrong redirect url if path contains some query parameters (pulzarraider)
 * bug #10285 Bypass sigchild detection if phpinfo is not available (Seldaek)
 * bug #10269 [Form] Revert "Fix "Array was modified outside object" in ResizeFormListener." (norzechowicz)
 * bug #10231 [Console] removed problematic regex (fabpot)
 * bug #10245 [DomCrawler] Added support for <area> tags to be treated as links (shamess)
 * bug #10232 [Form] Fix "Array was modified outside object" in ResizeFormListener. (Chekote)

* 2.4.2 (2014-02-12)

 * bug #10215 [Routing] reduced recursion in dumper (arnaud-lb)
 * bug #10207 [DomCrawler] Fixed filterXPath() chaining (robbertkl)
 * bug #10205 [DomCrawler] Fixed incorrect handling of image inputs (robbertkl)
 * bug #10191 [HttpKernel] fixed wrong reference in TraceableEventDispatcher (fabpot)
 * bug #10195 [Debug] Fixed recursion level incrementing in FlattenException::flattenArgs(). (sun)
 * bug #10151 [Form] Update DateTime objects only if the actual value has changed (peterrehm)
 * bug #10140 allow the TextAreaFormField to be used with valid/invalid HTML (dawehner)
 * bug #10131 added lines to exceptions for the trans and transchoice tags (fabpot)
 * bug #10002 Routing condition bugfix (marco-jantke)
 * bug #10119 [Validator] Minor fix in XmlFileLoader (florianv)
 * bug #10078 [BrowserKit] add non-standard port to HTTP_HOST server param (kbond)
 * bug #10095 [Security] fix DI for SimpleFormAuthenticationListener (Tobion)
 * bug #10091 [Translation] Update PluralizationRules.php (guilhermeblanco)
 * bug #10053 [Form] fixed allow render 0 numeric input value (dczech)
 * bug #10067 [HttpKernel] allow null value in fragment handler (kbond)
 * bug #10042 [Expression Language] fix foo[index] (schokocappucino)
 * bug #10033 [HttpKernel] Bugfix - Logger Deprecation Notice (Rican7)
 * bug #10023 [FrameworkBundle] Thrown an HttpException instead returning a Response in RedirectController::redirectAction() (jakzal)
 * bug #9985 Prevent WDT from creating a session (mvrhov)
 * bug #10010 [Twig Bridge] Fixed bug in ExpressionExtension (ricbra)
 * bug #10000 [Console] Fixed the compatibility with HHVM (stof)
 * bug #9979 [Doctrine Bridge][Validator] Fix for null values in assosiated properties when using UniqueEntityValidator (vpetrovych)
 * bug #9983 [TwigBridge] Update min. version of Twig (stloyd)
 * bug #9970 [CssSelector] fixed numeric attribute issue (jfsimon)
 * bug #9747 [DoctrineBridge] Fix: Add type detection. Needed by pdo_dblib (iamluc)
 * bug #9962 [Process] Fix #9861 : Revert TTY mode (romainneutron)
 * bug #9960 [Form] Update minimal requirement in composer.json (stloyd)
 * bug #9952 [Translator] Fix Empty translations with Qt files (vlefort)
 * bug #9957 [Console] Fixed command name guessing if an alternative is an alias (jakzal)
 * bug #9948 [WebProfilerBundle] Fixed profiler toolbar icons for XHTML. (rafalwrzeszcz)
 * bug #9933 Propel1 exception message (jaugustin)
 * bug #9949 [BrowserKit] Throw exception on invalid cookie expiration timestamp (anlutro)

* 2.4.1 (2014-01-05)

 * bug #9938 [Process] Add support SAPI cli-server (peter-gribanov)
 * bug #9940 [EventDispatcher] Fix hardcoded listenerTag name in error message (lemoinem)
 * bug #9923 [DoctrineBridge] Fixed an issue with DoctrineParserCache (florianv)
 * bug #9908 [HttpFoundation] Throw proper exception when invalid data is passed to JsonResponse class (stloyd)
 * bug #9902 [Security] fixed pre/post authentication checks (fabpot)
 * bug #9910 fixed missing use statements (fabpot)
 * bug #9895 [Intl] Added round support for ROUND_CEILING, ROUND_FLOOR, ROUND_DOWN, ROUND_UP (pamil)
 * bug #9899 [Filesystem | WCM] 9339 fix stat on url for filesystem copy (cordoval)
 * bug #9589 [DependencyInjection] Fixed #9020 - Added support for collections in service#parameters (lavoiesl)
 * bug #9889 [Console] fixed column width when using the Table helper with some decoration in cells (fabpot)
 * bug #9323 [DomCrawler]fix #9321 Crawler::addHtmlContent add gbk encoding support (bronze1man)
 * bug #8997 [Security] Fixed problem with losing ROLE_PREVIOUS_ADMIN role. (pawaclawczyk)
 * bug #9557 [DoctrineBridge] Fix for cache-key conflict when having a \Traversable as choices (DRvanR)
 * bug #9879 [Security] Fix ExceptionListener to catch correctly AccessDeniedException if is not first exception (fabpot)
 * bug #9885 [Dependencyinjection] Fixed handling of inlined references in the AnalyzeServiceReferencesPass (fabpot)
 * bug #9884 [DomCrawler] Fixed creating form objects from named form nodes (jakzal)
 * bug #9882 Add support for HHVM in the getting of the PHP executable (fabpot)
 * bug #9850 [Validator] Fixed IBAN validator with 0750447346 value (stewe)
 * bug #9865 [Validator] Fixes message value for objects (jongotlin)
 * bug #9441 [Form][DateTimeToArrayTransformer] Check for hour, minute & second validity (egeloen)
 * bug #9720 [FrameworkBundle] avoid tables to have apparently long blank line breaks and be too far appart for long nested array params (cordoval)
 * bug #9867 #9866 [Filesystem] Fixed mirror for symlinks (COil)
 * bug #9806 [Security] Fix parent serialization of user object (ddeboer)
 * bug #9834 [DependencyInjection] Fixed support for backslashes in service ids. (jakzal)
 * bug #9826 fix #9356 [Security] Logger should manipulate the user reloaded from provider (matthieuauger)
 * feature #9775 [FrameworkBundle] Added extra details in XMLDescriptor to improve container description (Exelenz)
 * bug #9771 Crawler default namespace fix (crudecki)
 * bug #9769 [BrowserKit] fixes #8311 CookieJar is totally ignorant of RFC 6265 edge cases (jzawadzki)
 * bug #9697 [Config] fix 5528 let ArrayNode::normalizeValue respect order of value array provided (cordoval)
 * bug #9701 [Config] fix #7243 allow 0 as arraynode name (cordoval)
 * bug #9795 [Form] Fixed issue in BaseDateTimeTransformer when invalid timezone cause Trans... (tyomo4ka)
 * bug #9714 [HttpFoundation] BinaryFileResponse should also return 416 or 200 on some range-requets (SimonSimCity)
 * bug #9601 [Routing] Remove usage of deprecated _scheme requirement (Danez)
 * bug #9489 [DependencyInjection] Add normalization to tag options (WouterJ)
 * bug #9135 [Form] [Validator] fix maxLength guesser (franek)
 * bug #9790 [Filesystem] Changed the mode for a target file in copy() to be write only (jakzal)
 * bug #9758 [Console] fixed TableHelper when cell value has new line (k-przybyszewski)
 * bug #9760 [Routing] Fix router matching pattern against multiple hosts (karolsojko)
 * bug #9768 [FrameworkBundle] Fixed bug in XMLDescriptor (Exelenz)
 * bug #9700 [ExpressionLanguage] throw exception when parameters contain expressions (aitboudad)
 * bug #9674 [Form] rename validators.ua.xlf to validators.uk.xlf (craue)
 * bug #9722 [Validator]Fixed getting wrong msg when value is an object in Exception (aitboudad)
 * bug #9750 allow TraceableEventDispatcher to reuse event instance in nested events (evillemez)
 * bug #9718 [validator] throw an exception if isn't an instance of ConstraintValidatorInterface. (aitboudad)
 * bug #9716 Reset the box model to content-box in the web debug toolbar (stof)
 * bug #9711 [FrameworkBundle] Allowed "0" as a checkbox value in php templates (jakzal)

* 2.4.0 (2013-12-03)

 * bug #9673 Fixed BC break in csrf protection (WouterJ)
 * bug #9665 [Bridge/Doctrine] ORMQueryBuilderLoader - handled the scenario when no entity manager is passed with closure query builder (jakzal)
 * bug #9662 [FrameworkBundle] Enabled csrf_protection by default if form.csrf_protection is enabled (bschussek)
 * bug #9656 [DoctrineBridge] normalized class names in the ORM type guesser (fabpot)
 * bug #9647 use the correct class name to retrieve mapped class' metadata and reposi... (xabbuh)
 * bug #9648 [Debug] ensured that a fatal PHP error is actually fatal after being handled by our error handler (fabpot)
 * bug #9643 [WebProfilerBundle] Fixed js escaping in time.html.twig (hason)
 * bug #9641 [Debug] Avoid notice from being "eaten" by fatal error. (fabpot)
 * bug #9639 Modified guessDefaultEscapingStrategy to not escape txt templates (fabpot)
 * bug #9314 [Form] Fix DateType for 32bits computers. (WedgeSama)
 * bug #9443 [FrameworkBundle] Fixed the registration of validation.xml file when the form is disabled (hason)
 * bug #9625 [HttpFoundation] Do not return an empty session id if the session was closed (Taluu)
 * bug #9621 [ExpressionLanguage] fixed lexing expression ending with spaces (fabpot)
 * bug #9637 [Validator] Replaced inexistent interface (jakzal)
 * bug #9628 [HttpKernel] Fix profiler event-listener usage outside request stack context (romainneutron)
 * bug #9624 [Console] Fix undefined offset when formatting namespace suggestions (GromNaN)
 * bug #9605 Adjusting CacheClear Warmup method to namespaced kernels (rdohms)
 * bug #9617 [HttpKernel] Http kernel regression fix (hhamon)
 * bug #9610 Container::camelize also takes backslashes into consideration (ondrejmirtes)

* 2.4.0-RC1 (2013-11-25)

 * bug #9607 [HttpKernel] Fix a bug when using the kernel property in overridden method Client::setServerParameters() (gnutix)
 * bug #9597 [Security] Typos in Security's ExpressionLanguage (ovrflo)
 * feature #9587 [SecurityBundle] Added csrf_token_generator and csrf_token_id as new (shieldo)
 * feature #9578 [DomCrawler] Fixes `attr` method returning empty string for missing attributes (aik099)
 * bug #9565 [Debug] Fixed ClassNotFoundFatalErrorHandler which could cause a fatal error (jakzal)
 * bug #9525 Cache Warmup Breaks Namespaced Kernel (rdohms)
 * bug #9447 [BrowserKit] fixed protocol-relative url redirection (jong99)
 * bug #9535 No Entity Manager defined exception (armetiz)
 * bug #9485 [Acl] Fix for issue #9433 (guilro)
 * bug #9516 [AclProvider] Fix incorrect behavior when partial results returned from cache (superdav42)
 * feature #9546 [FrameworkBundle] use the new request_stack service in the GlobalVariables object (hhamon)
 * bug #9566 [Console] Revert BC-break for verbose option value (chEbba)
 * bug #9553 [FrameworkBundle] use the new request_stack service to get the Request object in the base Controller class (hhamon)
 * feature #9541 [Translation] make IdentityTranslater consistent with normal translator (Tobion)
 * bug #9536 [FrameworkBundle] Update 2 dependencies (currently broken) (asm89)
 * bug #9352 [Intl] make currency bundle merge fallback locales when accessing data, ... (shieldo)
 * bug #9537 [FrameworkBundle] Fix mistake in translation's service definition. (phpmike)
 * bug #9529 [ExpressionLanguage] Fixed conflict between punctation and range (WouterJ)
 * bug #9367 [Process] Check if the pipe array is empty before calling stream_select() (jfposton)
 * bug #9211 [Form] Fixed memory leak in FormValidator (bschussek)
 * bug #9469 [Propel1] re-factor Propel1 ModelChoiceList (havvg)
 * bug #9499 Request::overrideGlobals() may call invalid ini value (denkiryokuhatsuden)
 * feature #9494 made Router implement RequestMatcherInterface (fabpot)
 * bug #9420 [Console][ProgressHelper] Fix ProgressHelper redraw when redrawFreq is greater than 1 (giosh94mhz)
 * bug #9212 [Validator] Force Luhn Validator to only work with strings (Richtermeister)
 * bug #9476 Fixed bug with lazy services (peterrehm)
 * bug #9461 set mergeFallback to true, (ychadwick)
 * bug #9451 Fix bug with variable named context to securityContext (mieszko4)
 * feature #9434 moved logic for the session listeners into the HttpKernel component (fabpot)
 * bug #9431 [DependencyInjection] fixed YamlDumper did not make services private. (realityking)
 * bug #9332 [Config] Quoting reserved characters (WouterJ)
 * bug #9416 fixed issue with clone now the children of the original form are preserved and the clone form is given new children (yjv)
 * bug #9423 [Form] fix CsrfProviderAdapter (Tobion)
 * feature #9342 Add X-Debug-Url profiler url header (adrienbrault)
 * bug #9412 [HttpFoundation] added content length header to BinaryFileResponse (kbond)

* 2.4.0-BETA2 (2013-10-30)

 * bug #9408 [Form] Fixed failing FormDataExtractorTest (bschussek)
 * bug #9397 [BUG][Form] Fix nonexistent key id in twig of data collector (francoispluchino)
 * bug #9395 [HttpKernel] fixed memory limit display in MemoryDataCollector (hhamon)
 * bug #9168 [FrameworkBundle] made sure that the debug event dispatcher is used everywhere (fabpot)
 * bug #9388 [Form] Fixed: The "data" option is taken into account even if it is NULL (bschussek)
 * bug #9394 [Form] Fixed form debugger to work even when no view variables are logged (bschussek)
 * bug #9391 [Serializer] Fixed the error handling when decoding invalid XML to avoid a Warning (stof)
 * feature #9365 prevent PHP from magically setting a 302 header (lsmith77)
 * feature #9252 [FrameworkBundle] Only enable CSRF protection when enabled in config (asm89)
 * bug #9378 [DomCrawler] [HttpFoundation] Make `Content-Type` attributes identification case-insensitive (matthieuprat)
 * bug #9354 [Process] Fix #9343 : revert file handle usage on Windows platform (romainneutron)
 * bug #9335 [Form] Improved FormTypeCsrfExtension to use the type class as default intention if the form name is empty (bschussek)
 * bug #9334 [Form] Improved FormTypeCsrfExtension to use the type class as default intention if the form name is empty (bschussek)
 * bug #9333 [Form] Improved FormTypeCsrfExtension to use the type class as default intention if the form name is empty (bschussek)
 * bug #9338 [DoctrineBridge] Added type check to prevent calling clear() on arrays (bschussek)
 * bug #9330 [Config] Fixed namespace when dumping reference (WouterJ)
 * bug #9329 [Form] Changed FormTypeCsrfExtension to use the form's name as default token ID (bschussek)
 * bug #9328 [Form] Changed FormTypeCsrfExtension to use the form's name as default intention (bschussek)
 * bug #9327 [Form] Changed FormTypeCsrfExtension to use the form's name as default intention (bschussek)
 * bug #9316 [WebProfilerBundle] Fixed invalid condition in form panel (bschussek)
 * bug #9308 [DoctrineBridge] Loosened CollectionToArrayTransformer::transform() to accept arrays (bschussek)
 * bug #9297 [Form] Add missing use in form renderer (egeloen)
 * bug #9309 [Routing] Fixed unresolved class (francoispluchino)
 * bug #9274 [Yaml] Fixed the escaping of strings starting with a dash when dumping (stof)
 * bug #9270 [Templating] Fix in ChainLoader.php (janschoenherr)
 * bug #9246 [Session] fixed wrong started state (tecbot)
 * bug #9234 [Debug] Fixed `ClassNotFoundFatalErrorHandler` (tPl0ch)
 * bug #9259 [Process] Fix latest merge from 2.2 in 2.3 (romainneutron)
 * bug #9237 [FrameworkBundle] assets:install command should mirror .dotfiles (.htaccess) (FineWolf)
 * bug #9223 [Translator] PoFileDumper - PO headers (Padam87)
 * bug #9257 [Process] Fix 9182 : random failure on pipes tests (romainneutron)
 * bug #9236 [Form] fix missing use statement for exception UnexpectedTypeException (jaugustin)
 * bug #9222 [Bridge] [Propel1] Fixed guessed relations (ClementGautier)
 * bug #9214 [FramworkBundle] Check event listener services are not abstract (lyrixx)
 * bug #9207 [HttpKernel] Check for lock existence before unlinking (ollietb)
 * bug #9184 Fixed cache warmup of paths which contain back-slashes (fabpot)
 * bug #9192 [Form] remove MinCount and MaxCount constraints in ValidatorTypeGuesser (franek)

* 2.4.0-BETA1 (2013-10-07)

 * first beta release

