/* sqlheavy-value.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-value.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

struct _SQLHeavyValueArrayPrivate {
	SQLHeavyValueArray* _source;
	gint* to_source_map;
	gint to_source_map_length1;
	gint _to_source_map_size_;
	GValue** values;
	gint values_length1;
	gint _values_size_;
};


static gpointer sql_heavy_value_array_parent_class = NULL;

GType sql_heavy_sqlite_type_to_g_type (gint stype, GError** error);
GType sql_heavy_sqlite_type_string_to_g_type (const gchar* stype, GError** error);
gboolean sql_heavy_value_equal (GValue* a, GValue* b);
void sql_heavy_sqlite_value_to_g_value (sqlite3_value* value, GValue* result);
GValueArray* sql_heavy_sqlite_value_array_to_g_value_array (sqlite3_value** values, int values_length1);
gboolean sql_heavy_check_type (GType gtype);
#define SQL_HEAVY_VALUE_ARRAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_VALUE_ARRAY, SQLHeavyValueArrayPrivate))
enum  {
	SQL_HEAVY_VALUE_ARRAY_DUMMY_PROPERTY,
	SQL_HEAVY_VALUE_ARRAY_SOURCE,
	SQL_HEAVY_VALUE_ARRAY_LENGTH
};
static void _vala_GValue_free (GValue* self);
static void sql_heavy_value_array_prepare_set (SQLHeavyValueArray* self, gint index);
static void sql_heavy_value_array_set_values_length (SQLHeavyValueArray* self, gint length);
static void sql_heavy_value_array_finish_set (SQLHeavyValueArray* self, gint index);
static GValue* _g_value_dup (GValue* self);
static void sql_heavy_value_array_on_parent_position_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint old_index, gint new_index);
static void sql_heavy_value_array_on_parent_value_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint index);
static SQLHeavyValueArray* sql_heavy_value_array_new_with_source (SQLHeavyValueArray* source);
static SQLHeavyValueArray* sql_heavy_value_array_construct_with_source (GType object_type, SQLHeavyValueArray* source);
static void _sql_heavy_value_array_on_parent_position_changed_sql_heavy_value_array_position_changed (SQLHeavyValueArray* _sender, gint old_index, gint new_index, gpointer self);
static void _sql_heavy_value_array_on_parent_value_changed_sql_heavy_value_array_value_changed (SQLHeavyValueArray* _sender, gint index, gpointer self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sql_heavy_value_array_finalize (GObject* obj);
static void _vala_sql_heavy_value_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_value_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Covert an SQLite type (integer) to a GLib.Type.
   *
   * @param stype the SQLite type
   * @return the GLib.Type
   * @see sqlite_type_string_to_g_type
   */
GType sql_heavy_sqlite_type_to_g_type (gint stype, GError** error) {
	GType result = 0UL;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stype;
	switch (_tmp0_) {
		case SQLITE_INTEGER:
		{
			result = G_TYPE_INT64;
			return result;
		}
		case SQLITE3_TEXT:
		{
			result = G_TYPE_STRING;
			return result;
		}
		case SQLITE_FLOAT:
		{
			result = G_TYPE_DOUBLE;
			return result;
		}
		case SQLITE_NULL:
		{
			result = G_TYPE_POINTER;
			return result;
		}
		case SQLITE_BLOB:
		{
			result = G_TYPE_BYTE_ARRAY;
			return result;
		}
		default:
		{
			GError* _tmp1_;
			_tmp1_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type unsupported.");
			_inner_error_ = _tmp1_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0UL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0UL;
			}
		}
	}
}


/**
   * Covert an SQLite type (string) to a GLib.Type.
   *
   * @param stype the SQLite type
   * @return the GLib.Type
   * @see sqlite_type_to_g_type
   */
GType sql_heavy_sqlite_type_string_to_g_type (const gchar* stype, GError** error) {
	GType result = 0UL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (stype != NULL, 0UL);
	_tmp0_ = stype;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("INTEGER")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_INT64;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("TEXT")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_STRING;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("FLOAT")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_DOUBLE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("NULL")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_POINTER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("BLOB")))) {
		switch (0) {
			default:
			{
				result = G_TYPE_BYTE_ARRAY;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				GError* _tmp5_;
				_tmp4_ = stype;
				_tmp5_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Unknown datatype (\"%s\")", _tmp4_);
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0UL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0UL;
				}
			}
		}
	}
}


/**
   * Test whether two GLib.Values are equal
   */
gboolean sql_heavy_value_equal (GValue* a, GValue* b) {
	gboolean result = FALSE;
	GType _tmp0_ = 0UL;
	GType gtype;
	GType _tmp1_;
	gboolean _tmp2_ = FALSE;
	GType _tmp3_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = G_VALUE_TYPE (a);
	gtype = _tmp0_;
	_tmp1_ = gtype;
	_tmp2_ = G_VALUE_HOLDS (b, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gtype;
	if (_tmp3_ == G_TYPE_INT64) {
		gint64 _tmp4_ = 0LL;
		gint64 _tmp5_ = 0LL;
		_tmp4_ = g_value_get_int64 (a);
		_tmp5_ = g_value_get_int64 (a);
		result = _tmp4_ == _tmp5_;
		return result;
	} else {
		GType _tmp6_;
		_tmp6_ = gtype;
		if (_tmp6_ == G_TYPE_STRING) {
			GEqualFunc _tmp7_;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			_tmp7_ = g_str_equal;
			_tmp8_ = g_value_get_string (a);
			_tmp9_ = g_value_get_string (b);
			_tmp10_ = _tmp7_ (_tmp8_, _tmp9_);
			result = _tmp10_;
			return result;
		} else {
			GType _tmp11_;
			_tmp11_ = gtype;
			if (_tmp11_ == G_TYPE_DOUBLE) {
				gdouble _tmp12_ = 0.0;
				gdouble _tmp13_ = 0.0;
				_tmp12_ = g_value_get_double (a);
				_tmp13_ = g_value_get_double (b);
				result = _tmp12_ == _tmp13_;
				return result;
			} else {
				GType _tmp14_;
				_tmp14_ = gtype;
				if (_tmp14_ == G_TYPE_BYTE_ARRAY) {
					void* _tmp15_ = NULL;
					GByteArray* a1;
					void* _tmp16_ = NULL;
					GByteArray* b1;
					gboolean _tmp17_ = FALSE;
					GByteArray* _tmp18_;
					guint _tmp19_;
					GByteArray* _tmp20_;
					guint _tmp21_;
					gboolean _tmp29_;
					_tmp15_ = g_value_get_boxed (a);
					a1 = (GByteArray*) _tmp15_;
					_tmp16_ = g_value_get_boxed (b);
					b1 = (GByteArray*) _tmp16_;
					_tmp18_ = a1;
					_tmp19_ = _tmp18_->len;
					_tmp20_ = b1;
					_tmp21_ = _tmp20_->len;
					if (_tmp19_ == _tmp21_) {
						GByteArray* _tmp22_;
						guint8* _tmp23_;
						gint _tmp23__length1;
						GByteArray* _tmp24_;
						guint8* _tmp25_;
						gint _tmp25__length1;
						GByteArray* _tmp26_;
						guint _tmp27_;
						gint _tmp28_ = 0;
						_tmp22_ = a1;
						_tmp23_ = _tmp22_->data;
						_tmp23__length1 = (gint) _tmp22_->len;
						_tmp24_ = b1;
						_tmp25_ = _tmp24_->data;
						_tmp25__length1 = (gint) _tmp24_->len;
						_tmp26_ = a1;
						_tmp27_ = _tmp26_->len;
						_tmp28_ = memcmp (_tmp23_, _tmp25_, (gsize) _tmp27_);
						_tmp17_ = _tmp28_ == 0;
					} else {
						_tmp17_ = FALSE;
					}
					_tmp29_ = _tmp17_;
					result = _tmp29_;
					return result;
				} else {
					GType _tmp30_;
					_tmp30_ = gtype;
					if (_tmp30_ == G_TYPE_POINTER) {
						void* _tmp31_ = NULL;
						void* _tmp32_ = NULL;
						_tmp31_ = g_value_get_pointer (a);
						_tmp32_ = g_value_get_pointer (b);
						result = _tmp31_ == _tmp32_;
						return result;
					} else {
						GType _tmp33_;
						const gchar* _tmp34_ = NULL;
						_tmp33_ = gtype;
						_tmp34_ = g_type_name (_tmp33_);
						g_critical ("sqlheavy-value.vala:71: sql_heavy_value_equal not implemented for %s t" \
"ype.", _tmp34_);
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
}


/**
   * Convert an SQLite value to a GLib.Value
   *
   * @param value the SQLite value
   * @return the GLib.Value
   */
void sql_heavy_sqlite_value_to_g_value (sqlite3_value* value, GValue* result) {
	GType gtype = 0UL;
	GValue _tmp4_ = {0};
	GValue gval;
	GError * _inner_error_ = NULL;
	g_return_if_fail (value != NULL);
	{
		sqlite3_value* _tmp0_;
		gint _tmp1_ = 0;
		GType _tmp2_ = 0UL;
		GType _tmp3_;
		_tmp0_ = value;
		_tmp1_ = sqlite3_value_type (_tmp0_);
		_tmp2_ = sql_heavy_sqlite_type_to_g_type (_tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch48_sql_heavy_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		gtype = _tmp3_;
	}
	goto __finally48;
	__catch48_sql_heavy_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_value_init (&_tmp4_, gtype);
	gval = _tmp4_;
	if (gtype == G_TYPE_INT64) {
		sqlite3_value* _tmp5_;
		gint64 _tmp6_ = 0LL;
		GValue _tmp7_ = {0};
		_tmp5_ = value;
		_tmp6_ = sqlite3_value_int64 (_tmp5_);
		g_value_init (&_tmp7_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp7_, _tmp6_);
		G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
		gval = _tmp7_;
	} else {
		if (gtype == G_TYPE_DOUBLE) {
			sqlite3_value* _tmp8_;
			gdouble _tmp9_ = 0.0;
			GValue _tmp10_ = {0};
			_tmp8_ = value;
			_tmp9_ = sqlite3_value_double (_tmp8_);
			g_value_init (&_tmp10_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp10_, _tmp9_);
			G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
			gval = _tmp10_;
		} else {
			if (gtype == G_TYPE_STRING) {
				sqlite3_value* _tmp11_;
				const gchar* _tmp12_ = NULL;
				GValue _tmp13_ = {0};
				_tmp11_ = value;
				_tmp12_ = sqlite3_value_text (_tmp11_);
				g_value_init (&_tmp13_, G_TYPE_STRING);
				g_value_set_string (&_tmp13_, _tmp12_);
				G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
				gval = _tmp13_;
			} else {
				if (gtype == G_TYPE_BYTE_ARRAY) {
					sqlite3_value* _tmp14_;
					void* _tmp15_ = NULL;
					guint8* blob;
					gint blob_length1;
					gint _blob_size_;
					sqlite3_value* _tmp16_;
					gint _tmp17_ = 0;
					gint _tmp18_;
					guint8* _tmp19_;
					gint _tmp19__length1;
					GByteArray* _tmp20_;
					GByteArray* ba;
					GByteArray* _tmp21_;
					guint8* _tmp22_;
					gint _tmp22__length1;
					GByteArray* _tmp23_;
					GValue _tmp24_ = {0};
					_tmp14_ = value;
					_tmp15_ = sqlite3_value_blob (_tmp14_);
					blob = (guint8*) _tmp15_;
					blob_length1 = -1;
					_blob_size_ = blob_length1;
					_tmp16_ = value;
					_tmp17_ = sqlite3_value_bytes (_tmp16_);
					blob_length1 = _tmp17_;
					_tmp18_ = blob_length1;
					_tmp19_ = blob;
					_tmp19__length1 = blob_length1;
					_tmp20_ = g_byte_array_sized_new ((guint) _tmp19__length1);
					ba = _tmp20_;
					_tmp21_ = ba;
					_tmp22_ = blob;
					_tmp22__length1 = blob_length1;
					g_byte_array_append (_tmp21_, _tmp22_, _tmp22__length1);
					_tmp23_ = ba;
					g_value_init (&_tmp24_, G_TYPE_BYTE_ARRAY);
					g_value_set_boxed (&_tmp24_, _tmp23_);
					G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
					gval = _tmp24_;
					_g_byte_array_unref0 (ba);
				} else {
					if (gtype == G_TYPE_POINTER) {
						g_value_set_pointer (&gval, NULL);
					}
				}
			}
		}
	}
	*result = gval;
	return;
}


/**
   * Convert an array of SQLite values to a GLib.ValueArray
   *
   * @param values the SQLite values
   * @return the GLib.ValueArray
   */
GValueArray* sql_heavy_sqlite_value_array_to_g_value_array (sqlite3_value** values, int values_length1) {
	GValueArray* result = NULL;
	sqlite3_value** _tmp0_;
	gint _tmp0__length1;
	GValueArray* _tmp1_;
	GValueArray* va;
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = g_value_array_new ((guint) _tmp0__length1);
	va = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				sqlite3_value** _tmp6_;
				gint _tmp6__length1;
				GValueArray* _tmp7_;
				sqlite3_value** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				sqlite3_value* _tmp10_;
				GValue _tmp11_ = {0};
				GValue _tmp12_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = values;
				_tmp6__length1 = values_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = va;
				_tmp8_ = values;
				_tmp8__length1 = values_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				sql_heavy_sqlite_value_to_g_value (_tmp10_, &_tmp11_);
				_tmp12_ = _tmp11_;
				g_value_array_append (_tmp7_, &_tmp12_);
				G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
			}
		}
	}
	result = va;
	return result;
}


/**
   * Escape a string for use in an SQL query.
   *
   * This function should be used sparingly, as it is generally
   * preferable to use prepared statements.
   *
   * @param str the string to escape
   * @return the escaped string
   * @see Query.bind_string
   */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch49_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally49;
	__catch49_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* sql_heavy_escape_string (const gchar* str) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_replace (_tmp0_, "'", "''");
	result = _tmp1_;
	return result;
}


/**
   * Check to see whether the specified GType is handled by SQLHeavy
   *
   * @param gtype the type to check
   * @return whether or not the type is handled by SQLHeavy
   */
gboolean sql_heavy_check_type (GType gtype) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GType _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp12_;
	gboolean _tmp14_;
	gboolean _tmp16_;
	gboolean _tmp18_;
	_tmp6_ = gtype;
	if (_tmp6_ == G_TYPE_INT) {
		_tmp5_ = TRUE;
	} else {
		GType _tmp7_;
		_tmp7_ = gtype;
		_tmp5_ = _tmp7_ == G_TYPE_STRING;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		_tmp4_ = TRUE;
	} else {
		GType _tmp9_;
		_tmp9_ = gtype;
		_tmp4_ = _tmp9_ == G_TYPE_INT64;
	}
	_tmp10_ = _tmp4_;
	if (_tmp10_) {
		_tmp3_ = TRUE;
	} else {
		GType _tmp11_;
		_tmp11_ = gtype;
		_tmp3_ = _tmp11_ == G_TYPE_FLOAT;
	}
	_tmp12_ = _tmp3_;
	if (_tmp12_) {
		_tmp2_ = TRUE;
	} else {
		GType _tmp13_;
		_tmp13_ = gtype;
		_tmp2_ = _tmp13_ == G_TYPE_DOUBLE;
	}
	_tmp14_ = _tmp2_;
	if (_tmp14_) {
		_tmp1_ = TRUE;
	} else {
		GType _tmp15_;
		_tmp15_ = gtype;
		_tmp1_ = _tmp15_ == G_TYPE_POINTER;
	}
	_tmp16_ = _tmp1_;
	if (_tmp16_) {
		_tmp0_ = TRUE;
	} else {
		GType _tmp17_;
		_tmp17_ = gtype;
		_tmp0_ = _tmp17_ == G_TYPE_BYTE_ARRAY;
	}
	_tmp18_ = _tmp0_;
	result = _tmp18_;
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


/**
     * Retrieve a value
     *
     * @param index the index of the value to retrieve
     * @return the value
     */
GValue* sql_heavy_value_array_get (SQLHeavyValueArray* self, gint index) {
	GValue* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	GValue** _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = index;
	_tmp1_ = sql_heavy_value_array_get_length (self);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp0_ < _tmp2_, NULL);
	_tmp4_ = self->priv->values;
	_tmp4__length1 = self->priv->values_length1;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		gint* _tmp6_;
		gint _tmp6__length1;
		gboolean _tmp10_;
		_tmp6_ = self->priv->to_source_map;
		_tmp6__length1 = self->priv->to_source_map_length1;
		if (_tmp6_ == NULL) {
			_tmp5_ = TRUE;
		} else {
			gint* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gint _tmp9_;
			_tmp7_ = self->priv->to_source_map;
			_tmp7__length1 = self->priv->to_source_map_length1;
			_tmp8_ = index;
			_tmp9_ = _tmp7_[_tmp8_];
			_tmp5_ = _tmp9_ == (-1);
		}
		_tmp10_ = _tmp5_;
		_tmp3_ = _tmp10_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		GValue** _tmp12_;
		gint _tmp12__length1;
		gint _tmp13_;
		GValue* _tmp14_;
		_tmp12_ = self->priv->values;
		_tmp12__length1 = self->priv->values_length1;
		_tmp13_ = index;
		_tmp14_ = _tmp12_[_tmp13_];
		result = _tmp14_;
		return result;
	} else {
		gboolean _tmp15_ = FALSE;
		SQLHeavyValueArray* _tmp16_;
		gboolean _tmp20_;
		_tmp16_ = self->priv->_source;
		if (_tmp16_ != NULL) {
			gint* _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_;
			gint _tmp19_;
			_tmp17_ = self->priv->to_source_map;
			_tmp17__length1 = self->priv->to_source_map_length1;
			_tmp18_ = index;
			_tmp19_ = _tmp17_[_tmp18_];
			_tmp15_ = _tmp19_ != (-1);
		} else {
			_tmp15_ = FALSE;
		}
		_tmp20_ = _tmp15_;
		if (_tmp20_) {
			SQLHeavyValueArray* _tmp21_;
			gint* _tmp22_;
			gint _tmp22__length1;
			gint _tmp23_;
			gint _tmp24_;
			GValue* _tmp25_ = NULL;
			_tmp21_ = self->priv->_source;
			_tmp22_ = self->priv->to_source_map;
			_tmp22__length1 = self->priv->to_source_map_length1;
			_tmp23_ = index;
			_tmp24_ = _tmp22_[_tmp23_];
			_tmp25_ = sql_heavy_value_array_get (_tmp21_, _tmp24_);
			result = _tmp25_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


/**
     * Prepare to set a value
     *
     * @param index the index of the value to prepare
     */
static void sql_heavy_value_array_prepare_set (SQLHeavyValueArray* self, gint index) {
	gint _tmp0_;
	gint _tmp1_;
	gint len;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_value_array_get_length (self);
	_tmp1_ = _tmp0_;
	len = _tmp1_;
	_tmp2_ = index;
	_tmp3_ = len;
	if (_tmp2_ >= _tmp3_) {
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gint i;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
		_tmp4_ = index;
		_tmp5_ = len;
		_tmp6_ = MAX (_tmp4_, _tmp5_ - 1);
		i = _tmp6_;
		_tmp7_ = index;
		_tmp8_ = index;
		_tmp9_ = i;
		_tmp10_ = MAX (1, _tmp8_ - _tmp9_);
		sql_heavy_value_array_insert_padding (self, _tmp7_, _tmp10_);
	} else {
		GValue** _tmp11_;
		gint _tmp11__length1;
		_tmp11_ = self->priv->values;
		_tmp11__length1 = self->priv->values_length1;
		if (_tmp11_ == NULL) {
			gint _tmp12_;
			_tmp12_ = len;
			sql_heavy_value_array_set_values_length (self, _tmp12_);
		}
	}
	_tmp13_ = index;
	g_signal_emit_by_name (self, "value-changed::before", _tmp13_);
}


/**
     * Finish setting a value
     *
     * @param index the index of the value to finish setting
     */
static void sql_heavy_value_array_finish_set (SQLHeavyValueArray* self, gint index) {
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->to_source_map;
	_tmp0__length1 = self->priv->to_source_map_length1;
	if (_tmp0_ != NULL) {
		gint* _tmp1_;
		gint _tmp1__length1;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->to_source_map;
		_tmp1__length1 = self->priv->to_source_map_length1;
		_tmp2_ = index;
		_tmp1_[_tmp2_] = -1;
		_tmp3_ = _tmp1_[_tmp2_];
	}
	_tmp4_ = index;
	g_signal_emit_by_name (self, "value-changed", _tmp4_);
}


/**
     * Set a value
     *
     * This function will replace the value at the specified index if
     * it exists. If the array is not long enough to accomodate a
     * value at the specified index it is expanded.
     *
     * @param index the index to write to
     * @param value the value to write
     */
static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


void sql_heavy_value_array_set (SQLHeavyValueArray* self, gint index, GValue* value) {
	gint _tmp0_;
	GValue** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GValue* _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_prepare_set (self, _tmp0_);
	_tmp1_ = self->priv->values;
	_tmp1__length1 = self->priv->values_length1;
	_tmp2_ = index;
	_tmp3_ = value;
	_tmp4_ = __g_value_dup0 (_tmp3_);
	__vala_GValue_free0 (_tmp1_[_tmp2_]);
	_tmp1_[_tmp2_] = _tmp4_;
	_tmp5_ = _tmp1_[_tmp2_];
	_tmp6_ = index;
	sql_heavy_value_array_finish_set (self, _tmp6_);
}


/**
     * Set a string value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_string (SQLHeavyValueArray* self, gint index, const gchar* value) {
	gint _tmp0_;
	GValue** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_prepare_set (self, _tmp0_);
	_tmp1_ = self->priv->values;
	_tmp1__length1 = self->priv->values_length1;
	_tmp2_ = index;
	_tmp3_ = value;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_STRING);
	g_value_set_string (_tmp4_, _tmp3_);
	__vala_GValue_free0 (_tmp1_[_tmp2_]);
	_tmp1_[_tmp2_] = _tmp4_;
	_tmp5_ = _tmp1_[_tmp2_];
	_tmp6_ = index;
	sql_heavy_value_array_finish_set (self, _tmp6_);
}


/**
     * Set a int value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_int (SQLHeavyValueArray* self, gint index, gint value) {
	gint _tmp0_;
	GValue** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_prepare_set (self, _tmp0_);
	_tmp1_ = self->priv->values;
	_tmp1__length1 = self->priv->values_length1;
	_tmp2_ = index;
	_tmp3_ = value;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_INT);
	g_value_set_int (_tmp4_, _tmp3_);
	__vala_GValue_free0 (_tmp1_[_tmp2_]);
	_tmp1_[_tmp2_] = _tmp4_;
	_tmp5_ = _tmp1_[_tmp2_];
	_tmp6_ = index;
	sql_heavy_value_array_finish_set (self, _tmp6_);
}


/**
     * Set a 64-bit integer value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_int64 (SQLHeavyValueArray* self, gint index, gint64 value) {
	gint _tmp0_;
	GValue** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint64 _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_prepare_set (self, _tmp0_);
	_tmp1_ = self->priv->values;
	_tmp1__length1 = self->priv->values_length1;
	_tmp2_ = index;
	_tmp3_ = value;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_INT64);
	g_value_set_int64 (_tmp4_, _tmp3_);
	__vala_GValue_free0 (_tmp1_[_tmp2_]);
	_tmp1_[_tmp2_] = _tmp4_;
	_tmp5_ = _tmp1_[_tmp2_];
	_tmp6_ = index;
	sql_heavy_value_array_finish_set (self, _tmp6_);
}


/**
     * Set a double value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_double (SQLHeavyValueArray* self, gint index, gdouble value) {
	gint _tmp0_;
	GValue** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gdouble _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_prepare_set (self, _tmp0_);
	_tmp1_ = self->priv->values;
	_tmp1__length1 = self->priv->values_length1;
	_tmp2_ = index;
	_tmp3_ = value;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_DOUBLE);
	g_value_set_double (_tmp4_, _tmp3_);
	__vala_GValue_free0 (_tmp1_[_tmp2_]);
	_tmp1_[_tmp2_] = _tmp4_;
	_tmp5_ = _tmp1_[_tmp2_];
	_tmp6_ = index;
	sql_heavy_value_array_finish_set (self, _tmp6_);
}


/**
     * Set a binary data value
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_set_byte_array (SQLHeavyValueArray* self, gint index, GByteArray* value) {
	gint _tmp0_;
	GValue** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GByteArray* _tmp3_;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_prepare_set (self, _tmp0_);
	_tmp1_ = self->priv->values;
	_tmp1__length1 = self->priv->values_length1;
	_tmp2_ = index;
	_tmp3_ = value;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_BYTE_ARRAY);
	g_value_set_boxed (_tmp4_, _tmp3_);
	__vala_GValue_free0 (_tmp1_[_tmp2_]);
	_tmp1_[_tmp2_] = _tmp4_;
	_tmp5_ = _tmp1_[_tmp2_];
	_tmp6_ = index;
	sql_heavy_value_array_finish_set (self, _tmp6_);
}


void sql_heavy_value_array_set_null (SQLHeavyValueArray* self, gint index) {
	gint _tmp0_;
	GValue _tmp1_ = {0};
	GValue v;
	GValue** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	GValue _tmp4_;
	GValue _tmp5_;
	GValue* _tmp6_;
	GValue* _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_prepare_set (self, _tmp0_);
	g_value_init (&_tmp1_, G_TYPE_POINTER);
	v = _tmp1_;
	g_value_set_pointer (&v, NULL);
	_tmp2_ = self->priv->values;
	_tmp2__length1 = self->priv->values_length1;
	_tmp3_ = index;
	_tmp4_ = v;
	_tmp5_ = _tmp4_;
	_tmp6_ = __g_value_dup0 (&_tmp5_);
	__vala_GValue_free0 (_tmp2_[_tmp3_]);
	_tmp2_[_tmp3_] = _tmp6_;
	_tmp7_ = _tmp2_[_tmp3_];
	_tmp8_ = index;
	sql_heavy_value_array_finish_set (self, _tmp8_);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
}


/**
     * Insert a value into the array
     *
     * Rather than replacing the value at the specified index, this
     * function will move all subsequent data in order to make room
     * for the new value.
     *
     * @param index the index to write to
     * @param value the value to write
     */
void sql_heavy_value_array_insert (SQLHeavyValueArray* self, gint index, GValue* value) {
	gint _tmp0_;
	gint _tmp1_;
	GValue* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_insert_padding (self, _tmp0_, 1);
	_tmp1_ = index;
	_tmp2_ = value;
	sql_heavy_value_array_set (self, _tmp1_, _tmp2_);
}


/**
     * Append a value
     *
     * @param value the value to write
     */
void sql_heavy_value_array_append (SQLHeavyValueArray* self, GValue* value) {
	gint _tmp0_;
	gint _tmp1_;
	gint len;
	GValue* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_value_array_get_length (self);
	_tmp1_ = _tmp0_;
	len = _tmp1_;
	sql_heavy_value_array_insert_padding (self, len, 1);
	_tmp2_ = value;
	sql_heavy_value_array_set (self, len, _tmp2_);
}


/**
     * Prepend a value
     *
     * Note that prepend is much slower than append, since all other
     * values in the array must be moved.
     *
     * @param value the value to write
     */
void sql_heavy_value_array_prepend (SQLHeavyValueArray* self, GValue* value) {
	GValue* _tmp0_;
	g_return_if_fail (self != NULL);
	sql_heavy_value_array_insert_padding (self, 0, 1);
	_tmp0_ = value;
	sql_heavy_value_array_set (self, 0, _tmp0_);
}


/**
     * Remove a value
     *
     * All values after the removed value will be moved one slot in
     * order to fill in the gap.
     *
     * @param index the index of the value to remove
     */
void sql_heavy_value_array_remove (SQLHeavyValueArray* self, gint index) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = index;
	sql_heavy_value_array_insert_padding (self, _tmp0_, -1);
}


/**
     * Set the length of the {@link values} array
     */
static void sql_heavy_value_array_set_values_length (SQLHeavyValueArray* self, gint length) {
	GValue** _tmp0_;
	gint _tmp0__length1;
	gint* _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->values;
	_tmp0__length1 = self->priv->values_length1;
	if (_tmp0_ != NULL) {
		GValue** _tmp1_;
		gint _tmp1__length1;
		gint _tmp2_;
		_tmp1_ = self->priv->values;
		_tmp1__length1 = self->priv->values_length1;
		_tmp2_ = length;
		if (_tmp1__length1 != _tmp2_) {
			gint _tmp3_;
			gint _tmp4_ = 0;
			_tmp3_ = length;
			_tmp4_ = _tmp3_;
			self->priv->values = g_renew (GValue*, self->priv->values, _tmp3_);
			(_tmp4_ > self->priv->values_length1) ? memset (self->priv->values + self->priv->values_length1, 0, sizeof (GValue*) * (_tmp4_ - self->priv->values_length1)) : NULL;
			self->priv->values_length1 = _tmp4_;
			self->priv->_values_size_ = _tmp4_;
		}
	} else {
		gint _tmp5_;
		void* _tmp6_ = NULL;
		void* m;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = length;
		_tmp6_ = g_malloc0 ((gsize) (sizeof (GValue*) * (_tmp5_ + 1)));
		m = _tmp6_;
		memcpy (&self->priv->values, &m, (gsize) sizeof (GValue**));
		_tmp7_ = length;
		self->priv->values_length1 = _tmp7_;
		_tmp8_ = self->priv->values_length1;
	}
	_tmp9_ = self->priv->to_source_map;
	_tmp9__length1 = self->priv->to_source_map_length1;
	if (_tmp9_ != NULL) {
		gint _tmp10_;
		gint _tmp11_ = 0;
		_tmp10_ = length;
		_tmp11_ = _tmp10_;
		self->priv->to_source_map = g_renew (gint, self->priv->to_source_map, _tmp10_);
		(_tmp11_ > self->priv->to_source_map_length1) ? memset (self->priv->to_source_map + self->priv->to_source_map_length1, 0, sizeof (gint) * (_tmp11_ - self->priv->to_source_map_length1)) : NULL;
		self->priv->to_source_map_length1 = _tmp11_;
		self->priv->_to_source_map_size_ = _tmp11_;
	}
}


/**
     * Handle an item in the {@link source} array moving
     *
     * This is currently not implemented.
     */
static void sql_heavy_value_array_on_parent_position_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint old_index, gint new_index) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
}


/**
     * Handle data in the {@link source} array being changed
     */
static void sql_heavy_value_array_on_parent_value_changed (SQLHeavyValueArray* self, SQLHeavyValueArray* src, gint index) {
	gint _tmp0_;
	SQLHeavyValueArray* _tmp1_;
	gint _tmp2_;
	GValue* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = index;
	_tmp1_ = src;
	_tmp2_ = index;
	_tmp3_ = sql_heavy_value_array_get (_tmp1_, _tmp2_);
	sql_heavy_value_array_set (self, _tmp0_, _tmp3_);
}


/**
     * Insert or remove padding from the array
     *
     * If members is positive, padding will be added. If elements is
     * negative, elements/padding will be removed.
     *
     * @param index to add/remove from
     * @param members number of members to add/remove
     */
void sql_heavy_value_array_insert_padding (SQLHeavyValueArray* self, gint index, gint members) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint old_length;
	gint _tmp3_;
	gint _tmp4_;
	gint new_length;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = members;
	if (_tmp0_ == 0) {
		return;
	}
	_tmp1_ = sql_heavy_value_array_get_length (self);
	_tmp2_ = _tmp1_;
	old_length = _tmp2_;
	_tmp3_ = old_length;
	_tmp4_ = members;
	new_length = _tmp3_ + _tmp4_;
	_tmp5_ = members;
	if (_tmp5_ > 0) {
		GValue** _tmp18_;
		gint _tmp18__length1;
		{
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_ = 0;
			gint i;
			_tmp6_ = old_length;
			_tmp7_ = index;
			_tmp8_ = members;
			_tmp9_ = MIN (_tmp6_, _tmp7_ + _tmp8_);
			i = _tmp9_;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					gboolean _tmp11_;
					gint _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					_tmp11_ = _tmp10_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ - 1;
					}
					_tmp10_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = index;
					if (!(_tmp13_ >= _tmp14_)) {
						break;
					}
					_tmp15_ = i;
					_tmp16_ = i;
					_tmp17_ = members;
					g_signal_emit_by_name (self, "position-changed::before", _tmp15_, _tmp16_ + _tmp17_);
				}
			}
		}
		_tmp18_ = self->priv->values;
		_tmp18__length1 = self->priv->values_length1;
		if (_tmp18_ != NULL) {
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp19_ = new_length;
			sql_heavy_value_array_set_values_length (self, _tmp19_);
			_tmp20_ = index;
			_tmp21_ = old_length;
			if (_tmp20_ < _tmp21_) {
				GValue** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				gint _tmp24_;
				GValue** _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				gint _tmp27_;
				GValue** _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				gint _tmp30_;
				gint* _tmp31_;
				gint _tmp31__length1;
				_tmp22_ = self->priv->values;
				_tmp22__length1 = self->priv->values_length1;
				_tmp23_ = index;
				_tmp24_ = members;
				_tmp25_ = self->priv->values;
				_tmp25__length1 = self->priv->values_length1;
				_tmp26_ = index;
				_tmp27_ = members;
				g_memmove ((void*) (((gulong) _tmp22_) + ((_tmp23_ + _tmp24_) * sizeof (GValue*))), (void*) (((gulong) _tmp25_) + (_tmp26_ * sizeof (GValue*))), (gsize) (_tmp27_ * sizeof (GValue*)));
				_tmp28_ = self->priv->values;
				_tmp28__length1 = self->priv->values_length1;
				_tmp29_ = index;
				_tmp30_ = members;
				memset ((void*) (((gulong) _tmp28_) + (_tmp29_ * sizeof (GValue*))), 0, (gsize) (_tmp30_ * sizeof (GValue*)));
				_tmp31_ = self->priv->to_source_map;
				_tmp31__length1 = self->priv->to_source_map_length1;
				if (_tmp31_ != NULL) {
					gint* _tmp32_;
					gint _tmp32__length1;
					gint _tmp33_;
					gint _tmp34_;
					gint* _tmp35_;
					gint _tmp35__length1;
					gint _tmp36_;
					gint _tmp37_;
					_tmp32_ = self->priv->to_source_map;
					_tmp32__length1 = self->priv->to_source_map_length1;
					_tmp33_ = index;
					_tmp34_ = members;
					_tmp35_ = self->priv->to_source_map;
					_tmp35__length1 = self->priv->to_source_map_length1;
					_tmp36_ = index;
					_tmp37_ = members;
					g_memmove ((void*) (((gulong) _tmp32_) + ((_tmp33_ + _tmp34_) * sizeof (gint))), (void*) (((gulong) _tmp35_) + (_tmp36_ * sizeof (gint))), (gsize) (_tmp37_ * sizeof (gint)));
				}
			}
		} else {
			gint _tmp38_;
			_tmp38_ = new_length;
			sql_heavy_value_array_set_values_length (self, _tmp38_);
		}
		{
			gint _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_ = 0;
			gint i;
			_tmp39_ = old_length;
			_tmp40_ = index;
			_tmp41_ = members;
			_tmp42_ = MIN (_tmp39_, _tmp40_ + _tmp41_);
			i = _tmp42_;
			{
				gboolean _tmp43_;
				_tmp43_ = TRUE;
				while (TRUE) {
					gboolean _tmp44_;
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					_tmp44_ = _tmp43_;
					if (!_tmp44_) {
						gint _tmp45_;
						_tmp45_ = i;
						i = _tmp45_ - 1;
					}
					_tmp43_ = FALSE;
					_tmp46_ = i;
					_tmp47_ = index;
					if (!(_tmp46_ >= _tmp47_)) {
						break;
					}
					_tmp48_ = i;
					_tmp49_ = i;
					_tmp50_ = members;
					g_signal_emit_by_name (self, "position-changed", _tmp48_, _tmp49_ + _tmp50_);
				}
			}
		}
	} else {
		gint _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		gint _tmp98_;
		{
			gint _tmp51_;
			gint i;
			_tmp51_ = index;
			i = _tmp51_;
			{
				gboolean _tmp52_;
				_tmp52_ = TRUE;
				while (TRUE) {
					gboolean _tmp53_;
					gint _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					gint _tmp59_;
					_tmp53_ = _tmp52_;
					if (!_tmp53_) {
						gint _tmp54_;
						_tmp54_ = i;
						i = _tmp54_ + 1;
					}
					_tmp52_ = FALSE;
					_tmp55_ = i;
					_tmp56_ = index;
					_tmp57_ = members;
					if (!(_tmp55_ < (_tmp56_ - _tmp57_))) {
						break;
					}
					_tmp58_ = i;
					g_signal_emit_by_name (self, "position-changed::before", _tmp58_, -1);
					_tmp59_ = i;
					sql_heavy_value_array_set (self, _tmp59_, NULL);
				}
			}
		}
		{
			gint _tmp60_;
			gint _tmp61_;
			gint i;
			_tmp60_ = index;
			_tmp61_ = members;
			i = _tmp60_ - _tmp61_;
			{
				gboolean _tmp62_;
				_tmp62_ = TRUE;
				while (TRUE) {
					gboolean _tmp63_;
					gint _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					_tmp63_ = _tmp62_;
					if (!_tmp63_) {
						gint _tmp64_;
						_tmp64_ = i;
						i = _tmp64_ + 1;
					}
					_tmp62_ = FALSE;
					_tmp65_ = i;
					_tmp66_ = old_length;
					if (!(_tmp65_ < _tmp66_)) {
						break;
					}
					_tmp67_ = i;
					_tmp68_ = i;
					_tmp69_ = members;
					g_signal_emit_by_name (self, "position-changed::before", _tmp67_, _tmp68_ + _tmp69_);
				}
			}
		}
		_tmp70_ = index;
		_tmp71_ = members;
		_tmp72_ = old_length;
		if ((_tmp70_ - _tmp71_) < _tmp72_) {
			GValue** _tmp73_;
			gint _tmp73__length1;
			gint _tmp74_;
			GValue** _tmp75_;
			gint _tmp75__length1;
			gint _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			GValue** _tmp81_;
			gint _tmp81__length1;
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			gint* _tmp85_;
			gint _tmp85__length1;
			_tmp73_ = self->priv->values;
			_tmp73__length1 = self->priv->values_length1;
			_tmp74_ = index;
			_tmp75_ = self->priv->values;
			_tmp75__length1 = self->priv->values_length1;
			_tmp76_ = index;
			_tmp77_ = members;
			_tmp78_ = old_length;
			_tmp79_ = index;
			_tmp80_ = members;
			g_memmove ((void*) (((gulong) _tmp73_) + (_tmp74_ * sizeof (GValue*))), (void*) (((gulong) _tmp75_) + ((_tmp76_ - _tmp77_) * sizeof (GValue*))), (gsize) (((_tmp78_ - _tmp79_) + _tmp80_) * sizeof (GValue*)));
			_tmp81_ = self->priv->values;
			_tmp81__length1 = self->priv->values_length1;
			_tmp82_ = old_length;
			_tmp83_ = members;
			_tmp84_ = members;
			memset ((void*) (((gulong) _tmp81_) + ((_tmp82_ + _tmp83_) * sizeof (GValue*))), 0, (gsize) ((-_tmp84_) * sizeof (GValue*)));
			_tmp85_ = self->priv->to_source_map;
			_tmp85__length1 = self->priv->to_source_map_length1;
			if (_tmp85_ != NULL) {
				gint* _tmp86_;
				gint _tmp86__length1;
				gint _tmp87_;
				gint* _tmp88_;
				gint _tmp88__length1;
				gint _tmp89_;
				gint _tmp90_;
				gint _tmp91_;
				gint _tmp92_;
				gint _tmp93_;
				gint* _tmp94_;
				gint _tmp94__length1;
				gint _tmp95_;
				gint _tmp96_;
				gint _tmp97_;
				_tmp86_ = self->priv->to_source_map;
				_tmp86__length1 = self->priv->to_source_map_length1;
				_tmp87_ = index;
				_tmp88_ = self->priv->to_source_map;
				_tmp88__length1 = self->priv->to_source_map_length1;
				_tmp89_ = index;
				_tmp90_ = members;
				_tmp91_ = old_length;
				_tmp92_ = index;
				_tmp93_ = members;
				g_memmove ((void*) (((gulong) _tmp86_) + (_tmp87_ * sizeof (gint))), (void*) (((gulong) _tmp88_) + ((_tmp89_ - _tmp90_) * sizeof (gint))), (gsize) (((_tmp91_ - _tmp92_) + _tmp93_) * sizeof (gint)));
				_tmp94_ = self->priv->to_source_map;
				_tmp94__length1 = self->priv->to_source_map_length1;
				_tmp95_ = old_length;
				_tmp96_ = members;
				_tmp97_ = members;
				memset ((void*) (((gulong) _tmp94_) + ((_tmp95_ + _tmp96_) * sizeof (gint))), 0, (gsize) ((-_tmp97_) * sizeof (gint)));
			}
		}
		_tmp98_ = new_length;
		sql_heavy_value_array_set_values_length (self, _tmp98_);
		{
			gint _tmp99_;
			gint i;
			_tmp99_ = index;
			i = _tmp99_;
			{
				gboolean _tmp100_;
				_tmp100_ = TRUE;
				while (TRUE) {
					gboolean _tmp101_;
					gint _tmp103_;
					gint _tmp104_;
					gint _tmp105_;
					gint _tmp106_;
					_tmp101_ = _tmp100_;
					if (!_tmp101_) {
						gint _tmp102_;
						_tmp102_ = i;
						i = _tmp102_ + 1;
					}
					_tmp100_ = FALSE;
					_tmp103_ = i;
					_tmp104_ = index;
					_tmp105_ = members;
					if (!(_tmp103_ < (_tmp104_ - _tmp105_))) {
						break;
					}
					_tmp106_ = i;
					g_signal_emit_by_name (self, "position-changed", _tmp106_, -1);
				}
			}
		}
		{
			gint _tmp107_;
			gint _tmp108_;
			gint i;
			_tmp107_ = index;
			_tmp108_ = members;
			i = _tmp107_ - _tmp108_;
			{
				gboolean _tmp109_;
				_tmp109_ = TRUE;
				while (TRUE) {
					gboolean _tmp110_;
					gint _tmp112_;
					gint _tmp113_;
					gint _tmp114_;
					gint _tmp115_;
					gint _tmp116_;
					_tmp110_ = _tmp109_;
					if (!_tmp110_) {
						gint _tmp111_;
						_tmp111_ = i;
						i = _tmp111_ + 1;
					}
					_tmp109_ = FALSE;
					_tmp112_ = i;
					_tmp113_ = old_length;
					if (!(_tmp112_ < _tmp113_)) {
						break;
					}
					_tmp114_ = i;
					_tmp115_ = i;
					_tmp116_ = members;
					g_signal_emit_by_name (self, "position-changed", _tmp114_, _tmp115_ + _tmp116_);
				}
			}
		}
	}
}


/**
     * Clear all values from the array
     */
void sql_heavy_value_array_clear (SQLHeavyValueArray* self) {
	GValue** _tmp0_;
	gint _tmp0__length1;
	gint* _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->values;
	_tmp0__length1 = self->priv->values_length1;
	if (_tmp0_ != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp2_;
					gint _tmp4_;
					GValue** _tmp5_;
					gint _tmp5__length1;
					GValue** _tmp6_;
					gint _tmp6__length1;
					gint _tmp7_;
					GValue* _tmp8_;
					_tmp2_ = _tmp1_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = self->priv->values;
					_tmp5__length1 = self->priv->values_length1;
					if (!(_tmp4_ < _tmp5__length1)) {
						break;
					}
					_tmp6_ = self->priv->values;
					_tmp6__length1 = self->priv->values_length1;
					_tmp7_ = i;
					__vala_GValue_free0 (_tmp6_[_tmp7_]);
					_tmp6_[_tmp7_] = NULL;
					_tmp8_ = _tmp6_[_tmp7_];
				}
			}
		}
	}
	_tmp9_ = self->priv->to_source_map;
	_tmp9__length1 = self->priv->to_source_map_length1;
	if (_tmp9_ != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					gboolean _tmp11_;
					gint _tmp13_;
					gint* _tmp14_;
					gint _tmp14__length1;
					gint* _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					gint _tmp17_;
					_tmp11_ = _tmp10_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = self->priv->to_source_map;
					_tmp14__length1 = self->priv->to_source_map_length1;
					if (!(_tmp13_ < _tmp14__length1)) {
						break;
					}
					_tmp15_ = self->priv->to_source_map;
					_tmp15__length1 = self->priv->to_source_map_length1;
					_tmp16_ = i;
					_tmp15_[_tmp16_] = -1;
					_tmp17_ = _tmp15_[_tmp16_];
				}
			}
		}
	}
}


/**
     * Create a copy of the array
     *
     * No data will be copied unless the {@link source} array is
     * altered.
     *
     * @return a new array
     */
SQLHeavyValueArray* sql_heavy_value_array_copy (SQLHeavyValueArray* self) {
	SQLHeavyValueArray* result = NULL;
	SQLHeavyValueArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sql_heavy_value_array_new_with_source (self);
	result = _tmp0_;
	return result;
}


/**
     * Create a new array with the specified number of elements
     * pre-allocated
     */
SQLHeavyValueArray* sql_heavy_value_array_construct (GType object_type, gint length) {
	SQLHeavyValueArray * self = NULL;
	gint _tmp0_;
	self = (SQLHeavyValueArray*) g_object_new (object_type, NULL);
	_tmp0_ = length;
	if (_tmp0_ > 0) {
		gint _tmp1_;
		_tmp1_ = length;
		sql_heavy_value_array_insert_padding (self, 0, _tmp1_);
	}
	return self;
}


SQLHeavyValueArray* sql_heavy_value_array_new (gint length) {
	return sql_heavy_value_array_construct (SQL_HEAVY_TYPE_VALUE_ARRAY, length);
}


static SQLHeavyValueArray* sql_heavy_value_array_construct_with_source (GType object_type, SQLHeavyValueArray* source) {
	SQLHeavyValueArray * self = NULL;
	SQLHeavyValueArray* _tmp0_;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = source;
	self = (SQLHeavyValueArray*) g_object_new (object_type, "source", _tmp0_, NULL);
	return self;
}


static SQLHeavyValueArray* sql_heavy_value_array_new_with_source (SQLHeavyValueArray* source) {
	return sql_heavy_value_array_construct_with_source (SQL_HEAVY_TYPE_VALUE_ARRAY, source);
}


SQLHeavyValueArray* sql_heavy_value_array_get_source (SQLHeavyValueArray* self) {
	SQLHeavyValueArray* result;
	SQLHeavyValueArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sql_heavy_value_array_on_parent_position_changed_sql_heavy_value_array_position_changed (SQLHeavyValueArray* _sender, gint old_index, gint new_index, gpointer self) {
	sql_heavy_value_array_on_parent_position_changed (self, _sender, old_index, new_index);
}


static void _sql_heavy_value_array_on_parent_value_changed_sql_heavy_value_array_value_changed (SQLHeavyValueArray* _sender, gint index, gpointer self) {
	sql_heavy_value_array_on_parent_value_changed (self, _sender, index);
}


void sql_heavy_value_array_set_source (SQLHeavyValueArray* self, SQLHeavyValueArray* value) {
	SQLHeavyValueArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ != NULL) {
		SQLHeavyValueArray* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint len;
		gint _tmp4_;
		SQLHeavyValueArray* _tmp5_;
		SQLHeavyValueArray* _tmp6_;
		gint _tmp7_;
		gint* _tmp8_ = NULL;
		SQLHeavyValueArray* _tmp18_;
		SQLHeavyValueArray* _tmp19_;
		_tmp1_ = value;
		_tmp2_ = sql_heavy_value_array_get_length (_tmp1_);
		_tmp3_ = _tmp2_;
		len = _tmp3_;
		_tmp4_ = len;
		g_return_if_fail (_tmp4_ > 0);
		_tmp5_ = value;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp6_;
		_tmp7_ = len;
		_tmp8_ = g_new0 (gint, _tmp7_);
		self->priv->to_source_map = (g_free (self->priv->to_source_map), NULL);
		self->priv->to_source_map = _tmp8_;
		self->priv->to_source_map_length1 = _tmp7_;
		self->priv->_to_source_map_size_ = self->priv->to_source_map_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					gboolean _tmp10_;
					gint _tmp12_;
					gint _tmp13_;
					gint* _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = len;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					_tmp14_ = self->priv->to_source_map;
					_tmp14__length1 = self->priv->to_source_map_length1;
					_tmp15_ = i;
					_tmp16_ = i;
					_tmp14_[_tmp15_] = _tmp16_;
					_tmp17_ = _tmp14_[_tmp15_];
				}
			}
		}
		_tmp18_ = value;
		g_signal_connect_object (_tmp18_, "position-changed::before", (GCallback) _sql_heavy_value_array_on_parent_position_changed_sql_heavy_value_array_position_changed, self, 0);
		_tmp19_ = value;
		g_signal_connect_object (_tmp19_, "value-changed::before", (GCallback) _sql_heavy_value_array_on_parent_value_changed_sql_heavy_value_array_value_changed, self, 0);
	}
	g_object_notify ((GObject *) self, "source");
}


gint sql_heavy_value_array_get_length (SQLHeavyValueArray* self) {
	gint result;
	GValue** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->values;
	_tmp0__length1 = self->priv->values_length1;
	if (_tmp0_ != NULL) {
		GValue** _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->values;
		_tmp1__length1 = self->priv->values_length1;
		result = _tmp1__length1;
		return result;
	} else {
		SQLHeavyValueArray* _tmp2_;
		SQLHeavyValueArray* _tmp3_;
		_tmp2_ = sql_heavy_value_array_get_source (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			SQLHeavyValueArray* _tmp4_;
			SQLHeavyValueArray* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp4_ = sql_heavy_value_array_get_source (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = sql_heavy_value_array_get_length (_tmp5_);
			_tmp7_ = _tmp6_;
			result = _tmp7_;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void sql_heavy_value_array_class_init (SQLHeavyValueArrayClass * klass) {
	sql_heavy_value_array_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyValueArrayPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_value_array_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_value_array_set_property;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_value_array_finalize;
	/**
	     * The source array, or null if none
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_VALUE_ARRAY_SOURCE, g_param_spec_object ("source", "source", "source", SQL_HEAVY_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The length of the array
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_VALUE_ARRAY_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The position of one of the elements in the array changed
	     */
	g_signal_new ("position_changed", SQL_HEAVY_TYPE_VALUE_ARRAY, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	/**
	     * The value of one of the elements in the array changed
	     */
	g_signal_new ("value_changed", SQL_HEAVY_TYPE_VALUE_ARRAY, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void sql_heavy_value_array_instance_init (SQLHeavyValueArray * self) {
	self->priv = SQL_HEAVY_VALUE_ARRAY_GET_PRIVATE (self);
	self->priv->_source = NULL;
	self->priv->to_source_map = NULL;
	self->priv->values = NULL;
}


static void sql_heavy_value_array_finalize (GObject* obj) {
	SQLHeavyValueArray * self;
	self = SQL_HEAVY_VALUE_ARRAY (obj);
	_g_object_unref0 (self->priv->_source);
	self->priv->to_source_map = (g_free (self->priv->to_source_map), NULL);
	self->priv->values = (_vala_array_free (self->priv->values, self->priv->values_length1, (GDestroyNotify) _vala_GValue_free), NULL);
	G_OBJECT_CLASS (sql_heavy_value_array_parent_class)->finalize (obj);
}


/**
   * A copy-on-write array of GValues
   */
GType sql_heavy_value_array_get_type (void) {
	static volatile gsize sql_heavy_value_array_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_value_array_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyValueArrayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_value_array_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyValueArray), 0, (GInstanceInitFunc) sql_heavy_value_array_instance_init, NULL };
		GType sql_heavy_value_array_type_id;
		sql_heavy_value_array_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyValueArray", &g_define_type_info, 0);
		g_once_init_leave (&sql_heavy_value_array_type_id__volatile, sql_heavy_value_array_type_id);
	}
	return sql_heavy_value_array_type_id__volatile;
}


static void _vala_sql_heavy_value_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyValueArray * self;
	self = SQL_HEAVY_VALUE_ARRAY (object);
	switch (property_id) {
		case SQL_HEAVY_VALUE_ARRAY_SOURCE:
		g_value_set_object (value, sql_heavy_value_array_get_source (self));
		break;
		case SQL_HEAVY_VALUE_ARRAY_LENGTH:
		g_value_set_int (value, sql_heavy_value_array_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_value_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyValueArray * self;
	self = SQL_HEAVY_VALUE_ARRAY (object);
	switch (property_id) {
		case SQL_HEAVY_VALUE_ARRAY_SOURCE:
		sql_heavy_value_array_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



